/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.gui.dialogs;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.creeperhost.minetogether.repack.net.covers1624.quack.collection.FastStream;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextMenu
extends GuiElement<ContextMenu>
implements BackgroundRender {
    private final int maxWidth;
    private LinkedList<GuiElement<?>> menuElements = new LinkedList();
    private Map<GuiElement<?>, Runnable> options = new HashMap();
    private double menuWidth = 0.0;
    private double menuHeight = 0.0;

    public ContextMenu(@NotNull GuiParent<?> parent) {
        this(parent, 300);
    }

    public ContextMenu(@NotNull GuiParent<?> parent, int maxWidth) {
        super(parent);
        this.maxWidth = maxWidth;
        this.setOpaque(true);
        this.constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> this.menuWidth));
        this.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> this.menuHeight));
    }

    public void addTitle(Component title) {
        this.addOption(title, null);
    }

    public void addOption(Component option, @Nullable Runnable runnable) {
        int height = this.font().wordWrapHeight((FormattedText)option, this.maxWidth);
        int width = Math.min(this.maxWidth, this.font().width((FormattedText)option));
        GuiElement container = (GuiElement)((GuiElement)new GuiElement((GuiParent)this).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)(height + 3)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)(width + 4)));
        if (runnable != null) {
            GuiRectangle background = (GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)new GuiRectangle((GuiParent)container).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)container.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)container.get(GeoParam.BOTTOM)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-2.0));
            background.fill(() -> background.isMouseOver() ? 0x50FFFFFF : 0);
        }
        ((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)container, option).setAlignment(Align.LEFT).setWrap(true).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)container.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)container.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)container.get(GeoParam.TOP), (double)1.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)height));
        this.menuElements.add(container);
        if (runnable != null) {
            this.options.put(container, runnable);
        }
        this.arrangeElements();
    }

    private void arrangeElements() {
        double yOffset = 2.0;
        double width = 0.0;
        for (GuiElement guiElement : this.menuElements) {
            guiElement.constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), (double)yOffset));
            guiElement.constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)2.0));
            yOffset += guiElement.ySize();
            width = Math.max(width, guiElement.xSize());
        }
        this.menuHeight = yOffset + 3.0;
        this.menuWidth = width + 4.0;
    }

    public void setPosition(double mouseX, double mouseY) {
        this.constrain(GeoParam.LEFT, (Constraint)Constraint.literal((double)Math.min(mouseX, (double)this.scaledScreenWidth() - this.xSize())));
        this.constrain(GeoParam.TOP, (Constraint)Constraint.literal((double)Math.min(mouseY, (double)this.scaledScreenHeight() - this.ySize())));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button, boolean consumed) {
        if (this.isMouseOver()) {
            for (GuiElement guiElement : this.menuElements) {
                if (!this.options.containsKey(guiElement) || !guiElement.isMouseOver() && !FastStream.of(guiElement.getChildren()).anyMatch(GuiElement::isMouseOver)) continue;
                this.options.get(guiElement).run();
                this.mc().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                break;
            }
        }
        this.getParent().removeChild((GuiElement)this);
        return true;
    }

    public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        render.toolTipBackground(this.xMin(), this.yMin(), this.xSize(), this.ySize(), -15728624, -11534081, -14155649);
    }
}

