/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat.irc.pircbotx;

import java.time.Instant;
import java.util.Collections;
import java.util.List;
import net.creeperhost.minetogether.lib.chat.ChatState;
import net.creeperhost.minetogether.lib.chat.irc.AbstractChannel;
import net.creeperhost.minetogether.lib.chat.message.MessageUtils;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.repack.net.covers1624.quack.collection.FastStream;
import net.creeperhost.minetogether.repack.org.pircbotx.Channel;
import net.creeperhost.minetogether.repack.org.pircbotx.UserHostmask;
import org.jetbrains.annotations.Nullable;

public class PircBotChannel
extends AbstractChannel {
    @Nullable
    private Channel channel;

    public PircBotChannel(ChatState chatState, String name) {
        super(chatState, name);
    }

    @Override
    public void sendMessage(String message) {
        if (this.channel != null) {
            SEND_EXECUTOR.execute(() -> this.channel.send().message(MessageUtils.processOutboundMessage(this.chatState.profileManager, message)));
            this.addMessage(Instant.now(), this.chatState.profileManager.getOwnProfile(), message);
        }
    }

    @Override
    public void part(String reason) {
        if (this.channel != null) {
            SEND_EXECUTOR.execute(() -> this.channel.send().part(reason));
        }
    }

    @Override
    public void setInviteOnly() {
        if (this.channel != null) {
            SEND_EXECUTOR.execute(() -> this.channel.send().setInviteOnly());
        }
    }

    @Override
    public List<Profile> getUsers() {
        if (this.channel != null) {
            return FastStream.of(this.channel.getUsers()).map(UserHostmask::getNick).map(this.chatState.profileManager::lookupProfile).toList();
        }
        return Collections.emptyList();
    }

    public void bindChannel(@Nullable Channel channel) {
        this.channel = channel;
    }
}

