/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.web;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class WebUtils {
    public static boolean permitsRequestBody(String method) {
        return !method.equalsIgnoreCase("GET") && !method.equalsIgnoreCase("HEAD");
    }

    public static boolean requiresRequestBody(String method) {
        return method.equalsIgnoreCase("POST") || method.equalsIgnoreCase("PUT") || method.equalsIgnoreCase("PATCH") || method.equalsIgnoreCase("PROPPATCH") || method.equalsIgnoreCase("REPORT");
    }

    public static String encodeQueryParameters(String url, Iterable<UrlParamPair> parameters) {
        String encoded = WebUtils.encodeParameters(parameters);
        if (encoded.isEmpty()) {
            return url;
        }
        return url + "?" + encoded;
    }

    public static String encodeParameters(Iterable<UrlParamPair> parameters) {
        StringBuilder builder = new StringBuilder();
        for (UrlParamPair entry : parameters) {
            if (builder.length() > 0) {
                builder.append("&");
            }
            try {
                builder.append(URLEncoder.encode(entry.key, "UTF-8")).append("=").append(URLEncoder.encode(entry.value, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("UTF-8 is guaranteed to exist?", ex);
            }
        }
        return builder.toString();
    }

    public static class UrlParamPair {
        public final String key;
        public final String value;

        public UrlParamPair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public static UrlParamPair of(String key, String value) {
            return new UrlParamPair(key, value);
        }
    }
}

