/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.mixin.chat;

import java.net.URL;
import java.util.Objects;
import net.creeperhost.minetogether.chat.ChatConstants;
import net.creeperhost.minetogether.chat.ChatStatistics;
import net.creeperhost.minetogether.chat.ChatTarget;
import net.creeperhost.minetogether.chat.FriendChatNotifier;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.chat.gui.ChatScreenInjection;
import net.creeperhost.minetogether.chat.gui.FriendChatGui;
import net.creeperhost.minetogether.chat.ingame.MTChatComponent;
import net.creeperhost.minetogether.config.LocalConfig;
import net.creeperhost.minetogether.gui.PreviewElement;
import net.creeperhost.minetogether.gui.SettingGui;
import net.creeperhost.minetogether.lib.chat.irc.IrcState;
import net.creeperhost.minetogether.lib.chat.message.Message;
import net.creeperhost.minetogether.polylib.gui.IconButton;
import net.creeperhost.minetogether.polylib.gui.RadioButton;
import net.creeperhost.minetogether.polylib.gui.SlideButton;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.ModularGuiInjector;
import net.creeperhost.polylib.client.modulargui.lib.GuiProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatScreen.class})
abstract class ChatScreenMixin
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private RadioButton vanillaChatButton;
    private RadioButton mtChatButton;
    private RadioButton groupChatButton;
    private SlideButton chatScaleSlider;
    private SlideButton chatWidthSlider;
    private SlideButton chatHeightSlider;
    private IconButton settingsButton;
    @Nullable
    private Message clickedMessage;
    @Shadow
    protected EditBox input;
    @Shadow
    CommandSuggestions commandSuggestions;
    @Shadow
    private String initial;
    private Button newUserButton;
    private Button disableButton;

    @Shadow
    @Nullable
    protected abstract Style getComponentStyleAt(double var1, double var3);

    protected ChatScreenMixin(Component component) {
        super(component);
    }

    @Inject(method={"init()V"}, at={@At(value="TAIL")})
    private void onInit(CallbackInfo ci) {
        Minecraft mc = Minecraft.getInstance();
        if (!LocalConfig.instance().chatEnabled || mc.options.hideGui) {
            return;
        }
        ChatComponent chat = mc.gui.getChat();
        float cScale = (float)chat.getScale();
        int cWidth = Mth.ceil((float)((float)chat.getWidth() + 12.0f * cScale));
        int cHeight = Mth.ceil((float)((float)chat.getHeight() * cScale));
        this.vanillaChatButton = ((RadioButton)this.addRenderableWidget((GuiEventListener)new RadioButton(0, 0, 12, 100, (Component)(mc.isLocalServer() ? Component.translatable((String)"minetogether:ingame.chat.local") : Component.translatable((String)"minetogether:ingame.chat.server"))))).withAutoScaleText(3).withVerticalText().selectedSupplier(() -> MineTogetherChat.getTarget() == ChatTarget.VANILLA).onPressed(e -> MineTogetherChat.setTarget(ChatTarget.VANILLA)).onRelease(() -> this.setFocused((GuiEventListener)this.input));
        this.mtChatButton = ((RadioButton)this.addRenderableWidget((GuiEventListener)new RadioButton(0, 0, 12, 100, (Component)Component.translatable((String)"minetogether:ingame.chat.global")))).withAutoScaleText(3).withVerticalText().selectedSupplier(() -> MineTogetherChat.getTarget() == ChatTarget.PUBLIC).onPressed(e -> MineTogetherChat.setTarget(ChatTarget.PUBLIC)).onRelease(() -> this.setFocused((GuiEventListener)this.input));
        this.groupChatButton = ((RadioButton)this.addRenderableWidget((GuiEventListener)new RadioButton(0, 0, 12, 100, (Component)Component.translatable((String)"minetogether:ingame.chat.group")))).withAutoScaleText(3).withVerticalText().selectedSupplier(() -> MineTogetherChat.getTarget() == ChatTarget.GROUP).onPressed(e -> MineTogetherChat.setTarget(ChatTarget.GROUP)).onRelease(() -> this.setFocused((GuiEventListener)this.input));
        this.settingsButton = (IconButton)this.addRenderableWidget((GuiEventListener)new IconButton(0, 0, 12, 12, new ResourceLocation("minetogether", "textures/gui/buttons/gear.png"), e -> mc.setScreen((Screen)new SettingGui.Screen(mc.screen))));
        this.chatScaleSlider = ((SlideButton)this.addRenderableWidget((GuiEventListener)new SlideButton(0, 0, 12, 200))).setDynamicMessage(() -> Component.translatable((String)"options.percent_value", (Object[])new Object[]{Component.translatable((String)"options.chat.scale"), (int)((Double)mc.options.chatScale().get() * 100.0)})).bindValue(() -> (Double)mc.options.chatScale().get(), value -> {
            mc.options.chatScale().set(value);
            this.updateButtons();
        }).setRange(0.25, 1.0).withTextScale(0.75f).onRelease(() -> this.setFocused((GuiEventListener)this.input)).setEnabled(() -> this.commandSuggestions.suggestions == null && LocalConfig.instance().chatSettingsSliders).withAutoScaleText(3);
        this.chatWidthSlider = ((SlideButton)this.addRenderableWidget((GuiEventListener)new SlideButton(0, 0, 12, 200))).setDynamicMessage(newValue -> Component.translatable((String)"options.pixel_value", (Object[])new Object[]{Component.translatable((String)"options.chat.width"), ChatComponent.getWidth((double)newValue)})).bindValue(() -> (Double)mc.options.chatWidth().get(), value -> {
            mc.options.chatWidth().set(value);
            this.updateButtons();
        }).withTextScale(0.75f).onRelease(() -> this.setFocused((GuiEventListener)this.input)).setApplyOnRelease(true).setEnabled(() -> this.commandSuggestions.suggestions == null && LocalConfig.instance().chatSettingsSliders).withAutoScaleText(3);
        this.chatHeightSlider = ((SlideButton)this.addRenderableWidget((GuiEventListener)new SlideButton(0, 0, 12, 200))).setDynamicMessage(() -> Component.translatable((String)"options.pixel_value", (Object[])new Object[]{Component.translatable((String)"options.chat.height.focused"), ChatComponent.getHeight((double)((Double)mc.options.chatHeightFocused().get()))})).bindValue(() -> (Double)mc.options.chatHeightFocused().get(), value -> {
            mc.options.chatHeightFocused().set(value);
            this.updateButtons();
        }).withTextScale(0.75f).onRelease(() -> this.setFocused((GuiEventListener)this.input)).setEnabled(() -> this.commandSuggestions.suggestions == null && LocalConfig.instance().chatSettingsSliders).withAutoScaleText(3);
        this.updateButtons();
        this.newUserButton = (Button)this.addWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("Join " + ChatStatistics.onlineCount + " online users now!")), e -> {
            MineTogetherChat.setNewUserResponded();
            this.setFocused((GuiEventListener)this.input);
        }).bounds(6, this.height - (cHeight + 80) / 2 + 45, cWidth - 2, 20).build());
        this.disableButton = (Button)this.addWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Don't ask me again."), e -> {
            MineTogetherChat.disableChat();
            LocalConfig.instance().chatEnabled = false;
            LocalConfig.save();
            MineTogetherChat.setNewUserResponded();
            this.clearWidgets();
            this.setFocused((GuiEventListener)this.input);
        }).bounds(6, this.height - (cHeight + 80) / 2 + 70, cWidth - 2, 20).build());
        this.newUserButton.visible = false;
        this.disableButton.visible = false;
        if (MineTogetherChat.isNewUser() && MineTogetherChat.getTarget() == ChatTarget.PUBLIC) {
            ChatStatistics.pollStats();
            this.newUserButton.visible = true;
            this.disableButton.visible = true;
        }
        this.switchToVanillaIfCommand();
        ModularGui gui = ModularGuiInjector.getActiveGui();
        if (gui != null && gui.getProvider() instanceof ChatScreenInjection) {
            ChatScreenInjection.setURLProvider(this::getUrlUnderMouse);
        }
    }

    private void updateButtons() {
        Minecraft mc = Minecraft.getInstance();
        if (!LocalConfig.instance().chatEnabled || mc.options.hideGui) {
            return;
        }
        ChatComponent chat = mc.gui.getChat();
        float cScale = (float)chat.getScale();
        int cWidth = Mth.ceil((float)((float)chat.getWidth() + 12.0f * cScale));
        int cHeight = Mth.ceil((float)((float)chat.getHeight() * cScale)) - 12;
        int guiHeight = this.height;
        int cMaxYPos = guiHeight - 40;
        boolean groupChat = MineTogetherChat.CHAT_STATE.profileManager.getPrivateGroup() != null;
        int vanillaYPos = cMaxYPos - cHeight - 12;
        int vanillaHeight = groupChat ? cHeight / 3 : cHeight / 2;
        this.vanillaChatButton.updateBounds(cWidth, vanillaYPos, 12, vanillaHeight);
        int mtYPos = vanillaYPos + vanillaHeight;
        int mtHeight = groupChat ? cHeight / 3 : cMaxYPos - mtYPos - 12;
        this.mtChatButton.updateBounds(cWidth, mtYPos, 12, mtHeight);
        int groupYPos = mtYPos + mtHeight;
        int groupHeight = groupChat ? cMaxYPos - groupYPos - 12 : 0;
        this.groupChatButton.updateBounds(cWidth, groupYPos, 12, groupHeight);
        this.groupChatButton.visible = groupChat;
        this.settingsButton.updateBounds(cWidth, groupChat ? groupYPos + groupHeight : mtYPos + mtHeight, 12, 12);
        int sliderWidth = cWidth / 3;
        this.chatWidthSlider.updateBounds(0, cMaxYPos + 2, sliderWidth, 10);
        this.chatHeightSlider.updateBounds(sliderWidth + 2, cMaxYPos + 2, sliderWidth, 10);
        this.chatScaleSlider.updateBounds(sliderWidth * 2 + 4, cMaxYPos + 2, cWidth - sliderWidth * 2 - 4, 10);
    }

    @Inject(method={"mouseClicked(DDI)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        ClickEvent clickEvent;
        Style style = this.getComponentStyleAt(mouseX, mouseY);
        if (style != null && (clickEvent = style.getClickEvent()) instanceof FriendChatNotifier.OpenFriendEvent) {
            FriendChatNotifier.OpenFriendEvent event = (FriendChatNotifier.OpenFriendEvent)clickEvent;
            FriendChatGui.setSelected(event.profile);
            Minecraft.getInstance().setScreen((Screen)new FriendChatGui.Screen(null));
            cir.setReturnValue((Object)true);
        }
        if (!LocalConfig.instance().chatEnabled || Minecraft.getInstance().options.hideGui) {
            return;
        }
        if (MineTogetherChat.getTarget() == ChatTarget.PUBLIC && button == 0 && style != null && this.handleComponentClicked(style)) {
            this.initial = this.input.getValue();
            cir.setReturnValue((Object)true);
        }
        if (MineTogetherChat.getTarget() == ChatTarget.PUBLIC && this.tryClickMTChat(MineTogetherChat.publicChat, mouseX, mouseY)) {
            cir.setReturnValue((Object)true);
        }
    }

    public boolean mouseReleased(double d, double e, int i) {
        Minecraft mc = Minecraft.getInstance();
        if (!LocalConfig.instance().chatEnabled || mc.options.hideGui) {
            return super.mouseReleased(d, e, i);
        }
        this.chatWidthSlider.mouseReleased(d, e, i);
        this.chatHeightSlider.mouseReleased(d, e, i);
        this.chatScaleSlider.mouseReleased(d, e, i);
        this.setFocused((GuiEventListener)this.input);
        return super.mouseReleased(d, e, i);
    }

    public boolean keyReleased(int i, int j, int k) {
        this.setFocused((GuiEventListener)this.input);
        return super.keyReleased(i, j, k);
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="TAIL")})
    private void onRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        if (MineTogetherChat.getTarget() == ChatTarget.PUBLIC && MineTogetherChat.isNewUser()) {
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 100.0f);
            MTChatComponent chatComponent = MineTogetherChat.publicChat;
            Objects.requireNonNull(this.minecraft.font);
            int y = this.height - 43 - 9 * Math.max(Math.min(chatComponent.getRecentChat().size(), chatComponent.getLinesPerPage()), 20);
            graphics.fill(0, y, chatComponent.getWidth() + 6, chatComponent.getHeight() + 10 + y, -1728053248);
            graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"minetogether:new_user.1"), chatComponent.getWidth() / 2 + 3, this.height - (chatComponent.getHeight() + 80) / 2, 0xFFFFFF);
            graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"minetogether:new_user.2"), chatComponent.getWidth() / 2 + 3, this.height - (chatComponent.getHeight() + 80) / 2 + 10, 0xFFFFFF);
            graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"minetogether:new_user.3"), chatComponent.getWidth() / 2 + 3, this.height - (chatComponent.getHeight() + 80) / 2 + 20, 0xFFFFFF);
            graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"minetogether:new_user.4", (Object[])new Object[]{ChatStatistics.userCount}), chatComponent.getWidth() / 2 + 3, this.height - (chatComponent.getHeight() + 80) / 2 + 30, 0xFFFFFF);
            this.newUserButton.render(graphics, mouseX, mouseY, partialTicks);
            this.disableButton.render(graphics, mouseX, mouseY, partialTicks);
            graphics.pose().popPose();
        }
    }

    public void tick() {
        this.switchToVanillaIfCommand();
        if (this.groupChatButton != null && this.groupChatButton.visible == (MineTogetherChat.CHAT_STATE.profileManager.getPrivateGroup() == null)) {
            this.updateButtons();
        }
        if (MineTogetherChat.getTarget() == ChatTarget.VANILLA) {
            this.input.setEditable(true);
            this.input.setSuggestion("");
            return;
        }
        if (MineTogetherChat.isNewUser()) {
            this.newUserButton.visible = true;
            this.disableButton.visible = true;
            this.input.setEditable(false);
            return;
        }
        IrcState state = MineTogetherChat.CHAT_STATE.ircClient.getState();
        if (state != IrcState.CONNECTED) {
            this.input.setEditable(false);
            this.input.setSuggestion(Component.translatable((String)ChatConstants.STATE_SUGGESTION_LOOKUP.get((Object)state)).getString());
            return;
        }
        this.input.setEditable(true);
        this.input.setSuggestion("");
    }

    private boolean tryClickMTChat(MTChatComponent mtChat, double mouseX, double mouseY) {
        ChatScreenInjection injection;
        GuiProvider guiProvider;
        if (!mtChat.handleClick(mouseX, mouseY)) {
            return false;
        }
        Message message = mtChat.getClickedMessage();
        if (message == null) {
            return false;
        }
        ModularGui gui = ModularGuiInjector.getActiveGui();
        if (gui != null && (guiProvider = gui.getProvider()) instanceof ChatScreenInjection && (injection = (ChatScreenInjection)guiProvider).canShowDialog()) {
            this.clickedMessage = message;
            mtChat.clearClickedMessage();
            injection.openMessageDialog(this.clickedMessage, this.input, mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Nullable
    private PreviewElement.URLInfo getUrlUnderMouse(double mouseX, double mouseY) {
        if (MineTogetherChat.getTarget() != ChatTarget.PUBLIC) {
            return null;
        }
        Style style = MineTogetherChat.publicChat.getStyleUnderMouse(mouseX, mouseY);
        URL url = PreviewElement.urlFromStyle(style);
        if (url == null) {
            return null;
        }
        Message message = MineTogetherChat.publicChat.getMessageUnderMouse(mouseX, mouseY);
        return new PreviewElement.URLInfo(url, message != null && message.sender == null);
    }

    @Inject(method={"handleChatInput(Ljava/lang/String;Z)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHandleChatInput(String message, boolean bl, CallbackInfoReturnable<Boolean> cir) {
        String normalized = this.normalizeChatMessage(message);
        if (MineTogetherChat.getTarget() == ChatTarget.PUBLIC && !normalized.isEmpty()) {
            MineTogetherChat.publicChat.addRecentChat(message);
            cir.setReturnValue((Object)true);
        }
    }

    @Shadow
    public abstract String normalizeChatMessage(String var1);

    private boolean switchToVanillaIfCommand() {
        if (MineTogetherChat.getTarget() == ChatTarget.VANILLA) {
            return false;
        }
        if (!this.input.getValue().startsWith("/")) {
            return false;
        }
        MineTogetherChat.setTarget(ChatTarget.VANILLA);
        return true;
    }
}

