/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.mixin.chat.ingame;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.creeperhost.minetogether.Constants;
import net.creeperhost.minetogether.chat.ChatTarget;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.config.LocalConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.util.ArrayListDeque;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChatComponent.class})
abstract class ChatComponentMixin {
    @Final
    @Shadow
    private Minecraft minecraft;

    ChatComponentMixin() {
    }

    @Shadow
    public abstract int getHeight();

    @Shadow
    public abstract int getWidth();

    @Shadow
    public abstract double getScale();

    @Shadow
    protected abstract boolean isChatFocused();

    @Shadow
    public abstract ArrayListDeque<String> getRecentChat();

    @Shadow
    public abstract int getLinesPerPage();

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;III)V"}, at={@At(value="HEAD")})
    private void onRender(GuiGraphics graphics, int i, int mouseX, int mouseY, CallbackInfo ci) {
        if (!LocalConfig.instance().chatEnabled || Minecraft.getInstance().options.hideGui || !this.isChatFocused()) {
            return;
        }
        float scale = (float)this.getScale();
        int width = Mth.ceil((float)((float)this.getWidth() + 12.0f * scale));
        int height = Mth.ceil((float)((float)this.getHeight() * scale));
        int guiHeight = graphics.guiHeight();
        int maxYPos = guiHeight - 40;
        graphics.fill(0, maxYPos - height, width, maxYPos, this.minecraft.options.getBackgroundColor(Integer.MIN_VALUE));
        if (MineTogetherChat.getTarget() != ChatTarget.VANILLA) {
            int logoSize = (int)((double)Math.min(width, height) * 0.9);
            ChatComponentMixin.drawLogo(graphics, this.minecraft.font, -4 + width / 2 - logoSize / 2, maxYPos - height / 2 - logoSize / 2, logoSize, logoSize);
        }
    }

    @Redirect(method={"render(Lnet/minecraft/client/gui/GuiGraphics;III)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V", ordinal=0))
    private void onFill(GuiGraphics graphics, int i, int j, int k, int l, int m) {
        if (!this.isChatFocused() || !LocalConfig.instance().chatEnabled || Minecraft.getInstance().options.hideGui) {
            graphics.fill(i, j, k, l, m);
        }
    }

    @Inject(method={"rescaleChat()V"}, at={@At(value="HEAD")})
    private void onRescaleChat(CallbackInfo ci) {
        if (MineTogetherChat.getTarget() == ChatTarget.VANILLA) {
            MineTogetherChat.publicChat.rescaleChat();
        }
    }

    private static void drawLogo(GuiGraphics g, Font font, int x, int y, int width, int height) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String created = "Created by";
        int strWidth = font.width(created);
        int creeperHeight = 19;
        int creeperWidth = (int)((double)creeperHeight * 3.6090225563909772);
        int createdWidth = strWidth + 2 + creeperWidth;
        float createdScale = (float)width / (float)createdWidth;
        Objects.requireNonNull(font);
        int creeperOffset = (int)(9.0 / 2.0 - (double)creeperHeight / 2.0);
        int creeperSHeight = (int)((float)creeperHeight * createdScale);
        g.pose().pushPose();
        g.pose().translate((float)x, (float)(y + height) - (float)creeperHeight * createdScale - (float)creeperOffset, 0.0f);
        g.pose().scale(createdScale, createdScale, createdScale);
        RenderSystem.enableBlend();
        g.blit(Constants.CREEPERHOST_LOGO_25, createdWidth - creeperWidth, creeperOffset, 0.0f, 0.0f, creeperWidth, creeperHeight, creeperWidth, creeperHeight);
        g.drawString(font, created, 0, 0, 0x40FFFFFF, true);
        g.pose().popPose();
        int mtHeight = height - creeperSHeight - 4;
        int mtWidth = (int)((double)mtHeight * 1.0943396226415094);
        RenderSystem.enableBlend();
        g.blit(Constants.MINETOGETHER_LOGO_25, x + (int)((double)width / 2.0 - (double)mtWidth / 2.0), y, 0.0f, 0.0f, mtWidth, mtHeight, mtWidth, mtHeight);
        RenderSystem.disableBlend();
    }
}

