/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.mixin.connect;

import net.creeperhost.minetogether.connect.ConnectHandler;
import net.creeperhost.minetogether.connect.gui.FriendConnectScreen;
import net.creeperhost.minetogether.connect.gui.FriendServerEntry;
import net.creeperhost.minetogether.connect.gui.ServerListAppender;
import net.creeperhost.minetogether.orderform.CreeperHostServerEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={JoinMultiplayerScreen.class})
public abstract class JoinMultiplayerScreenMixin {
    @Shadow
    protected ServerSelectionList serverSelectionList;

    @Shadow
    protected abstract void join(ServerData var1);

    private JoinMultiplayerScreen getThis() {
        return (JoinMultiplayerScreen)this;
    }

    @Inject(at={@At(value="TAIL")}, method={"init()V"})
    public void init(CallbackInfo ci) {
        if (ConnectHandler.isEnabled()) {
            ServerListAppender.INSTANCE.init(this.serverSelectionList, this.getThis());
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"removed()V"})
    public void removed(CallbackInfo ci) {
        ServerListAppender.INSTANCE.remove();
    }

    @Inject(at={@At(value="HEAD")}, method={"joinSelectedServer()V"}, cancellable=true)
    public void joinSelectedServer(CallbackInfo ci) {
        ServerSelectionList.Entry entry = (ServerSelectionList.Entry)this.serverSelectionList.getSelected();
        if (entry instanceof CreeperHostServerEntry) {
            ci.cancel();
        } else if (entry instanceof FriendServerEntry) {
            FriendServerEntry friendServer = (FriendServerEntry)entry;
            FriendConnectScreen.startConnecting((Screen)this.getThis(), Minecraft.getInstance(), friendServer.remoteServer, friendServer.getServerData());
            ci.cancel();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    public void tick(CallbackInfo ci) {
        if (ConnectHandler.isEnabled()) {
            ServerListAppender.INSTANCE.tick();
        }
    }
}

