/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.oauth;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.com.github.scribejava.apis.KeycloakApi;
import net.creeperhost.minetogether.com.github.scribejava.core.builder.ServiceBuilder;
import net.creeperhost.minetogether.com.github.scribejava.core.model.OAuth2AccessToken;
import net.creeperhost.minetogether.com.github.scribejava.core.model.OAuthRequest;
import net.creeperhost.minetogether.com.github.scribejava.core.model.Response;
import net.creeperhost.minetogether.com.github.scribejava.core.model.Verb;
import net.creeperhost.minetogether.com.github.scribejava.core.oauth.AccessTokenRequestParams;
import net.creeperhost.minetogether.com.github.scribejava.core.oauth.AuthorizationUrlBuilder;
import net.creeperhost.minetogether.com.github.scribejava.core.oauth.OAuth20Service;
import net.creeperhost.minetogether.oauth.OAuthWebServer;
import net.creeperhost.minetogether.oauth.ServerAuthTest;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeycloakOAuth {
    private static final Logger LOGGER = LogManager.getLogger();
    static OAuthWebServer server;

    public static void main(String[] args) {
        Random random = new Random();
        String apiKey = "mt-ingame";
        String baseUrl = "https://auth.minetogether.io/";
        String realm = "MineTogether";
        String secretState = "oHaiICanHazSecret" + random.nextInt(999999);
        String protectedResourceUrl = "https://auth.minetogether.io/auth/realms/MineTogether/linksearch";
        int port = -1;
        if (server != null && server.isAlive()) {
            server.stop();
        }
        server = null;
        for (int i = 0; i < 5 && server == null; ++i) {
            try {
                port = 1000 + random.nextInt(64535);
                server = new OAuthWebServer(false, port);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (server == null) {
            return;
        }
        String callback = "http://localhost:" + port;
        OAuth20Service service = new ServiceBuilder("mt-ingame").apiSecret("d3b0c03e-4447-400b-ba48-e08902cd95d6").defaultScope("openid").callback(callback).responseType("code").build(KeycloakApi.instance("https://auth.minetogether.io/", "MineTogether"));
        AuthorizationUrlBuilder authorizationUrlBuilder = service.createAuthorizationUrlBuilder().state(secretState).initPKCE();
        try {
            KeycloakOAuth.openURL(new URL(authorizationUrlBuilder.build()));
        }
        catch (MalformedURLException ignored) {
            server.stop();
        }
        server.setCodeHandler((code, state) -> {
            try {
                JsonElement parse;
                if (!state.equals(secretState)) {
                    return;
                }
                OAuth2AccessToken accessToken = service.getAccessToken(AccessTokenRequestParams.create(code).pkceCodeVerifier(authorizationUrlBuilder.getPkce().getCodeVerifier()));
                OAuthRequest request = new OAuthRequest(Verb.GET, "https://auth.minetogether.io/auth/realms/MineTogether/linksearch");
                service.signRequest(accessToken, request);
                Response response = service.execute(request);
                if (response.getCode() != 200) {
                    return;
                }
                JsonParser parser = new JsonParser();
                try {
                    parse = parser.parse(response.getBody());
                }
                catch (JsonParseException e) {
                    return;
                }
                if (parse.isJsonObject()) {
                    boolean doAuth = true;
                    try {
                        JsonObject profile = parse.getAsJsonObject();
                        if (profile.has("federatedIdentities")) {
                            JsonArray identities = profile.getAsJsonArray("federatedIdentities");
                            for (JsonElement identity : identities) {
                                if (!identity.isJsonObject() || !identity.getAsJsonObject().has("identityProvider") || !identity.getAsJsonObject().getAsJsonPrimitive("identityProvider").getAsString().equals("mcauth") || !identity.getAsJsonObject().get("userId").getAsString().equals(Minecraft.getInstance().player.getStringUUID())) continue;
                                doAuth = false;
                            }
                        }
                    }
                    catch (Throwable e) {
                        doAuth = true;
                    }
                    if (doAuth) {
                        ServerAuthTest.auth((authed, mcauthcode) -> {
                            if (authed.booleanValue()) {
                                OAuthRequest request2 = new OAuthRequest(Verb.POST, "https://auth.minetogether.io/auth/realms/MineTogether/linksearch/linkmc/" + mcauthcode);
                                service.signRequest(accessToken, request2);
                                try {
                                    Response response = service.execute(request2);
                                }
                                catch (IOException | InterruptedException | ExecutionException e) {
                                    e.printStackTrace();
                                }
                            }
                            return null;
                        });
                    }
                }
                KeycloakOAuth.closeServer();
            }
            catch (Exception e) {
                e.printStackTrace();
                KeycloakOAuth.closeServer();
            }
        });
    }

    public static boolean openURL(URL url) {
        Util.OS os = Util.getPlatform();
        String[] cmdLine = switch (os) {
            case Util.OS.WINDOWS -> new String[]{"rundll32", "url.dll,FileProtocolHandler", url.toString()};
            case Util.OS.OSX -> new String[]{"open", url.toString()};
            default -> new String[]{"xdg-open", url.toString()};
        };
        try {
            Process browserProcess = AccessController.doPrivileged(() -> Runtime.getRuntime().exec(cmdLine));
            for (String errorLine : IOUtils.readLines((InputStream)browserProcess.getErrorStream())) {
                LOGGER.error(errorLine);
            }
            browserProcess.getInputStream().close();
            browserProcess.getErrorStream().close();
            browserProcess.getOutputStream().close();
            return true;
        }
        catch (IOException | PrivilegedActionException var5) {
            LOGGER.error("Couldn't open url '{}'", (Object)url, (Object)var5);
            return false;
        }
    }

    public static void closeServer() {
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                server.stop();
                timer.cancel();
                MineTogetherChat.CHAT_STATE.profileManager.refreshOwnProfile();
            }
        }, 1000L);
    }
}

