/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.oauth;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.creeperhost.minetogether.oauth.NetHandlerLoginClientOurs;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.ClientLoginPacketListener;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerAuthTest {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final AtomicInteger CONNECTION_ID = new AtomicInteger(0);
    private static boolean cancel = false;
    private static Connection networkManager = null;
    private static BiFunction<Boolean, String, Void> callback = null;
    static final String regex = "code: (\\w{5})";
    static final Pattern pattern = Pattern.compile("code: (\\w{5})");

    public static void auth(BiFunction<Boolean, String, Void> callbackIn) {
        callback = callbackIn;
        final Minecraft mc = Minecraft.getInstance();
        String address = "mc.auth.minetogether.io";
        int port = 25565;
        LOGGER.info("Connecting to {}, {}", (Object)"mc.auth.minetogether.io", (Object)25565);
        new Thread("Server Connector #" + CONNECTION_ID.incrementAndGet()){

            @Override
            public void run() {
                InetSocketAddress inetaddress = null;
                try {
                    if (cancel) {
                        return;
                    }
                    inetaddress = new InetSocketAddress(InetAddress.getByName("mc.auth.minetogether.io"), 25565);
                    networkManager = Connection.connectToServer((InetSocketAddress)inetaddress, (boolean)true, null);
                    networkManager.initiateServerboundPlayConnection("mc.auth.minetogether.io", 25565, (ClientLoginPacketListener)new NetHandlerLoginClientOurs(networkManager, mc));
                    networkManager.send((Packet)new ServerboundHelloPacket(mc.getUser().getName(), mc.getUser().getProfileId()));
                }
                catch (UnknownHostException unknownhostexception) {
                    if (cancel) {
                        return;
                    }
                    LOGGER.error("Couldn't connect to server", (Throwable)unknownhostexception);
                    ServerAuthTest.fireCallback(false, "Unknown Host");
                }
                catch (Exception exception) {
                    if (cancel) {
                        return;
                    }
                    LOGGER.error("Couldn't connect to server", (Throwable)exception);
                    ServerAuthTest.fireCallback(false, exception.getMessage());
                }
            }
        }.start();
    }

    public static void processPackets() {
        if (networkManager != null) {
            if (networkManager.isConnecting()) {
                networkManager.tick();
            } else {
                networkManager.handleDisconnection();
            }
        }
    }

    public static void disconnected(String reason) {
        Matcher matcher = pattern.matcher(reason);
        if (matcher.find()) {
            String code = matcher.group(1);
            ServerAuthTest.fireCallback(true, code);
        } else {
            ServerAuthTest.fireCallback(false, reason);
        }
        networkManager = null;
    }

    public static void fireCallback(boolean status, String message) {
        if (callback == null) {
            return;
        }
        callback.apply(status, message);
        callback = null;
    }
}

