/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.orderform;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.creeperhost.minetogether.config.LocalConfig;
import net.creeperhost.minetogether.orderform.OrderGui;
import net.creeperhost.polylib.client.screen.widget.buttons.ButtonString;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.server.LanServer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CreeperHostServerEntry
extends ServerSelectionList.NetworkServerEntry {
    private final Minecraft mc = Minecraft.getInstance();
    private final ResourceLocation serverIcon = new ResourceLocation("minetogether", "textures/creeperhost.png");
    private float transparency = 0.5f;
    protected final ResourceLocation BUTTON_TEXTURES = new ResourceLocation("minetogether", "textures/hidebtn.png");
    private ServerSelectionList serverSelectionList;
    private Button removeButton;

    public CreeperHostServerEntry(ServerSelectionList serverSelectionList) {
        super(null, new LanServer("", ""));
        this.serverSelectionList = serverSelectionList;
        this.removeButton = new ButtonString(0, 0, 10, 10, (Component)Component.translatable((String)(ChatFormatting.RED + new String(Character.toChars(10006)))), button -> {
            LocalConfig.instance().mpMenuEnabled = false;
            LocalConfig.save();
            this.mc.setScreen((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen()));
        });
    }

    public void render(GuiGraphics graphics, int slotIndex, int y, int x, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isHovering, float p_render_9_) {
        if (isHovering) {
            if (this.transparency <= 1.0f) {
                this.transparency = (float)((double)this.transparency + 0.04);
            }
        } else if (this.transparency >= 0.5f) {
            this.transparency = (float)((double)this.transparency - 0.04);
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.transparency);
        graphics.blit(this.serverIcon, x, y, 0.0f, 0.0f, 32, 32, 32, 32);
        int transparentString = (int)(this.transparency * 254.0f) << 24;
        graphics.drawString(this.mc.font, I18n.get((String)"minetogether.multiplayerscreen.partner", (Object[])new Object[0]), x + 35, y, 0xFFFFFF + transparentString);
        RenderSystem.enableBlend();
        Font font = this.mc.font;
        String string = I18n.get((String)"minetogether.multiplayerscreen.getserver", (Object[])new Object[0]);
        Objects.requireNonNull(this.mc.font);
        graphics.drawString(font, string, x + 32 + 3, y + 9 + 1, 0xFFFFFF + transparentString);
        String s = I18n.get((String)"minetogether.multiplayerscreen.clickherebrand", (Object[])new Object[0]);
        Font font2 = this.mc.font;
        Objects.requireNonNull(this.mc.font);
        graphics.drawString(font2, s, x + 32 + 3, y + 9 * 2 + 3, 0x808080 + transparentString);
        if (this.removeButton != null) {
            this.removeButton.render(graphics, x, y, p_render_9_);
            this.removeButton.setX(listWidth + x - Minecraft.getInstance().font.width(new String(Character.toChars(10006))) - 4);
            this.removeButton.setY(y);
            if (this.removeButton.isMouseOver((double)mouseX, (double)mouseY)) {
                int tooltipY = mouseY + (this.mc.screen.width / 2 >= mouseY ? 11 : -11);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.transparency);
                graphics.blit(this.BUTTON_TEXTURES, mouseX - 74, tooltipY - 1, 0.0f, 0.0f, 60, 10, 60, 10);
            }
        }
    }

    public boolean isMouseOver(double d, double e) {
        if (this.removeButton.isMouseOver(d, e)) {
            return true;
        }
        return super.isMouseOver(d, e);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.removeButton != null && this.removeButton.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        Minecraft.getInstance().setScreen((Screen)new OrderGui.Screen((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen())));
        return true;
    }
}

