/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.orderform;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldUploader {
    private static final ExecutorService UPLOAD_EXECUTOR = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("MT World Upload Thread %d").setDaemon(true).build());
    private static final String USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.138 Safari/537.36 Vivaldi/1.8.770.56 MineTogether/1.0.0";
    private static final Logger LOGGER = LogManager.getLogger();
    private final Path worldFolder;
    private Path tempZipFile;
    private volatile int stage = 0;
    private volatile double uploadProgress = 0.0;
    private Future<?> uploadTask = null;
    private String error;
    private String resultFileURL;
    private boolean finished = false;

    public WorldUploader(Path worldFolder) {
        this.worldFolder = worldFolder;
    }

    public boolean running() {
        return this.uploadTask != null && !this.uploadTask.isDone();
    }

    public Component getStatus() {
        if (this.stage == 0) {
            return Component.translatable((String)"minetogether:gui.order.upload_stage.start").withStyle(ChatFormatting.GRAY);
        }
        if (this.stage == 1) {
            return Component.translatable((String)"minetogether:gui.order.upload_stage.compress").withStyle(ChatFormatting.GREEN);
        }
        if (this.stage == 2) {
            return Component.translatable((String)"minetogether:gui.order.upload_stage.upload", (Object[])new Object[]{(double)Math.round(this.uploadProgress * 10000.0) / 100.0}).withStyle(ChatFormatting.BLUE);
        }
        return Component.empty();
    }

    public boolean errored() {
        return this.error != null;
    }

    public String getError() {
        return this.error;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public String getResultFileURL() {
        return this.resultFileURL;
    }

    public void start() {
        if (this.running()) {
            return;
        }
        this.stage = 0;
        this.finished = false;
        this.error = null;
        this.uploadProgress = 0.0;
        this.uploadTask = UPLOAD_EXECUTOR.submit(this::doUpload);
    }

    public void cancel() {
        if (this.uploadTask != null) {
            this.uploadTask.cancel(true);
            this.uploadTask = null;
        }
    }

    private void doUpload() {
        try {
            this.stage = 1;
            if (!this.compress()) {
                return;
            }
            this.stage = 2;
            if (!this.upload()) {
                return;
            }
            this.finished = true;
            this.uploadTask = null;
        }
        catch (Throwable e) {
            LOGGER.error("An error occurred while uploading world", e);
            this.error = "An error occurred while uploading world";
        }
    }

    private boolean compress() throws IOException {
        this.tempZipFile = Files.createTempFile("world_upload", ".zip", new FileAttribute[0]);
        final ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(this.tempZipFile, new OpenOption[0])));
        try {
            final Path folderName = Paths.get(this.worldFolder.getFileName().toString(), new String[0]);
            Files.walkFileTree(this.worldFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (!path.endsWith("session.lock")) {
                        String s1 = folderName.resolve(WorldUploader.this.worldFolder.relativize(path)).toString().replace('\\', '/');
                        ZipEntry zipentry = new ZipEntry(s1);
                        zos.putNextEntry(zipentry);
                        com.google.common.io.Files.asByteSource((File)path.toFile()).copyTo((OutputStream)zos);
                        zos.closeEntry();
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Throwable ex) {
            try {
                zos.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            LOGGER.error("An error occurred while compressing world: {}", (Object)this.worldFolder, (Object)ex);
            this.error = "Failed to compress world!";
            return false;
        }
        zos.close();
        return true;
    }

    private boolean upload() throws IOException {
        HttpPut httpput = new HttpPut("https://transfer.ch.tools/world.zip");
        httpput.setEntity((HttpEntity)new InputStreamEntity((InputStream)new InputStreamWrapper(Files.newInputStream(this.tempZipFile, new OpenOption[0]), Files.size(this.tempZipFile))));
        try (CloseableHttpClient client = HttpClients.custom().setUserAgent(USER_AGENT).build();){
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpput);
            StatusLine status = response.getStatusLine();
            if (status.getStatusCode() != 200) {
                LOGGER.error("Upload request failed. Returned response code: {}, Reason: {}", (Object)status.getStatusCode(), (Object)status.getReasonPhrase());
                this.error = "Upload failed with status code: " + status.getStatusCode();
                boolean bl = false;
                return bl;
            }
            HttpEntity entity = response.getEntity();
            this.resultFileURL = IOUtils.toString((InputStream)entity.getContent(), (Charset)StandardCharsets.UTF_8);
            boolean bl = true;
            return bl;
        }
    }

    public class InputStreamWrapper
    extends InputStream {
        private InputStream is;
        private long length;
        private long readPos;

        public InputStreamWrapper(InputStream inputStream, long length) {
            this.is = inputStream;
            this.length = length;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return (int)this.onRead(this.is.read(b));
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return (int)this.onRead(this.is.read(b, off, len));
        }

        @Override
        public long skip(long n) throws IOException {
            return this.onRead(this.is.skip(n));
        }

        @Override
        public int read() throws IOException {
            int read = this.is.read();
            this.onRead(1L);
            return read;
        }

        private long onRead(long readCount) {
            if (readCount != -1L) {
                this.readPos += readCount;
                WorldUploader.this.uploadProgress = (double)this.readPos * 1.0 / (double)this.length;
            }
            return readCount;
        }
    }
}

