/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.orderform.elements;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Supplier;
import net.creeperhost.minetogether.chat.gui.MTStyle;
import net.creeperhost.minetogether.gui.MTTextures;
import net.creeperhost.minetogether.orderform.OrderGui;
import net.creeperhost.minetogether.orderform.requests.GetDataCentresRequest;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.elements.GuiTexture;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.helpers.MathUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class LocationElement
extends GuiElement<LocationElement> {
    private final OrderGui gui;
    public GuiElement<?> locations;

    public LocationElement(@NotNull GuiParent<?> parent, OrderGui gui) {
        super(parent);
        this.gui = gui;
        GuiElement lastElement = (GuiElement)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)this, (Component)Component.translatable((String)"minetogether:gui.order.location").withStyle(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GOLD})).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        lastElement = this.locations = (GuiElement)((GuiElement)((GuiElement)((GuiElement)new GuiElement((GuiParent)this).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        GuiText locationLoading = new GuiText(this.locations, (Component)Component.translatable((String)"minetogether:gui.order.loading_locations").withStyle(ChatFormatting.YELLOW)).setAlignment(Align.LEFT);
        Constraints.bind((ConstrainedGeometry)locationLoading, this.locations);
        MutableComponent pingInfo = Component.translatable((String)"minetogether:gui.order.region.signal").withStyle(ChatFormatting.GRAY);
        lastElement = (GuiElement)((GuiText)((GuiText)new GuiText((GuiParent)this, (Component)pingInfo).setWrap(true).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)lastElement.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)));
        lastElement.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> this.lambda$new$0((Component)pingInfo)));
        this.constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)lastElement.get(GeoParam.BOTTOM)));
    }

    public void updateLocations() {
        this.locations.getChildren().forEach(arg_0 -> this.locations.removeChild(arg_0));
        if (this.gui.dcMap.isEmpty()) {
            this.locations.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
            GuiText error = new GuiText(this.locations, (Component)Component.translatable((String)"minetogether:gui.order.loading_locations_fail").withStyle(ChatFormatting.RED)).setAlignment(Align.LEFT);
            Constraints.bind((ConstrainedGeometry)error, this.locations);
        } else {
            ArrayList<GetDataCentresRequest.DC> dcOrder = new ArrayList<GetDataCentresRequest.DC>(this.gui.dcMap.values());
            GuiElement element = null;
            dcOrder.sort(Comparator.comparingDouble(dc -> this.gui.dcPing.getOrDefault(dc.slug, -1) < 0 ? 5000.0 : (double)(this.gui.dcPing.getOrDefault(dc.slug, -1) + (dc.available ? 0 : 5000))));
            for (GetDataCentresRequest.DC dc2 : dcOrder) {
                element = (GuiElement)((GuiElement)((GuiElement)this.locationButton(this.locations, dc2).constrain(GeoParam.TOP, (Constraint)(element == null ? Constraint.match((GeoRef)this.locations.get(GeoParam.TOP)) : Constraint.relative((GeoRef)element.get(GeoParam.BOTTOM), (double)1.0)))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.locations.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.locations.get(GeoParam.RIGHT)));
            }
            if (element != null) {
                this.locations.constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)element.get(GeoParam.BOTTOM)));
            }
        }
    }

    private GuiElement<?> locationButton(GuiElement<?> parent, GetDataCentresRequest.DC dc) {
        String name = dc.slug == null ? "" : dc.slug;
        GuiButton button = (GuiButton)MTStyle.Flat.button(parent, (Supplier<Component>)null).setToggleMode(() -> name.equals(this.gui.order.serverLocation)).onPress(() -> {
            this.gui.order.serverLocation = name;
            this.gui.summaryDirty();
        }).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)(dc.available ? 12.0 : 32.0)));
        double ping = this.gui.dcPing.getOrDefault(name, -2).intValue();
        long distance = this.gui.dcDistance.getOrDefault(name, -1L);
        MutableComponent pingText = Component.literal((String)((int)Math.ceil(ping) + " ms"));
        GuiText pingLabel = (GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)button, (Component)pingText).setEnabled(() -> ping > 0.0)).setAlignment(Align.RIGHT).setScroll(false).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.TOP), (double)2.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)parent.font().width((FormattedText)pingText)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.RIGHT), (double)-14.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        GuiTexture flag = (GuiTexture)((GuiTexture)((GuiTexture)((GuiTexture)new GuiTexture((GuiParent)button, this.gui.getFlag(dc)).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.TOP), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> this.gui.flagWidth(dc, 8.0)));
        GuiText label = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)button, (Component)Component.literal((String)(dc.name + ", " + dc.countryName))).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.TOP), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.dynamic(() -> Math.max(flag.xMax() + 2.0, button.xMin() + 21.0)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)pingLabel.get(GeoParam.LEFT), (double)-3.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        GuiTexture signal = (GuiTexture)((GuiTexture)((GuiTexture)((GuiTexture)((GuiTexture)new GuiTexture((GuiParent)button, MTTextures.getter(() -> this.getSignalIcon(ping, distance))).setTooltipSingle(() -> this.getSignalTooltip(ping, distance))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)button.get(GeoParam.TOP)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)button.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)12.0));
        if (!dc.available) {
            GuiText lowAvail = ((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)button, (Component)Component.translatable((String)"minetogether:gui.order.low_availability").withStyle(ChatFormatting.RED)).setAlignment(Align.LEFT).setWrap(true).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.BOTTOM), (double)-2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.LEFT), (double)4.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.RIGHT), (double)-4.0))).autoHeight();
            button.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> 12.0 + lowAvail.ySize() + 4.0));
        }
        return button;
    }

    private String getSignalIcon(double ping, long distance) {
        if (ping > 0.0) {
            int icon = MathUtil.clamp((int)(5 - (int)(ping / 42.0)), (int)1, (int)5);
            return "signal/signal_" + icon;
        }
        if (distance != -1L) {
            if (distance < 1000L) {
                return "signal/signal_5";
            }
            if (distance > 1000L && distance < 3000L) {
                return "signal/signal_4";
            }
            if (distance > 3000L && distance < 5000L) {
                return "signal/signal_3";
            }
            if (distance > 5000L && distance < 6000L) {
                return "signal/signal_2";
            }
            return "signal/signal_1";
        }
        if (ping == -1.0) {
            int l = (int)(Util.getMillis() / 100L & 7L);
            if (l > 4) {
                l = 8 - l;
            }
            return "signal/scan_" + l;
        }
        return "signal/signal_0";
    }

    private Component getSignalTooltip(double ping, long distance) {
        if (ping > 0.0) {
            return Component.translatable((String)"minetogether:gui.order.region.signal");
        }
        if (distance > 0L) {
            return Component.translatable((String)"minetogether:gui.order.region.from_distance");
        }
        if (ping == -1.0) {
            return Component.translatable((String)"minetogether:gui.order.region.pinging");
        }
        return Component.translatable((String)"minetogether:gui.order.region.pinging_fail");
    }

    private /* synthetic */ Double lambda$new$0(Component pingInfo) {
        return this.font().wordWrapHeight((FormattedText)pingInfo, (int)this.xMax() - (int)this.xMin());
    }
}

