/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.polylib.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class IconButton
extends Button {
    private final ResourceLocation sheet;
    private final boolean single;
    private final int index;

    public IconButton(int x, int y, int index, ResourceLocation sheet, Button.OnPress onPress) {
        super(x, y, 20, 20, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.index = index;
        this.sheet = sheet;
        this.single = false;
    }

    public IconButton(int x, int y, int width, int height, ResourceLocation sheet, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.sheet = sheet;
        this.single = true;
        this.index = 0;
    }

    public void updateBounds(int x, int y, int width, int height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.height = height;
    }

    public void renderWidget(GuiGraphics graphics, int mx, int my, float partialTicks) {
        if (!this.visible) {
            return;
        }
        if (this.single) {
            int fillColor = Integer.MIN_VALUE;
            if (this.isHovered) {
                fillColor = 1679826976;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, fillColor);
            graphics.blit(this.sheet, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        } else {
            int yOffset = !this.active ? 40 : (this.isHovered ? 20 : 0);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.blit(this.sheet, this.getX(), this.getY(), this.index * 20, yOffset, this.width, this.height);
        }
    }
}

