/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.polylib.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.joml.Quaternionf;

public class RadioButton
extends Button {
    private final List<Button.OnPress> actions = new LinkedList<Button.OnPress>();
    private float textScale = 1.0f;
    private boolean verticalText = false;
    private int autoScaleMargins = -1;
    private Supplier<Boolean> selected = () -> false;
    private Runnable onRelease = () -> {};

    public RadioButton(int x, int y, int width, int height, Component text) {
        super(x, y, width, height, text, e -> {}, Button.DEFAULT_NARRATION);
    }

    public void updateBounds(int x, int y, int width, int height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.height = height;
    }

    public RadioButton onRelease(Runnable onRelease) {
        this.onRelease = onRelease;
        return this;
    }

    public RadioButton withAutoScaleText(int autoScaleMargins) {
        this.autoScaleMargins = autoScaleMargins;
        return this;
    }

    public RadioButton withTextScale(float scale) {
        this.textScale = scale;
        return this;
    }

    public RadioButton withVerticalText() {
        this.verticalText = true;
        return this;
    }

    public RadioButton onPressed(Button.OnPress action) {
        this.actions.add(action);
        return this;
    }

    public RadioButton selectedSupplier(Supplier<Boolean> selected) {
        this.selected = selected;
        return this;
    }

    public void onPress() {
        if (this.selected.get().booleanValue()) {
            return;
        }
        for (Button.OnPress action : this.actions) {
            action.onPress((Button)this);
        }
    }

    public boolean mouseReleased(double d, double e, int i) {
        this.onRelease.run();
        return super.mouseReleased(d, e, i);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int textColor = 0xFFFFFF;
        int fillColor = 1679826976;
        if (this.isHovered || this.isPressed()) {
            textColor = 0xFFFFA0;
            fillColor = Integer.MIN_VALUE;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, fillColor);
        Font font = Minecraft.getInstance().font;
        float scale = this.textScale;
        Objects.requireNonNull(font);
        double lHeight = 9.0f * scale;
        double lWidth = (float)font.width((FormattedText)this.getMessage()) * scale;
        int autoWidth = (this.verticalText ? this.height : this.width) - this.autoScaleMargins * 2;
        if (this.autoScaleMargins > -1 && lWidth > (double)autoWidth) {
            scale = (float)((double)scale * ((double)autoWidth / lWidth));
            Objects.requireNonNull(font);
            lHeight = 9.0f * scale;
            lWidth = (float)font.width((FormattedText)this.getMessage()) * scale;
        }
        graphics.pose().pushPose();
        if (this.verticalText) {
            graphics.pose().translate((double)this.getX() + lHeight + (double)this.width / 2.0 - lHeight / 2.0, (double)this.getY() + (double)this.height / 2.0 - lWidth / 2.0, 0.0);
            graphics.pose().mulPose(new Quaternionf().rotationXYZ(0.0f, 0.0f, 1.5707964f));
        } else {
            graphics.pose().translate((double)this.getX() + (double)this.width / 2.0 - lWidth / 2.0, (double)this.getY() + (double)this.height / 2.0 - lHeight / 2.0, 0.0);
        }
        graphics.pose().scale(scale, scale, scale);
        graphics.drawString(font, this.getMessage(), 0, 0, textColor);
        graphics.pose().popPose();
    }

    public boolean isPressed() {
        return this.selected.get();
    }
}

