/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.polylib.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.creeperhost.minetogether.polylib.gui.PolyToast;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class SimpleToast
extends PolyToast {
    private final Component title;
    private final Component description;
    private ItemStack displayIconStack = ItemStack.EMPTY;
    private ResourceLocation iconResourceLocation;

    public SimpleToast(Component title) {
        this(title, (Component)Component.empty());
    }

    public SimpleToast(Component title, ResourceLocation resourceLocation) {
        this(title, (Component)Component.empty());
        this.iconResourceLocation = resourceLocation;
    }

    public SimpleToast(Component title, Component description) {
        this.title = title;
        this.description = description;
    }

    public SimpleToast(Component title, Component description, ItemStack itemStack) {
        this.title = title;
        this.description = description;
        this.displayIconStack = itemStack;
    }

    public SimpleToast(Component title, Component description, ResourceLocation resourceLocation) {
        this.title = title;
        this.description = description;
        this.iconResourceLocation = resourceLocation;
    }

    @Override
    public Toast.Visibility render(GuiGraphics graphics, ToastComponent toastComponent, long l) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blitSprite(new ResourceLocation("toast/advancement"), 0, 0, this.width(), this.height());
        if (this.iconResourceLocation != null) {
            this.renderImage(graphics, toastComponent, this.iconResourceLocation);
        }
        if (this.title != null) {
            Font font = toastComponent.getMinecraft().font;
            List titleList = font.split((FormattedText)this.title, 125);
            List descList = font.split((FormattedText)this.description, 125);
            boolean titleOnly = this.description.getString().isEmpty();
            int n = 0xFF88FF;
            if (descList.size() == 1 && titleList.size() == 1) {
                graphics.drawString(font, this.title, 30, 7, n | 0xFF000000);
                graphics.drawString(font, (FormattedCharSequence)descList.get(0), 30, 18, -1);
            } else if (l < 1500L || titleOnly) {
                int n2 = this.height() / 2;
                int n3 = titleList.size();
                Objects.requireNonNull(font);
                int yPos = n2 - n3 * 9 / 2;
                int alpha = titleOnly ? -16777216 : Mth.floor((float)(Mth.clamp((float)((float)(1500L - l) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000;
                for (FormattedCharSequence formattedCharSequence : titleList) {
                    graphics.drawString(font, formattedCharSequence, 30, yPos, n | alpha);
                    Objects.requireNonNull(font);
                    yPos += 9;
                }
            } else {
                int n4 = this.height() / 2;
                int n5 = descList.size();
                Objects.requireNonNull(font);
                int yPos = n4 - n5 * 9 / 2;
                int alpha = Mth.floor((float)(Mth.clamp((float)((float)(l - 1500L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000;
                for (FormattedCharSequence formattedCharSequence : descList) {
                    graphics.drawString(font, formattedCharSequence, 30, yPos, 0xFFFFFF | alpha);
                    Objects.requireNonNull(font);
                    yPos += 9;
                }
            }
            if (!this.displayIconStack.isEmpty()) {
                graphics.renderFakeItem(this.displayIconStack, 8, 8);
            }
            return l >= 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
        }
        return Toast.Visibility.HIDE;
    }
}

