/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.polylib.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.joml.Quaternionf;

public class SlideButton
extends Button {
    private float textScale = 1.0f;
    private boolean verticalText = false;
    private int autoScaleMargins = -1;
    private Function<Double, Component> messageGetter;
    private Supplier<Double> valueGetter;
    private Consumer<Double> valueSetter;
    private double min = 0.0;
    private double max = 1.0;
    private boolean dragging = false;
    private double prevValue = 0.0;
    private double nextValue = 0.0;
    private int rangeLeft = 0;
    private int rangeRight = 0;
    private boolean applyOnRelease = false;
    private Runnable onRelease = () -> {};
    private Supplier<Boolean> enabled = null;

    public SlideButton(int x, int y, int width, int height) {
        this(x, y, width, height, (Component)Component.empty());
    }

    public SlideButton(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message, e -> {}, Button.DEFAULT_NARRATION);
    }

    public SlideButton setEnabled(Supplier<Boolean> enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled == null || this.enabled.get() != false;
    }

    public Component getMessage() {
        return this.messageGetter == null ? super.getMessage() : this.messageGetter.apply(this.nextValue);
    }

    public SlideButton onRelease(Runnable onRelease) {
        this.onRelease = onRelease;
        return this;
    }

    public SlideButton setApplyOnRelease(boolean applyOnRelease) {
        this.applyOnRelease = applyOnRelease;
        return this;
    }

    public SlideButton setDynamicMessage(Function<Double, Component> messageGetter) {
        this.messageGetter = messageGetter;
        return this;
    }

    public SlideButton setDynamicMessage(Supplier<Component> messageGetter) {
        this.messageGetter = aDouble -> (Component)messageGetter.get();
        return this;
    }

    public SlideButton bindValue(Supplier<Double> valueGetter, Consumer<Double> valueSetter) {
        this.valueGetter = valueGetter;
        this.valueSetter = valueSetter;
        this.nextValue = valueGetter.get();
        return this;
    }

    public SlideButton setRange(double min, double max) {
        this.max = max;
        this.min = min;
        return this;
    }

    public void updateBounds(int x, int y, int width, int height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.height = height;
    }

    public SlideButton withAutoScaleText(int autoScaleMargins) {
        this.autoScaleMargins = autoScaleMargins;
        return this;
    }

    public SlideButton withTextScale(float scale) {
        this.textScale = scale;
        return this;
    }

    public void onClick(double mouseX, double mouseY) {
        if (!this.isEnabled()) {
            return;
        }
        this.dragging = true;
        int endOffset = this.width / 20;
        this.rangeLeft = this.getX() + endOffset;
        this.rangeRight = this.getX() + this.width - endOffset;
        this.prevValue = this.valueGetter.get();
        this.updateDrag(mouseX);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int i, double f, double g) {
        if (!this.dragging) {
            return false;
        }
        if (mouseY < (double)(this.getY() - 50) || mouseY > (double)(this.getY() + this.height + 50)) {
            this.valueSetter.accept(this.prevValue);
            this.nextValue = this.prevValue;
            return true;
        }
        this.updateDrag(mouseX);
        return true;
    }

    public boolean mouseReleased(double d, double e, int i) {
        if (this.dragging) {
            this.dragging = false;
            this.onRelease.run();
            if (this.applyOnRelease) {
                this.valueSetter.accept(this.nextValue);
            }
        }
        return super.mouseReleased(d, e, i);
    }

    private void updateDrag(double mouseX) {
        double range = this.max - this.min;
        double pos = (mouseX -= (double)this.rangeLeft) / (double)(this.rangeRight - this.rangeLeft);
        this.nextValue = Mth.clamp((double)(this.min + pos * range), (double)this.min, (double)this.max);
        if (!this.applyOnRelease) {
            this.valueSetter.accept(this.nextValue);
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.isEnabled()) {
            return;
        }
        int textColor = 0xFFFFFF;
        int fillColor = Integer.MIN_VALUE;
        int sliderColor = 1686143104;
        if (this.isHovered || this.dragging) {
            sliderColor = -6250336;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, fillColor);
        int slideWidth = this.width / 10;
        double pos = (this.nextValue - this.min) / (this.max - this.min);
        int slidePos = (int)((double)(this.width - slideWidth) * pos);
        graphics.fill(this.getX() + slidePos, this.getY(), this.getX() + slidePos + slideWidth, this.getY() + this.height, sliderColor);
        Font font = Minecraft.getInstance().font;
        float scale = this.textScale;
        Objects.requireNonNull(font);
        double lHeight = 9.0f * scale;
        double lWidth = (float)font.width((FormattedText)this.getMessage()) * scale;
        int autoWidth = (this.verticalText ? this.height : this.width) - this.autoScaleMargins * 2;
        if (this.autoScaleMargins > -1 && lWidth > (double)autoWidth) {
            scale = (float)((double)scale * ((double)autoWidth / lWidth));
            Objects.requireNonNull(font);
            lHeight = 9.0f * scale;
            lWidth = (float)font.width((FormattedText)this.getMessage()) * scale;
        }
        graphics.pose().pushPose();
        if (this.verticalText) {
            graphics.pose().translate((double)this.getX() + lHeight + (double)this.width / 2.0 - lHeight / 2.0, (double)this.getY() + (double)this.height / 2.0 - lWidth / 2.0, 0.0);
            graphics.pose().mulPose(new Quaternionf().rotationXYZ(0.0f, 0.0f, 1.5707964f));
        } else {
            graphics.pose().translate((double)this.getX() + (double)this.width / 2.0 - lWidth / 2.0, (double)this.getY() + (double)this.height / 2.0 - lHeight / 2.0, 0.0);
        }
        graphics.pose().scale(scale, scale, 1.0f);
        graphics.drawString(font, this.getMessage(), 0, 0, textColor);
        graphics.flush();
        graphics.pose().popPose();
    }
}

