/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.net.covers1624.quack.asm.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.creeperhost.minetogether.repack.net.covers1624.quack.annotation.Requires;
import net.creeperhost.minetogether.repack.net.covers1624.quack.asm.annotation.AnnotationParser;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

@Requires(value="org.ow2.asm:asm")
public class AnnotationLoader {
    private final AnnotationParser.ClassLookup lookup;
    private final boolean ignoreMissing;
    private final Map<Class<? extends Annotation>, List<Annotation>> annotations = new LinkedHashMap<Class<? extends Annotation>, List<Annotation>>();
    private final Map<Class<? extends Annotation>, List<Annotation>> invisibleAnnotations = new LinkedHashMap<Class<? extends Annotation>, List<Annotation>>();

    public AnnotationLoader() {
        this(AnnotationParser.ClassLookup.DEFAULT);
    }

    public AnnotationLoader(boolean ignoreMissing) {
        this(AnnotationParser.ClassLookup.DEFAULT, ignoreMissing);
    }

    public AnnotationLoader(AnnotationParser.ClassLookup lookup) {
        this(lookup, false);
    }

    public AnnotationLoader(AnnotationParser.ClassLookup lookup, boolean ignoreMissing) {
        this.lookup = lookup;
        this.ignoreMissing = ignoreMissing;
    }

    public ClassVisitor forClass() {
        return this.forClass(null);
    }

    public ClassVisitor forClass(@Nullable ClassVisitor delegate) {
        return new ClassVisitor(589824, delegate){

            @Nullable
            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                return AnnotationLoader.this.newVisitor(super.visitAnnotation(descriptor, visible), descriptor, visible);
            }
        };
    }

    public MethodVisitor forMethod() {
        return this.forMethod(null);
    }

    public MethodVisitor forMethod(@Nullable MethodVisitor delegate) {
        return new MethodVisitor(589824, delegate){

            @Nullable
            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                return AnnotationLoader.this.newVisitor(super.visitAnnotation(descriptor, visible), descriptor, visible);
            }
        };
    }

    public FieldVisitor forField() {
        return this.forField(null);
    }

    public FieldVisitor forField(@Nullable FieldVisitor delegate) {
        return new FieldVisitor(589824, delegate){

            @Nullable
            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                return AnnotationLoader.this.newVisitor(super.visitAnnotation(descriptor, visible), descriptor, visible);
            }
        };
    }

    @Nullable
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        return this.getAnnotation(clazz, true);
    }

    @Nullable
    public <T extends Annotation> T getAnnotation(Class<T> clazz, boolean visible) {
        List<Annotation> annotations = this.getMap(visible).get(clazz);
        if (annotations == null || annotations.isEmpty()) {
            return null;
        }
        return (T)annotations.get(0);
    }

    public <T extends Annotation> T @Nullable [] getAnnotations(Class<T> clazz) {
        return this.getAnnotations(clazz, true);
    }

    public <T extends Annotation> T @Nullable [] getAnnotations(Class<T> clazz, boolean visible) {
        List<Annotation> annotations = this.getMap(visible).get(clazz);
        if (annotations == null || annotations.isEmpty()) {
            return null;
        }
        return annotations.toArray((Annotation[])Array.newInstance(clazz, 0));
    }

    public Set<Class<? extends Annotation>> getAllTypes() {
        return this.getAllTypes(true);
    }

    public Set<Class<? extends Annotation>> getAllTypes(boolean visible) {
        return Collections.unmodifiableSet(this.getMap(visible).keySet());
    }

    private Map<Class<? extends Annotation>, List<Annotation>> getMap(boolean visible) {
        return visible ? this.annotations : this.invisibleAnnotations;
    }

    @Nullable
    private AnnotationParser newVisitor(AnnotationVisitor delegate, String descriptor, boolean visible) {
        try {
            return AnnotationParser.newVisitor(delegate, this.lookup, descriptor, value -> this.addToMap((Annotation)value, visible));
        }
        catch (AnnotationParser.AnnotationParseException ex) {
            if (!this.ignoreMissing) {
                throw ex;
            }
            return null;
        }
    }

    private void addToMap(Annotation annotation, boolean visible) {
        this.getMap(visible).computeIfAbsent(annotation.annotationType(), e -> new ArrayList()).add(annotation);
        Annotation[] expanded = AnnotationLoader.expandRepeatable((Annotation)annotation);
        if (expanded != null) {
            for (Annotation ann : expanded) {
                this.addToMap(ann, visible);
            }
        }
    }

    public static <T extends Annotation> T @Nullable [] expandRepeatable(Annotation ann) {
        try {
            Class<? extends Annotation> clazz = ann.annotationType();
            for (Method method : clazz.getMethods()) {
                Repeatable r;
                Class<?> returnType = method.getReturnType();
                if (!method.getName().equals("value") || !returnType.isArray() || (r = returnType.getComponentType().getAnnotation(Repeatable.class)) == null || !r.value().equals(clazz)) continue;
                return (Annotation[])method.invoke((Object)ann, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

