/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.net.covers1624.quack.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.WillNotClose;
import net.creeperhost.minetogether.repack.net.covers1624.quack.io.CopyingFileVisitor;
import net.creeperhost.minetogether.repack.net.covers1624.quack.io.DelegateFileSystem;

public class IOUtils {
    private static final ThreadLocal<byte[]> arrayCache = ThreadLocal.withInitial(() -> new byte[32768]);
    private static final ThreadLocal<ByteBuffer> directBufferCache = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(16384));
    private static final Map<String, String> jfsArgsCreate = Collections.singletonMap("create", "true");

    public static byte[] getCachedBuffer() {
        return arrayCache.get();
    }

    public static void copy(@WillNotClose InputStream is, @WillNotClose OutputStream os) throws IOException {
        int len;
        byte[] buffer = arrayCache.get();
        while ((len = is.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
    }

    public static void copy(@WillNotClose ReadableByteChannel rc, @WillNotClose WritableByteChannel wc) throws IOException {
        ByteBuffer buffer = directBufferCache.get();
        buffer.clear();
        while (rc.read(buffer) != -1) {
            buffer.flip();
            while (buffer.hasRemaining()) {
                wc.write(buffer);
            }
            buffer.clear();
        }
    }

    public static void fill(@WillNotClose ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        int len;
        int toRead = buffer.remaining();
        int read = 0;
        while (buffer.hasRemaining() && (len = channel.read(buffer)) != -1) {
            read += len;
        }
        if (read < toRead) {
            throw new EOFException("Expected " + toRead + " Got " + read);
        }
    }

    public static byte[] toBytes(@WillNotClose InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.copy(is, os);
        return os.toByteArray();
    }

    public static List<String> readAll(byte[] bytes) throws IOException {
        return IOUtils.readAll(bytes, StandardCharsets.UTF_8);
    }

    public static List<String> readAll(byte[] bytes, Charset charset) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), charset));){
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
    }

    public static String readAll(Path path) throws IOException {
        return IOUtils.readAll(path, StandardCharsets.UTF_8);
    }

    public static String readAll(Path path, Charset charset) throws IOException {
        return new String(Files.readAllBytes(path), charset);
    }

    public static Path makeParents(Path path) throws IOException {
        Path parent = (path = path.toAbsolutePath()).getParent();
        if (Files.notExists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        return path;
    }

    public static FileSystem getJarFileSystem(Path path, boolean create) throws IOException {
        return IOUtils.getJarFileSystem(path.toUri(), create);
    }

    public static FileSystem getJarFileSystem(URI path, boolean create) throws IOException {
        URI jarURI;
        try {
            jarURI = new URI("jar:file", null, path.getPath(), "");
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return IOUtils.getFileSystem(jarURI, create ? jfsArgsCreate : Collections.emptyMap());
    }

    public static FileSystem getFileSystem(URI uri) throws IOException {
        return IOUtils.getFileSystem(uri, Collections.emptyMap());
    }

    public static FileSystem getFileSystem(URI uri, Map<String, ?> env) throws IOException {
        FileSystem fs;
        boolean owner = true;
        try {
            fs = FileSystems.newFileSystem(uri, env);
        }
        catch (FileSystemAlreadyExistsException e) {
            fs = FileSystems.getFileSystem(uri);
            owner = false;
        }
        return owner ? fs : IOUtils.protectClose(fs);
    }

    public static FileSystem protectClose(FileSystem fs) {
        return new DelegateFileSystem(fs){

            @Override
            public void close() {
            }
        };
    }

    public static InputStream protectClose(InputStream is) {
        return new FilterInputStream(is){

            @Override
            public void close() {
            }
        };
    }

    public static OutputStream protectClose(OutputStream os) {
        return new FilterOutputStream(os){

            @Override
            public void close() {
            }
        };
    }

    public static void stripJar(Path input, Path output, Predicate<Path> predicate) throws IOException {
        if (Files.notExists(input, new LinkOption[0])) {
            throw new FileNotFoundException("Input not found. " + input);
        }
        if (Files.exists(output, new LinkOption[0])) {
            throw new IOException("Output already exists. " + output);
        }
        try (FileSystem inFs = IOUtils.getJarFileSystem(input, true);
             FileSystem outFs = IOUtils.getJarFileSystem(output, true);){
            Path inRoot = inFs.getPath("/", new String[0]);
            Path outRoot = outFs.getPath("/", new String[0]);
            Files.walkFileTree(inRoot, new CopyingFileVisitor(inRoot, outRoot, predicate));
        }
    }

    public static Set<PosixFilePermission> parseMode(int mode) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        char[] ds = Integer.toString(mode).toCharArray();
        for (int i = ds.length - 1; i >= 0; --i) {
            int n = ds[i] - 48;
            if (i == ds.length - 1) {
                if ((n & 1) != 0) {
                    perms.add(PosixFilePermission.OTHERS_EXECUTE);
                }
                if ((n & 2) != 0) {
                    perms.add(PosixFilePermission.OTHERS_WRITE);
                }
                if ((n & 4) == 0) continue;
                perms.add(PosixFilePermission.OTHERS_READ);
                continue;
            }
            if (i == ds.length - 2) {
                if ((n & 1) != 0) {
                    perms.add(PosixFilePermission.GROUP_EXECUTE);
                }
                if ((n & 2) != 0) {
                    perms.add(PosixFilePermission.GROUP_WRITE);
                }
                if ((n & 4) == 0) continue;
                perms.add(PosixFilePermission.GROUP_READ);
                continue;
            }
            if (i != ds.length - 3) continue;
            if ((n & 1) != 0) {
                perms.add(PosixFilePermission.OWNER_EXECUTE);
            }
            if ((n & 2) != 0) {
                perms.add(PosixFilePermission.OWNER_WRITE);
            }
            if ((n & 4) == 0) continue;
            perms.add(PosixFilePermission.OWNER_READ);
        }
        return perms;
    }

    public static int writeMode(Set<PosixFilePermission> perms) {
        int[] segs = new int[3];
        if (perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            segs[2] = segs[2] | 1;
        }
        if (perms.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            segs[2] = segs[2] | 2;
        }
        if (perms.contains((Object)PosixFilePermission.OTHERS_READ)) {
            segs[2] = segs[2] | 4;
        }
        if (perms.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            segs[1] = segs[1] | 1;
        }
        if (perms.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            segs[1] = segs[1] | 2;
        }
        if (perms.contains((Object)PosixFilePermission.GROUP_READ)) {
            segs[1] = segs[1] | 4;
        }
        if (perms.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            segs[0] = segs[0] | 1;
        }
        if (perms.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            segs[0] = segs[0] | 2;
        }
        if (perms.contains((Object)PosixFilePermission.OWNER_READ)) {
            segs[0] = segs[0] | 4;
        }
        return Integer.parseInt(String.valueOf(segs[0]) + segs[1] + segs[2]);
    }
}

