/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.curl4j;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.creeperhost.minetogether.repack.net.covers1624.curl4j.CABundle;
import net.creeperhost.minetogether.repack.net.covers1624.curl4j.CURL;
import net.creeperhost.minetogether.repack.net.covers1624.curl4j.CurlXferInfoCallback;
import net.creeperhost.minetogether.repack.net.covers1624.curl4j.util.CurlHandle;
import net.creeperhost.minetogether.repack.net.covers1624.curl4j.util.CurlInput;
import net.creeperhost.minetogether.repack.net.covers1624.curl4j.util.CurlMimeBody;
import net.creeperhost.minetogether.repack.net.covers1624.quack.annotation.Requires;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.AbstractEngineRequest;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.HeaderList;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.MultipartBody;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.RequestListener;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.WebBody;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.curl4j.Curl4jEngineResponse;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.curl4j.Curl4jHttpEngine;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

@Requires(value="net.creeperhost.minetogether.repack.net.covers1624:curl4j", minVersion="3.0.5")
public class Curl4jEngineRequest
extends AbstractEngineRequest {
    private final Curl4jHttpEngine engine;
    private final List<Consumer<CurlHandle>> customOptions = new LinkedList<Consumer<CurlHandle>>();
    private boolean followRedirects = true;
    @Nullable
    private Path destFile;
    @Nullable
    private String unixSocket;
    @Nullable
    private CABundle caBundle;
    @Nullable
    private String method;
    @Nullable
    private WebBody body;

    public Curl4jEngineRequest(Curl4jHttpEngine engine) {
        this.engine = engine;
    }

    @Override
    public Curl4jEngineRequest method(String method, @Nullable WebBody body) {
        this.method = method;
        this.body = body;
        return this;
    }

    public Curl4jEngineRequest dontFollowRedirects() {
        this.assertState();
        this.followRedirects = false;
        return this;
    }

    public Curl4jEngineRequest useFileOutput(Path destFile) {
        this.assertState();
        this.destFile = destFile;
        return this;
    }

    public Curl4jEngineRequest unixSocket(String unixSocket) {
        this.unixSocket = unixSocket;
        return this;
    }

    public Curl4jEngineRequest useCABundle(@Nullable CABundle caBundle) {
        this.caBundle = caBundle;
        return this;
    }

    public Curl4jEngineRequest addCustomOption(Consumer<CurlHandle> action) {
        this.customOptions.add(action);
        return this;
    }

    @Override
    public Curl4jEngineRequest url(String url) {
        super.url(url);
        return this;
    }

    @Override
    public Curl4jEngineRequest header(String key, String value) {
        super.header(key, value);
        return this;
    }

    @Override
    public Curl4jEngineRequest headers(Map<String, String> headers) {
        super.headers(headers);
        return this;
    }

    @Override
    public Curl4jEngineRequest headers(HeaderList headers) {
        super.headers(headers);
        return this;
    }

    @Override
    public Curl4jEngineRequest removeHeader(String key) {
        super.removeHeader(key);
        return this;
    }

    @Override
    public Curl4jEngineRequest listener(RequestListener listener) {
        super.listener(listener);
        return this;
    }

    @Override
    protected void assertState() {
        super.assertState();
        if (this.method == null) {
            throw new IllegalStateException("method(String, Body) must be called first");
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Curl4jEngineResponse execute() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 13 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setupHandle(CurlHandle handle) {
        String contentType;
        assert (this.method != null);
        CURL.curl_easy_reset((long)handle.curl);
        String impersonate = this.engine.getImpersonate();
        if (impersonate != null) {
            CURL.curl_easy_impersonate((long)handle.curl, (String)impersonate, (boolean)true);
        }
        CURL.curl_easy_setopt((long)handle.curl, (int)10002, (String)this.url);
        if (this.method.equals("HEAD")) {
            CURL.curl_easy_setopt((long)handle.curl, (int)44, (boolean)true);
        } else {
            CURL.curl_easy_setopt((long)handle.curl, (int)10036, (String)this.method);
        }
        if (this.followRedirects) {
            CURL.curl_easy_setopt((long)handle.curl, (int)52, (boolean)true);
        }
        if (this.unixSocket != null) {
            CURL.curl_easy_setopt((long)handle.curl, (int)10231, (String)this.unixSocket);
        }
        if (this.body != null && !(this.body instanceof MultipartBody) && (contentType = this.body.contentType()) != null) {
            this.headers.add("Content-Type", contentType);
        }
    }

    HeaderList headers() {
        return this.headers;
    }

    @Nullable
    @Contract(pure=true)
    CABundle caBundle() {
        return this.caBundle;
    }

    @Nullable
    @Contract(pure=true)
    RequestListener listener() {
        return this.listener;
    }

    List<Consumer<CurlHandle>> customOptions() {
        return this.customOptions;
    }

    @Nullable
    CurlInput makeInput() {
        if (this.body == null || this.body instanceof MultipartBody) {
            return null;
        }
        return Curl4jEngineRequest.inputFromBody(this.body);
    }

    @Nullable
    CurlMimeBody buildMime(CurlHandle handle) {
        if (!(this.body instanceof MultipartBody)) {
            return null;
        }
        CurlMimeBody.Builder builder = CurlMimeBody.builder((CurlHandle)handle);
        for (MultipartBody.Part part : ((MultipartBody)this.body).getParts()) {
            CurlMimeBody.Builder.PartBuilder partBuilder = builder.addPart(part.name);
            if (part.fileName != null) {
                partBuilder.fileName(part.fileName);
            }
            partBuilder.body(Curl4jEngineRequest.inputFromBody(part.body));
        }
        return builder.build();
    }

    @Nullable
    CurlXferInfoCallback xferCallback(@Nullable RequestListener listener) {
        if (listener == null) {
            return null;
        }
        return new CurlXferInfoCallback((ptr, dltotal, dlnow, ultotal, ulnow) -> {
            listener.onDownload(dltotal, dlnow);
            listener.onUpload(ultotal, ulnow);
            return 0;
        });
    }

    private static CurlInput inputFromBody(final WebBody body) {
        return new CurlInput(){
            @Nullable
            private InputStream is;

            protected ReadableByteChannel open() throws IOException {
                return Channels.newChannel(this.getStream());
            }

            public long availableBytes() throws IOException {
                long len = body.length();
                if (len == -1L) {
                    len = this.getStream().available();
                }
                return len;
            }

            private InputStream getStream() throws IOException {
                if (this.is == null) {
                    this.is = body.open();
                }
                return this.is;
            }
        };
    }
}

