/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.okhttp;

import java.io.IOException;
import java.io.InputStream;
import net.creeperhost.minetogether.repack.net.covers1624.quack.annotation.Requires;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.AbstractEngineRequest;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.EngineRequest;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.EngineResponse;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.HeaderList;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.MultipartBody;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.RequestListener;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.WebBody;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.okhttp.OkHttpEngine;
import net.creeperhost.minetogether.repack.net.covers1624.quack.net.httpapi.okhttp.OkHttpEngineResponse;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Requires(value="com.squareup.okhttp3:okhttp")
public class OkHttpEngineRequest
extends AbstractEngineRequest {
    private final OkHttpEngine engine;
    @Nullable
    private Request.Builder builder;

    public OkHttpEngineRequest(OkHttpEngine engine) {
        this.engine = engine;
    }

    @Override
    public EngineRequest method(String method, @Nullable WebBody body) {
        assert (this.builder == null) : "Method already set.";
        this.builder = new Request.Builder();
        RequestBody reqBody = null;
        if (body != null) {
            if (!(body instanceof MultipartBody)) {
                reqBody = OkHttpEngineRequest.toOkhttp(body, this.listener);
            } else {
                MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
                bodyBuilder.setType(okhttp3.MultipartBody.FORM);
                for (MultipartBody.Part part : ((MultipartBody)body).getParts()) {
                    bodyBuilder.addFormDataPart(part.name, part.fileName, OkHttpEngineRequest.toOkhttp(part.body, this.listener));
                }
                reqBody = bodyBuilder.build();
            }
        }
        this.builder.method(method, reqBody);
        return this;
    }

    @Override
    protected void assertState() {
        super.assertState();
        if (this.builder == null) {
            throw new IllegalStateException("method(String, Body) must be called first");
        }
    }

    @Override
    public EngineRequest url(String url) {
        super.url(url);
        this.builder.url(url);
        return this;
    }

    @Override
    public EngineResponse execute() throws IOException {
        this.assertState();
        if (this.url == null) {
            throw new IllegalStateException("Url not set.");
        }
        assert (this.builder != null);
        this.executed = true;
        for (HeaderList.Entry header : this.headers) {
            this.builder.addHeader(header.name, header.value);
        }
        if (this.listener != null) {
            this.listener.start(this.builder.getBody$okhttp() != null ? RequestListener.Direction.UPLOAD : RequestListener.Direction.DOWNLOAD);
        }
        Response response = this.engine.getClient().newCall(this.builder.build()).execute();
        return new OkHttpEngineResponse(this, response, this.listener);
    }

    private static RequestBody toOkhttp(final WebBody body, final @Nullable RequestListener listener) {
        String contentTypeStr = body.contentType();
        final MediaType contentType = contentTypeStr != null ? MediaType.parse((String)contentTypeStr) : null;
        return new RequestBody(){

            public void writeTo(BufferedSink dst) throws IOException {
                try (Source src = OkHttpEngineRequest.wrapWithProgress(Okio.source((InputStream)body.open()), body.length(), listener);){
                    dst.writeAll(src);
                }
            }

            @Nullable
            public MediaType contentType() {
                return contentType;
            }

            public long contentLength() {
                return body.length();
            }

            public boolean isOneShot() {
                return true;
            }
        };
    }

    private static Source wrapWithProgress(Source source, final long total, final @Nullable RequestListener listener) {
        if (listener == null) {
            return source;
        }
        return new ForwardingSource(source){
            private long curr;

            public long read(@NotNull Buffer sink, long byteCount) throws IOException {
                long now = super.read(sink, byteCount);
                if (now != -1L) {
                    this.curr += now;
                    listener.onUpload(total, this.curr);
                }
                return now;
            }
        };
    }
}

