/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import net.creeperhost.minetogether.repack.org.pircbotx.Channel;
import net.creeperhost.minetogether.repack.org.pircbotx.Configuration;
import net.creeperhost.minetogether.repack.org.pircbotx.IdentServer;
import net.creeperhost.minetogether.repack.org.pircbotx.InputParser;
import net.creeperhost.minetogether.repack.org.pircbotx.ServerInfo;
import net.creeperhost.minetogether.repack.org.pircbotx.User;
import net.creeperhost.minetogether.repack.org.pircbotx.UserChannelDao;
import net.creeperhost.minetogether.repack.org.pircbotx.UserHostmask;
import net.creeperhost.minetogether.repack.org.pircbotx.Utils;
import net.creeperhost.minetogether.repack.org.pircbotx.dcc.DccHandler;
import net.creeperhost.minetogether.repack.org.pircbotx.exception.IrcException;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.ConnectAttemptFailedEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.ConnectAttemptStartEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.DisconnectEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.ExceptionEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.OutputEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.SocketConnectEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.output.OutputCAP;
import net.creeperhost.minetogether.repack.org.pircbotx.output.OutputDCC;
import net.creeperhost.minetogether.repack.org.pircbotx.output.OutputIRC;
import net.creeperhost.minetogether.repack.org.pircbotx.output.OutputRaw;
import net.creeperhost.minetogether.repack.org.pircbotx.snapshot.UserChannelDaoSnapshot;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PircBotX
implements Comparable<PircBotX>,
Closeable {
    private static final Logger log = LogManager.getLogger(PircBotX.class);
    public static final Level INFO_LEVEL = PircBotX.parseLevel("net.creeperhost.minetogether.repack.net.covers1624.pircbot.logging.info");
    public static final Level DEBUG_LEVEL = PircBotX.parseLevel("net.creeperhost.minetogether.repack.net.covers1624.pircbot.logging.debug");
    public static final boolean VERY_VERBOSE = Boolean.getBoolean("net.creeperhost.minetogether.repack.net.covers1624.pircbotx.logging.very_verbose");
    public static final String VERSION = StringUtils.defaultString((String)PircBotX.class.getPackage().getImplementationVersion(), (String)"unknown");
    protected static final AtomicInteger BOT_COUNT = new AtomicInteger();
    protected final int botId;
    protected final Configuration configuration;
    protected final InputParser inputParser;
    protected final UserChannelDao<User, Channel> userChannelDao;
    protected final DccHandler dccHandler;
    protected final ServerInfo serverInfo;
    protected Socket socket;
    protected BufferedReader inputReader;
    protected Writer outputWriter;
    protected final OutputRaw outputRaw;
    protected final OutputIRC outputIRC;
    protected final OutputCAP outputCAP;
    protected final OutputDCC outputDCC;
    protected List<String> enabledCapabilities = new ArrayList<String>();
    protected String nick;
    protected boolean loggedIn = false;
    protected Thread shutdownHook;
    protected volatile boolean reconnectStopped = false;
    protected ImmutableMap<String, String> reconnectChannels;
    private State state = State.INIT;
    protected final Object stateLock = new Object();
    protected Exception disconnectException;
    protected String serverHostname;
    protected int serverPort;
    protected boolean nickservIdentified = false;
    private int connectAttempts = 0;
    private int connectAttemptTotal = 0;

    private static Level parseLevel(String prop) {
        String val = System.getProperty(prop);
        return val != null ? Level.getLevel((String)val) : null;
    }

    public PircBotX(@NonNull Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.botId = BOT_COUNT.getAndIncrement();
        this.configuration = configuration;
        this.nick = configuration.getName();
        this.userChannelDao = configuration.getBotFactory().createUserChannelDao(this);
        UserHostmask botHostmask = configuration.getBotFactory().createUserHostmask(this, null, configuration.getName(), configuration.getLogin(), null);
        this.getUserChannelDao().createUser(botHostmask);
        this.serverInfo = configuration.getBotFactory().createServerInfo(this);
        this.outputRaw = configuration.getBotFactory().createOutputRaw(this);
        this.outputIRC = configuration.getBotFactory().createOutputIRC(this);
        this.outputCAP = configuration.getBotFactory().createOutputCAP(this);
        this.outputDCC = configuration.getBotFactory().createOutputDCC(this);
        this.dccHandler = configuration.getBotFactory().createDccHandler(this);
        this.inputParser = configuration.getBotFactory().createInputParser(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBot() throws IOException, IrcException {
        this.reconnectStopped = false;
        int reconnectAttempts = this.configuration.getAutoReconnectAttempts();
        do {
            LinkedHashMap<InetSocketAddress, Exception> connectExceptions = new LinkedHashMap<InetSocketAddress, Exception>();
            try {
                ++this.connectAttemptTotal;
                ++this.connectAttempts;
                Utils.dispatchEvent(this, new ConnectAttemptStartEvent(this, this.connectAttempts));
                connectExceptions.putAll((Map<InetSocketAddress, Exception>)this.connect());
            }
            catch (Exception e2) {
                block27: {
                    try {
                        log.error("Exception encountered during connect", (Throwable)e2);
                        connectExceptions.put(new InetSocketAddress(this.serverHostname, this.serverPort), e2);
                        if (this.configuration.isAutoReconnect()) break block27;
                        throw new RuntimeException("Exception encountered during connect", e2);
                    }
                    catch (Throwable throwable) {
                        if (!connectExceptions.isEmpty()) {
                            Utils.dispatchEvent(this, new ConnectAttemptFailedEvent(this, reconnectAttempts == -1 ? -1 : reconnectAttempts - this.connectAttempts, (ImmutableMap<InetSocketAddress, Exception>)ImmutableMap.copyOf(connectExceptions)));
                        }
                        Object object = this.stateLock;
                        synchronized (object) {
                            if (this.state != State.DISCONNECTED) {
                                this.shutdown();
                            }
                        }
                        throw throwable;
                    }
                }
                if (!connectExceptions.isEmpty()) {
                    Utils.dispatchEvent(this, new ConnectAttemptFailedEvent(this, reconnectAttempts == -1 ? -1 : reconnectAttempts - this.connectAttempts, (ImmutableMap<InetSocketAddress, Exception>)ImmutableMap.copyOf(connectExceptions)));
                }
                Object e2 = this.stateLock;
                synchronized (e2) {
                    if (this.state != State.DISCONNECTED) {
                        this.shutdown();
                    }
                }
            }
            if (!connectExceptions.isEmpty()) {
                Utils.dispatchEvent(this, new ConnectAttemptFailedEvent(this, reconnectAttempts == -1 ? -1 : reconnectAttempts - this.connectAttempts, (ImmutableMap<InetSocketAddress, Exception>)ImmutableMap.copyOf(connectExceptions)));
            }
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state != State.DISCONNECTED) {
                    this.shutdown();
                }
            }
            if (!this.configuration.isAutoReconnect()) {
                return;
            }
            if (this.reconnectStopped) {
                if (DEBUG_LEVEL != null) {
                    log.log(DEBUG_LEVEL, "stopBotReconnect() called, exiting reconnect loop");
                }
                return;
            }
            if (reconnectAttempts != -1 && this.connectAttempts == reconnectAttempts) {
                throw new IOException("Failed to connect to IRC server(s) after " + this.connectAttempts + " attempts");
            }
            if (this.configuration.getAutoReconnectDelay().getDelay() <= 0L) continue;
            try {
                if (DEBUG_LEVEL != null) {
                    log.log(DEBUG_LEVEL, "Pausing for {} milliseconds before connecting again", (Object)this.configuration.getAutoReconnectDelay());
                }
                Thread.sleep(this.configuration.getAutoReconnectDelay().getDelay());
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while pausing before the next connect attempt", e);
            }
        } while (reconnectAttempts == -1 || this.connectAttempts < reconnectAttempts);
    }

    public void stopBotReconnect() {
        this.reconnectStopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImmutableMap<InetSocketAddress, Exception> connect() throws IOException, IrcException {
        Object object = this.stateLock;
        synchronized (object) {
            int reconnectAttempts = this.configuration.getAutoReconnectAttempts();
            Utils.addBotToMDC(this);
            if (this.isConnected()) {
                throw new IrcException(IrcException.Reason.ALREADY_CONNECTED, "Must disconnect from server before connecting again");
            }
            if (this.getState() == State.CONNECTED) {
                throw new RuntimeException("Bot is not connected but state is State.CONNECTED. This shouldn't happen");
            }
            if (this.configuration.isIdentServerEnabled() && IdentServer.getServer() == null) {
                throw new RuntimeException("UseIdentServer is enabled but no IdentServer has been started");
            }
            this.enabledCapabilities = new ArrayList<String>();
            this.getUserChannelDao().close();
            UserHostmask botHostmask = this.configuration.getBotFactory().createUserHostmask(this, null, this.configuration.getName(), this.configuration.getLogin(), null);
            this.getUserChannelDao().createUser(botHostmask);
            ImmutableMap.Builder connectExceptions = ImmutableMap.builder();
            int serverEntryCounter = 0;
            block5: for (Configuration.ServerEntry curServerEntry : this.configuration.getServers()) {
                InetAddress[] serverAddresses;
                ++serverEntryCounter;
                this.serverHostname = curServerEntry.getHostname();
                Utils.addBotToMDC(this);
                if (reconnectAttempts == -1) {
                    if (INFO_LEVEL != null) {
                        log.log(INFO_LEVEL, "--Starting Connect attempt---");
                    } else if (INFO_LEVEL != null) {
                        log.log(INFO_LEVEL, "---Starting Connect attempt {}/{}", (Object)this.connectAttempts, (Object)(reconnectAttempts + "---"));
                    }
                }
                int serverAddressCounter = 0;
                for (InetAddress curAddress : serverAddresses = InetAddress.getAllByName(this.serverHostname)) {
                    String debug = Utils.format("[{}/{} address left from {}, {}/{} hostnames left] ", String.valueOf(serverAddresses.length - ++serverAddressCounter), String.valueOf(serverAddresses.length), this.serverHostname, String.valueOf(this.configuration.getServers().size() - serverEntryCounter), String.valueOf(this.configuration.getServers().size()));
                    if (DEBUG_LEVEL != null) {
                        log.log(DEBUG_LEVEL, "{}Atempting to connect to {} on port {}", (Object)debug, (Object)curAddress, (Object)curServerEntry.getPort());
                    }
                    try {
                        this.socket = this.configuration.getSocketFactory().createSocket();
                        this.socket.bind(new InetSocketAddress(this.configuration.getLocalAddress(), 0));
                        this.socket.connect(new InetSocketAddress(curAddress, curServerEntry.getPort()), this.configuration.getSocketConnectTimeout());
                        this.serverPort = curServerEntry.getPort();
                        break block5;
                    }
                    catch (Exception e) {
                        connectExceptions.put((Object)new InetSocketAddress(curAddress, curServerEntry.getPort()), (Object)e);
                        log.warn("{}Failed to connect to {} on port {}", (Object)debug, (Object)curAddress, (Object)curServerEntry.getPort(), (Object)e);
                    }
                }
            }
            if (this.socket == null || this.socket != null && !this.socket.isConnected()) {
                this.socket = null;
                this.state = State.DISCONNECTED;
                return connectExceptions.build();
            }
            this.state = State.CONNECTED;
            this.socket.setSoTimeout(this.configuration.getSocketTimeout());
            if (INFO_LEVEL != null) {
                log.log(INFO_LEVEL, "Connected to server.");
            }
            this.changeSocket(this.socket);
        }
        this.configuration.getListenerManager().onEvent(new SocketConnectEvent(this));
        if (this.configuration.isIdentServerEnabled()) {
            IdentServer.getServer().addIdentEntry(this.socket.getInetAddress(), this.socket.getPort(), this.socket.getLocalPort(), this.configuration.getLogin());
        }
        if (this.configuration.isCapEnabled()) {
            this.sendCAP().getSupported();
        }
        if (this.configuration.isWebIrcEnabled()) {
            String webIrcCommand = "WEBIRC " + this.configuration.getWebIrcPassword() + " " + this.configuration.getWebIrcUsername() + " " + this.configuration.getWebIrcHostname() + " " + this.configuration.getWebIrcAddress().getHostAddress();
            this.sendRaw().rawLineNow(webIrcCommand, webIrcCommand.replace(this.configuration.getWebIrcPassword(), "XXXXXXXX"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.configuration.getServerPassword())) {
            this.sendRaw().rawLineNow("PASS " + this.configuration.getServerPassword(), "PASS XXXXXXXX");
        }
        this.sendRaw().rawLineNow("NICK " + this.configuration.getName());
        this.sendRaw().rawLineNow("USER " + this.configuration.getLogin() + " 8 * :" + this.configuration.getRealName());
        this.startLineProcessing();
        return ImmutableMap.of();
    }

    protected void changeSocket(Socket socket) throws IOException {
        this.socket = socket;
        this.inputReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), this.configuration.getEncoding()));
        this.outputWriter = new OutputStreamWriter(socket.getOutputStream(), this.configuration.getEncoding());
    }

    protected void startLineProcessing() {
        while (this.processNextLine()) {
        }
        this.shutdown();
    }

    protected boolean processNextLine() {
        String debug;
        String line;
        try {
            line = this.inputReader.readLine();
        }
        catch (InterruptedIOException iioe) {
            this.sendRaw().rawLine("PING " + System.currentTimeMillis() / 1000L);
            return true;
        }
        catch (Exception e) {
            if (Thread.interrupted()) {
                log.error("--- PircBotX interrupted during read, aborting reconnect loop and shutting down ---");
                this.stopBotReconnect();
                return false;
            }
            if (this.socket.isClosed()) {
                if (INFO_LEVEL != null) {
                    log.log(INFO_LEVEL, "Socket is closed, stopping read loop and shutting down");
                }
                return false;
            }
            this.disconnectException = e;
            debug = "Exception encountered when reading next line from server";
            log.error(debug, (Throwable)e);
            Utils.dispatchEvent(this, new ExceptionEvent(this, e, debug));
            line = null;
        }
        if (Thread.interrupted()) {
            log.error("--- PircBotX interrupted during read, aborting reconnect loop and shutting down ---");
            this.stopBotReconnect();
            return false;
        }
        if (line == null) {
            return false;
        }
        try {
            this.inputParser.handleLine(line);
        }
        catch (Exception e) {
            debug = "Exception encountered when parsing line " + line;
            log.error(debug, (Throwable)e);
            Utils.dispatchEvent(this, new ExceptionEvent(this, e, debug));
        }
        if (Thread.interrupted()) {
            log.error("--- PircBotX interrupted during parsing, aborting reconnect loop and shutting down ---");
            this.stopBotReconnect();
            return false;
        }
        return true;
    }

    protected void sendRawLineToServer(String line) throws IOException {
        if (line.length() > this.configuration.getMaxLineLength() - 2) {
            line = line.substring(0, this.configuration.getMaxLineLength() - 2);
        }
        if (line.indexOf(10) > -1) {
            line = line.substring(0, line.indexOf(10)).trim();
        }
        this.outputWriter.write(line + "\r\n");
        this.outputWriter.flush();
        List<String> lineParts = Utils.tokenizeLine(line);
        this.getConfiguration().getListenerManager().onEvent(new OutputEvent(this, line, lineParts));
    }

    protected void onLoggedIn(String nick) {
        this.loggedIn = true;
        this.setNick(nick);
        this.connectAttempts = 0;
        if (this.configuration.isShutdownHookEnabled()) {
            this.shutdownHook = new BotShutdownHook(this);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    public OutputRaw sendRaw() {
        return this.outputRaw;
    }

    public OutputIRC sendIRC() {
        return this.outputIRC;
    }

    @Deprecated
    public OutputIRC send() {
        return this.outputIRC;
    }

    public OutputCAP sendCAP() {
        return this.outputCAP;
    }

    public OutputDCC sendDCC() {
        return this.outputDCC;
    }

    protected void setNick(String nick) {
        this.nick = nick;
    }

    public String getNick() {
        return this.nick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.socket != null && !this.socket.isClosed();
        }
    }

    public String toString() {
        return "Version{" + this.configuration.getVersion() + "} Connected{" + this.isConnected() + "} Server{" + this.getServerHostname() + "} Port{" + this.getServerPort() + "}";
    }

    public User getUserBot() {
        return this.userChannelDao.getUser(this.getNick());
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getConnectionId() {
        return this.connectAttemptTotal;
    }

    protected ImmutableMap<String, String> reconnectChannels() {
        ImmutableMap<String, String> reconnectChannelsLocal = this.reconnectChannels;
        this.reconnectChannels = null;
        return reconnectChannelsLocal;
    }

    @Override
    public void close() {
        try {
            this.socket.close();
        }
        catch (Exception e) {
            log.error("Can't close socket", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        UserChannelDaoSnapshot daoSnapshot;
        Object object = this.stateLock;
        synchronized (object) {
            if (DEBUG_LEVEL != null) {
                log.log(DEBUG_LEVEL, "---PircBotX shutdown started---");
            }
            if (this.state == State.DISCONNECTED) {
                throw new RuntimeException("Cannot call shutdown twice");
            }
            this.state = State.DISCONNECTED;
            if (this.configuration.isIdentServerEnabled()) {
                IdentServer.getServer().removeIdentEntry(this.socket.getInetAddress(), this.socket.getPort(), this.socket.getLocalPort(), this.configuration.getLogin());
            }
            if (this.socket != null && !this.socket.isClosed()) {
                try {
                    this.socket.close();
                }
                catch (Exception e) {
                    log.error("Cannot close socket", (Throwable)e);
                }
            }
            ImmutableMap.Builder reconnectChannelsBuilder = ImmutableMap.builder();
            for (Channel curChannel : this.userChannelDao.getAllChannels()) {
                String key = curChannel.getChannelKey() == null ? "" : curChannel.getChannelKey();
                reconnectChannelsBuilder.put((Object)curChannel.getName(), (Object)key);
            }
            this.reconnectChannels = reconnectChannelsBuilder.build();
            this.loggedIn = false;
            daoSnapshot = this.configuration.isSnapshotsEnabled() ? this.userChannelDao.createSnapshot() : null;
            this.userChannelDao.close();
            this.inputParser.close();
            this.dccHandler.close();
        }
        this.configuration.getListenerManager().onEvent(new DisconnectEvent(this, daoSnapshot, this.disconnectException));
        this.disconnectException = null;
        if (DEBUG_LEVEL != null) {
            log.log(DEBUG_LEVEL, "Disconnected.");
        }
        this.configuration.getListenerManager().shutdown(this);
    }

    @Override
    public int compareTo(PircBotX other) {
        return Integer.compare(this.getBotId(), other.getBotId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PircBotX)) {
            return false;
        }
        PircBotX other = (PircBotX)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getBotId() == other.getBotId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PircBotX;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBotId();
        return result;
    }

    public int getBotId() {
        return this.botId;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public InputParser getInputParser() {
        return this.inputParser;
    }

    public UserChannelDao<User, Channel> getUserChannelDao() {
        return this.userChannelDao;
    }

    public DccHandler getDccHandler() {
        return this.dccHandler;
    }

    protected Socket getSocket() {
        return this.socket;
    }

    public List<String> getEnabledCapabilities() {
        return this.enabledCapabilities;
    }

    public String getServerHostname() {
        return this.serverHostname;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public boolean isNickservIdentified() {
        return this.nickservIdentified;
    }

    protected void setNickservIdentified(boolean nickservIdentified) {
        this.nickservIdentified = nickservIdentified;
    }

    public static enum State {
        INIT,
        CONNECTED,
        DISCONNECTED;

    }

    protected static class BotShutdownHook
    extends Thread {
        protected final WeakReference<PircBotX> thisBotRef;

        public BotShutdownHook(PircBotX bot) {
            this.thisBotRef = new WeakReference<PircBotX>(bot);
            this.setName("bot" + BOT_COUNT + "-shutdownhook");
        }

        @Override
        public void run() {
            block4: {
                PircBotX thisBot = (PircBotX)this.thisBotRef.get();
                if (thisBot != null && thisBot.getState() != State.DISCONNECTED) {
                    thisBot.stopBotReconnect();
                    thisBot.sendIRC().quitServer();
                    try {
                        if (thisBot.isConnected()) {
                            thisBot.socket.close();
                        }
                    }
                    catch (IOException ex) {
                        if (DEBUG_LEVEL == null) break block4;
                        log.log(DEBUG_LEVEL, "Unabloe to forcibly close socket", (Throwable)ex);
                    }
                }
            }
        }
    }
}

