/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx;

import com.google.common.base.CharMatcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Event;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.types.GenericMessageEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.message.ParameterizedMessage;

public final class Utils {
    private static final Map<String, String> V3_TAGS_UNESCAPE_MAPPING = Utils.createV3TagsUnescapeMapping();
    private static final Pattern V3_TAGS_UNESCAPE_PATTERN = Utils.createV3TagsUnescapePattern();

    private Utils() {
    }

    public static void dispatchEvent(PircBotX bot, Event event) {
        bot.getConfiguration().getListenerManager().onEvent(event);
    }

    public static int tryParseInt(String intString, int defaultValue) {
        try {
            return Integer.parseInt(intString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long tryParseLong(String longString, int defaultValue) {
        try {
            return Long.parseLong(longString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static <V> V tryGetIndex(List<V> list, int index, V defaultValue) {
        if (index < list.size()) {
            return list.get(index);
        }
        return defaultValue;
    }

    @Nullable
    public static String parseCommand(String expectedPrefix, GenericMessageEvent event) {
        return Utils.parseCommand(expectedPrefix, event.getMessage());
    }

    @Nullable
    public static String parseCommand(@NonNull String expectedPrefix, @NonNull String rawCommand) {
        if (expectedPrefix == null) {
            throw new NullPointerException("expectedPrefix is marked non-null but is null");
        }
        if (rawCommand == null) {
            throw new NullPointerException("rawCommand is marked non-null but is null");
        }
        if (rawCommand.startsWith(expectedPrefix)) {
            return rawCommand.substring(expectedPrefix.length());
        }
        return null;
    }

    public static void addBotToMDC(PircBotX bot) {
        ThreadContext.put((String)"net.creeperhost.minetogether.repack.net.covers1624.pircbotx.id", (String)String.valueOf(bot.getBotId()));
        ThreadContext.put((String)"net.creeperhost.minetogether.repack.net.covers1624.pircbotx.connectionId", (String)(bot.getServerHostname() + "-" + bot.getBotId() + "-" + bot.getConnectionId()));
        ThreadContext.put((String)"net.creeperhost.minetogether.repack.net.covers1624.pircbotx.server", (String)StringUtils.defaultString((String)bot.getServerHostname()));
        ThreadContext.put((String)"net.creeperhost.minetogether.repack.net.covers1624.pircbotx.port", (String)String.valueOf(bot.getServerPort()));
    }

    public static void sendRawLineToServer(PircBotX bot, String rawLine) throws IOException {
        bot.sendRawLineToServer(rawLine);
    }

    public static void setNickServIdentified(PircBotX bot) {
        bot.setNickservIdentified(true);
    }

    public static String format(String messagePattern, Object ... args) {
        return ParameterizedMessage.format((String)messagePattern, (Object[])args);
    }

    public static List<String> tokenizeLine(String input) {
        int end;
        ArrayList<String> stringParts = new ArrayList<String>();
        if (input == null || input.length() == 0) {
            return stringParts;
        }
        String trimmedInput = CharMatcher.whitespace().trimFrom((CharSequence)input);
        int pos = 0;
        while ((end = trimmedInput.indexOf(32, pos)) >= 0) {
            stringParts.add(trimmedInput.substring(pos, end));
            pos = end + 1;
            if (trimmedInput.charAt(pos) != ':') continue;
            stringParts.add(trimmedInput.substring(pos + 1));
            return stringParts;
        }
        stringParts.add(trimmedInput.substring(pos));
        return stringParts;
    }

    private static Map<String, String> createV3TagsUnescapeMapping() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("\\:", ";");
        mapping.put("\\s", " ");
        mapping.put("\\\\", "\\");
        mapping.put("\\r", "\r");
        mapping.put("\\n", "\n");
        return mapping;
    }

    private static Pattern createV3TagsUnescapePattern() {
        ArrayList<String> regexGroups = new ArrayList<String>();
        for (String mappingKey : V3_TAGS_UNESCAPE_MAPPING.keySet()) {
            regexGroups.add(mappingKey.replace("\\", "\\\\"));
        }
        return Pattern.compile("(" + StringUtils.join(regexGroups, (String)"|") + ")");
    }

    public static String unescapeV3TagValue(String v3TagValue) {
        Matcher matcher = V3_TAGS_UNESCAPE_PATTERN.matcher(v3TagValue);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String replacement = V3_TAGS_UNESCAPE_MAPPING.get(matcher.group(1)).replace("\\", "\\\\");
            matcher.appendReplacement(stringBuffer, replacement);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

