/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.dcc;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.dcc.DccHandler;
import net.creeperhost.minetogether.repack.org.pircbotx.dcc.DccState;
import net.creeperhost.minetogether.repack.org.pircbotx.dcc.FileTransfer;
import net.creeperhost.minetogether.repack.org.pircbotx.dcc.SendFileTransferAcknowlegement;
import net.creeperhost.minetogether.repack.org.pircbotx.exception.DccException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReceiveFileTransfer
extends FileTransfer {
    private static final Logger log = LogManager.getLogger(ReceiveFileTransfer.class);
    SendFileTransferAcknowlegement acknowledge;

    public ReceiveFileTransfer(PircBotX bot, DccHandler dccHandler, DccHandler.PendingFileTransfer pendingFileTransfer, File file) {
        super(bot, dccHandler, pendingFileTransfer, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void transferFile() {
        long bytesToRead = 8192L;
        try (SocketChannel inChannel = this.socket.getChannel();
             RandomAccessFile outputStream = new RandomAccessFile(this.file, "rw");
             FileChannel outChannel = outputStream.getChannel();){
            this.acknowledge = new SendFileTransferAcknowlegement(inChannel, outChannel);
            this.fileTransferStatus.start();
            outChannel.position(this.fileTransferStatus.startPosition);
            while (outChannel.position() < this.fileTransferStatus.fileSize && !this.dccHandler.shuttingDown && this.fileTransferStatus.dccState != DccState.SHUTDOWN) {
                if (bytesToRead > this.fileTransferStatus.fileSize - outChannel.position()) {
                    bytesToRead = this.fileTransferStatus.fileSize - outChannel.position();
                }
                outChannel.position(outChannel.position() + outChannel.transferFrom(inChannel, outChannel.position(), bytesToRead));
                this.fileTransferStatus.bytesTransfered = outChannel.position();
                this.fileTransferStatus.bytesAcknowledged = this.acknowledge.call();
            }
            this.fileTransferStatus.dccState = DccState.WAITING;
            if (PircBotX.INFO_LEVEL != null) {
                log.log(PircBotX.INFO_LEVEL, "Receive file transfer of file {} entered {} state for server to close the socket", (Object)this.file.getName(), (Object)this.fileTransferStatus.dccState);
            }
            try {
                this.fileTransferStatus.join();
                this.fileTransferStatus.dccState = DccState.DONE;
            }
            catch (InterruptedException e) {
                this.fileTransferStatus.dccState = DccState.ERROR;
                log.error("Receive file transfer of file {} failed to clean up gracefully! Please report this error with logs.", (Object)this.file.getName(), (Object)e);
            }
        }
        catch (IOException e) {
            this.fileTransferStatus.dccState = DccState.ERROR;
            this.fileTransferStatus.exception = new DccException(DccException.Reason.FILE_TRANSFER_CANCELLED, this.user, "User closed socket", e);
        }
        finally {
            if (PircBotX.INFO_LEVEL != null) {
                log.log(PircBotX.INFO_LEVEL, "Receive file transfer of file {} ended with state {}", (Object)this.file.getName(), (Object)this.fileTransferStatus.dccState);
            }
        }
    }
}

