/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.hooks.events;

import lombok.NonNull;
import net.creeperhost.minetogether.repack.org.pircbotx.Channel;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.User;
import net.creeperhost.minetogether.repack.org.pircbotx.UserHostmask;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Event;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.types.GenericChannelModeEvent;

public class SetChannelBanEvent
extends Event
implements GenericChannelModeEvent {
    protected final Channel channel;
    protected final UserHostmask userHostmask;
    protected final User user;
    protected final UserHostmask banHostmask;

    public SetChannelBanEvent(PircBotX bot, @NonNull Channel channel, @NonNull UserHostmask userHostmask, User user, UserHostmask banHostmask) {
        super(bot);
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (userHostmask == null) {
            throw new NullPointerException("userHostmask is marked non-null but is null");
        }
        this.channel = channel;
        this.userHostmask = userHostmask;
        this.user = user;
        this.banHostmask = banHostmask;
    }

    @Deprecated
    public UserHostmask getHostmask() {
        return this.banHostmask;
    }

    @Override
    public void respond(String response) {
        this.getChannel().send().message(this.getUser(), response);
    }

    public UserHostmask getBanHostmask() {
        return this.banHostmask;
    }

    public String toString() {
        return "SetChannelBanEvent(channel=" + this.getChannel() + ", userHostmask=" + this.getUserHostmask() + ", user=" + this.getUser() + ", banHostmask=" + this.getBanHostmask() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetChannelBanEvent)) {
            return false;
        }
        SetChannelBanEvent other = (SetChannelBanEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Channel this$channel = this.getChannel();
        Channel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        UserHostmask this$userHostmask = this.getUserHostmask();
        UserHostmask other$userHostmask = other.getUserHostmask();
        if (this$userHostmask == null ? other$userHostmask != null : !((Object)this$userHostmask).equals(other$userHostmask)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        UserHostmask this$banHostmask = this.getBanHostmask();
        UserHostmask other$banHostmask = other.getBanHostmask();
        return !(this$banHostmask == null ? other$banHostmask != null : !((Object)this$banHostmask).equals(other$banHostmask));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SetChannelBanEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Channel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        UserHostmask $userHostmask = this.getUserHostmask();
        result = result * 59 + ($userHostmask == null ? 43 : ((Object)$userHostmask).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        UserHostmask $banHostmask = this.getBanHostmask();
        result = result * 59 + ($banHostmask == null ? 43 : ((Object)$banHostmask).hashCode());
        return result;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public UserHostmask getUserHostmask() {
        return this.userHostmask;
    }

    @Override
    public User getUser() {
        return this.user;
    }
}

