/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.hooks.events;

import com.google.common.collect.ImmutableSortedSet;
import lombok.NonNull;
import net.creeperhost.minetogether.repack.org.pircbotx.Channel;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.User;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Event;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.types.GenericChannelEvent;

public class UserListEvent
extends Event
implements GenericChannelEvent {
    protected final Channel channel;
    protected final ImmutableSortedSet<User> users;
    protected final boolean complete;

    public UserListEvent(PircBotX bot, @NonNull Channel channel, @NonNull ImmutableSortedSet<User> users, boolean complete) {
        super(bot);
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (users == null) {
            throw new NullPointerException("users is marked non-null but is null");
        }
        this.channel = channel;
        this.users = users;
        this.complete = complete;
    }

    @Override
    public void respond(String response) {
        this.getChannel().send().message(response);
    }

    public ImmutableSortedSet<User> getUsers() {
        return this.users;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String toString() {
        return "UserListEvent(channel=" + this.getChannel() + ", users=" + this.getUsers() + ", complete=" + this.isComplete() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserListEvent)) {
            return false;
        }
        UserListEvent other = (UserListEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Channel this$channel = this.getChannel();
        Channel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        ImmutableSortedSet<User> this$users = this.getUsers();
        ImmutableSortedSet<User> other$users = other.getUsers();
        if (this$users == null ? other$users != null : !this$users.equals(other$users)) {
            return false;
        }
        return this.isComplete() == other.isComplete();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UserListEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Channel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        ImmutableSortedSet<User> $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : $users.hashCode());
        result = result * 59 + (this.isComplete() ? 79 : 97);
        return result;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }
}

