/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.output;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import lombok.NonNull;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.Utils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutputRaw {
    private static final Logger log = LogManager.getLogger(OutputRaw.class);
    @NonNull
    protected final PircBotX bot;
    protected final ReentrantLock writeLock = new ReentrantLock(true);
    protected final RateLimiter limiter;

    public OutputRaw(PircBotX bot) {
        this.bot = bot;
        long delayMs = bot.getConfiguration().getMessageDelay().getDelay();
        this.limiter = delayMs >= 1L ? RateLimiter.create((double)(1000.0 / (double)delayMs)) : RateLimiter.create((double)10000.0);
    }

    public void rawLine(String line) {
        this.rawLine(line, null);
    }

    public void rawLine(String line, String logline) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)line), (String)"Cannot send empty line to server: '%s'", (Object)line);
        Preconditions.checkArgument((boolean)this.bot.isConnected(), (Object)"Not connected to server");
        this.limiter.acquire();
        if (PircBotX.INFO_LEVEL != null && PircBotX.VERY_VERBOSE) {
            if (StringUtils.isNotBlank((CharSequence)logline)) {
                log.log(PircBotX.INFO_LEVEL, logline);
            } else {
                log.log(PircBotX.INFO_LEVEL, line);
            }
        }
        this.writeLock.lock();
        try {
            Utils.sendRawLineToServer(this.bot, line);
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception when sending line to server, is the network still up? " + this.exceptionDebug(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not send line to server. " + this.exceptionDebug(), e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void rawLineNow(String line) {
        this.rawLineNow(line, null);
    }

    public void rawLineNow(String line, String logline) {
        Preconditions.checkNotNull((Object)line, (Object)"Line cannot be null");
        Preconditions.checkArgument((boolean)this.bot.isConnected(), (Object)"Not connected to server");
        if (PircBotX.INFO_LEVEL != null && PircBotX.VERY_VERBOSE) {
            if (StringUtils.isNotBlank((CharSequence)logline)) {
                log.log(PircBotX.INFO_LEVEL, logline);
            } else {
                log.log(PircBotX.INFO_LEVEL, line);
            }
        }
        this.writeLock.lock();
        try {
            Utils.sendRawLineToServer(this.bot, line);
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception when sending line to server, is the network still up? " + this.exceptionDebug(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not send line to server. " + this.exceptionDebug(), e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void rawLineSplit(String prefix, String message) {
        this.rawLineSplit(prefix, message, "");
    }

    public void rawLineSplit(String prefix, String message, String suffix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"Prefix cannot be null");
        Preconditions.checkNotNull((Object)message, (Object)"Message cannot be null");
        Preconditions.checkNotNull((Object)suffix, (Object)"Suffix cannot be null");
        String finalMessage = prefix + message + suffix;
        int realMaxLineLength = this.bot.getConfiguration().getMaxLineLength() - 2;
        if (!this.bot.getConfiguration().isAutoSplitMessage() || finalMessage.length() < realMaxLineLength && finalMessage.indexOf(10) == -1) {
            this.rawLine(finalMessage);
            return;
        }
        int maxMessageLength = realMaxLineLength - (prefix + suffix).length();
        List lines = Splitter.on((char)'\n').omitEmptyStrings().trimResults().splitToList((CharSequence)message);
        for (String line : lines) {
            finalMessage = prefix + line + suffix;
            for (String curPart : StringUtils.split((String)WordUtils.wrap((String)line, (int)maxMessageLength, (String)"\r\n", (boolean)true), (String)"\r\n")) {
                this.rawLine(prefix + curPart + suffix);
            }
        }
    }

    public int getOutgoingQueueSize() {
        return this.writeLock.getHoldCount();
    }

    protected String exceptionDebug() {
        return "Connected: " + this.bot.isConnected() + " | Bot State: " + (Object)((Object)this.bot.getState());
    }
}

