/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.output;

import java.io.File;
import java.io.IOException;
import lombok.NonNull;
import net.creeperhost.minetogether.repack.org.pircbotx.Channel;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.UserHostmask;
import net.creeperhost.minetogether.repack.org.pircbotx.dcc.SendChat;
import net.creeperhost.minetogether.repack.org.pircbotx.dcc.SendFileTransfer;
import net.creeperhost.minetogether.repack.org.pircbotx.exception.DccException;
import net.creeperhost.minetogether.repack.org.pircbotx.output.GenericChannelUserOutput;

public class OutputUser
implements GenericChannelUserOutput {
    @NonNull
    protected final PircBotX bot;
    @NonNull
    protected final UserHostmask serverUser;

    public void invite(String channel) {
        this.bot.sendIRC().invite(this.serverUser.getNick(), channel);
    }

    public void invite(Channel channel) {
        this.bot.sendIRC().invite(this.serverUser.getNick(), channel.getName());
    }

    @Override
    public void notice(String notice) {
        this.bot.sendIRC().notice(this.serverUser.getNick(), notice);
    }

    @Override
    public void action(String action) {
        this.bot.sendIRC().action(this.serverUser.getNick(), action);
    }

    @Override
    public void message(String message) {
        this.bot.sendIRC().message(this.serverUser.getNick(), message);
    }

    public void ctcpCommand(String command) {
        this.bot.sendIRC().ctcpCommand(this.serverUser.getNick(), command);
    }

    public void ctcpResponse(String message) {
        this.bot.sendIRC().ctcpResponse(this.serverUser.getNick(), message);
    }

    public void mode(String mode) {
        this.bot.sendIRC().mode(this.serverUser.getNick(), mode);
    }

    public SendFileTransfer dccFile(File file) throws IOException, DccException, InterruptedException {
        return this.bot.getDccHandler().sendFile(file, this.bot.getUserChannelDao().getUser(this.serverUser));
    }

    public SendFileTransfer dccFile(File file, boolean passive) throws IOException, DccException, InterruptedException {
        return this.bot.getDccHandler().sendFile(file, this.bot.getUserChannelDao().getUser(this.serverUser), passive);
    }

    public SendChat dccChat() throws IOException, InterruptedException {
        return this.bot.getDccHandler().sendChat(this.bot.getUserChannelDao().getUser(this.serverUser));
    }

    public SendChat dccChat(boolean passive) throws IOException, InterruptedException {
        return this.bot.getDccHandler().sendChat(this.bot.getUserChannelDao().getUser(this.serverUser), passive);
    }

    public void whois() {
        this.bot.sendIRC().whois(this.serverUser.getNick());
    }

    public void whoisDetail() {
        this.bot.sendIRC().whoisDetail(this.serverUser.getNick());
    }

    public OutputUser(@NonNull PircBotX bot, @NonNull UserHostmask serverUser) {
        if (bot == null) {
            throw new NullPointerException("bot is marked non-null but is null");
        }
        if (serverUser == null) {
            throw new NullPointerException("serverUser is marked non-null but is null");
        }
        this.bot = bot;
        this.serverUser = serverUser;
    }
}

