/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.MineTogetherServer;
import net.creeperhost.minetogether.lib.web.ApiClientResponse;
import net.creeperhost.minetogether.lib.web.ApiResponse;
import net.creeperhost.minetogether.server.web.SendInviteRequest;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.server.players.UserWhiteListEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandInvite {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final SimpleCommandExceptionType INVALID_USERNAME = new SimpleCommandExceptionType((Message)Component.literal((String)"Invalid username"));
    private static final SimpleCommandExceptionType INVALID_GAME_PROFILE = new SimpleCommandExceptionType((Message)Component.literal((String)"Failed to load GameProfile, Username is not valid"));
    private static final DynamicCommandExceptionType ALREADY_WHITELISTED = new DynamicCommandExceptionType(username -> Component.translatable((String)(username + " Is already whitelisted")));

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"invite").requires(cs -> cs.hasPermission(3))).then(Commands.argument((String)"username", (ArgumentType)StringArgumentType.string()).executes(cs -> CommandInvite.execute((CommandContext<CommandSourceStack>)cs, StringArgumentType.getString((CommandContext)cs, (String)"username"))));
    }

    private static int execute(CommandContext<CommandSourceStack> cs, String username) throws CommandSyntaxException {
        MinecraftServer minecraftServer = ((CommandSourceStack)cs.getSource()).getServer();
        if (username.isEmpty()) {
            throw INVALID_USERNAME.create();
        }
        GameProfile gameProfile = (GameProfile)minecraftServer.getProfileCache().get(username).get();
        if (gameProfile == null) {
            throw INVALID_GAME_PROFILE.create();
        }
        if (minecraftServer.getPlayerList().getWhiteList().isWhiteListed(gameProfile)) {
            throw ALREADY_WHITELISTED.create((Object)username);
        }
        UserWhiteListEntry userWhiteListEntry = new UserWhiteListEntry(gameProfile);
        minecraftServer.getPlayerList().getWhiteList().add((StoredUserEntry)userWhiteListEntry);
        minecraftServer.getPlayerList().reloadWhiteList();
        CommandInvite.sendUserInvite(gameProfile, minecraftServer);
        ((CommandSourceStack)cs.getSource()).sendSuccess(() -> Component.literal((String)(username + " Added to whitelist")), false);
        return 0;
    }

    public static void sendUserInvite(GameProfile profile, MinecraftServer server) {
        UserWhiteList whitelistedPlayers = server.getPlayerList().getWhiteList();
        ArrayList<String> tempHash = new ArrayList<String>();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(((UserWhiteListEntry)whitelistedPlayers.get((Object)profile)).toString().getBytes(StandardCharsets.UTF_8));
            tempHash.add(Arrays.toString(digest.digest(hash)));
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.fatal("SHA256 not supported??", (Throwable)ex);
        }
        try {
            ApiClientResponse<ApiResponse> resp = MineTogether.API.execute(new SendInviteRequest(MineTogetherServer.inviteId, tempHash));
            LOGGER.debug("Response from add endpoint " + resp.apiResponse().getStatus() + " " + resp.apiResponse().getMessageOrNull());
        }
        catch (IOException e) {
            LOGGER.error("Failed to send invite.");
        }
    }
}

