/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.creeperhost.minetogether.server.PregenHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class CommandPregen {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pregen").requires(cs -> cs.hasPermission(4))).then(Commands.argument((String)"dimention", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"minX", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"maxX", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"minZ", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"maxZ", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"chunksPerTick", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"preventJoin", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CommandPregen.execute((CommandSourceStack)ctx.getSource(), DimensionArgument.getDimension((CommandContext)ctx, (String)"dimention"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"minX"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxX"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"minZ"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxZ"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"chunksPerTick"), BoolArgumentType.getBool((CommandContext)ctx, (String)"preventJoin"))))))))));
    }

    private static int execute(CommandSourceStack cs, ServerLevel dimention, int minX, int maxX, int minZ, int maxZ, int chunksPerTick, boolean preventJoin) {
        ServerLevel serverLevel = cs.getLevel();
        BlockPos spawn = serverLevel.getSharedSpawnPos();
        int xStartChunk = spawn.getX();
        int zStartChunk = spawn.getY();
        int xDiameter = minX;
        int zDiameter = minZ;
        int chunkMinX = xStartChunk - xDiameter / 2;
        int chunkMaxX = xStartChunk + xDiameter / 2;
        int chunkMinZ = zStartChunk - zDiameter / 2;
        int chunkMaxZ = zStartChunk + zDiameter / 2;
        PregenHandler.addTask((ResourceKey<Level>)dimention.dimension(), chunkMinX, chunkMaxX, chunkMinZ, chunkMaxZ, chunksPerTick, preventJoin);
        cs.sendSuccess(() -> Component.literal((String)("new PregenTask added for " + dimention.dimension().location())), false);
        return 0;
    }
}

