/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.serverlist.gui;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import net.creeperhost.minetogether.chat.gui.MTStyle;
import net.creeperhost.minetogether.gui.MTTextures;
import net.creeperhost.minetogether.serverlist.data.Server;
import net.creeperhost.minetogether.serverlist.gui.ServerDataPublic;
import net.creeperhost.minetogether.serverlist.gui.ServerListGui;
import net.creeperhost.minetogether.util.Countries;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.elements.GuiTexture;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.sprite.Material;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerEntry
extends GuiElement<ServerEntry>
implements BackgroundRender {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LogUtils.getLogger())).build());
    private final ServerDataPublic serverData;
    private final FaviconTexture icon;
    private final ServerListGui gui;
    private final int index;
    @Nullable
    private byte[] lastIconBytes;
    private long lastClicked = 0L;
    private int tick = 0;

    public ServerEntry(@NotNull GuiParent<?> parent, ServerDataPublic data, ServerListGui gui, int index) {
        super(parent);
        this.serverData = data;
        this.icon = FaviconTexture.forServer((TextureManager)this.mc().getTextureManager(), (String)data.ip);
        this.gui = gui;
        this.index = index;
        this.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)24.0));
        GuiRectangle background = new GuiRectangle((GuiParent)this);
        background.fill(() -> MTStyle.Flat.listEntryBackground(background.isMouseOver() || gui.selected == data));
        Constraints.bind((ConstrainedGeometry)background, (ConstrainedGeometry)this);
        GuiTexture iconTexture = (GuiTexture)((GuiTexture)((GuiTexture)((GuiTexture)new GuiTexture((GuiParent)background, () -> Material.fromRawTexture((ResourceLocation)this.icon.textureLocation())).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.TOP), (double)1.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.BOTTOM), (double)-1.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)1.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)(background.ySize() - 2.0)));
        GuiTexture signal = (GuiTexture)((GuiTexture)((GuiTexture)((GuiTexture)new GuiTexture((GuiParent)background, MTTextures.getter(this::getSignalIcon)).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.TOP), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)12.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        GuiTexture flag = (GuiTexture)((GuiTexture)((GuiTexture)((GuiTexture)((GuiTexture)((GuiTexture)new GuiTexture((GuiParent)background, this::getFlag).setTooltipSingle(() -> Component.literal((String)Countries.COUNTRIES.getOrDefault(this.serverData.server.location.countryCode, this.serverData.server.location.countryCode)))).setTooltipDelay(0)).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.BOTTOM), (double)-2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)9.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> this.flagWidth(9.0)));
        GuiText signalInfo = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)background, this::signalInfo).setWrap(false).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.TOP), (double)3.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)signal.get(GeoParam.LEFT), (double)-2.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> this.font().width((FormattedText)this.signalInfo())))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        GuiText status = (GuiText)((GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)background, () -> data.status).setWrap(false).setTooltip(this::playersToolTip)).setTooltipDelay(0)).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.BOTTOM), (double)-2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)flag.get(GeoParam.LEFT), (double)-2.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> Math.max(this.font().width((FormattedText)data.status), 16)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        GuiText name = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)background, (Component)Component.literal((String)data.name)).setAlignment(Align.MIN).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.TOP), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)iconTexture.get(GeoParam.RIGHT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)signalInfo.get(GeoParam.LEFT), (double)-4.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        GuiText motd = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)background, () -> data.motd).setAlignment(Align.MIN).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)name.get(GeoParam.BOTTOM), (double)3.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)iconTexture.get(GeoParam.RIGHT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)status.get(GeoParam.LEFT), (double)-4.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        GuiButton connectBtn = ((GuiButton)new GuiButton((GuiParent)background).setEnabled(() -> ((GuiRectangle)background).isMouseOver())).onPress(() -> gui.join(this.serverData));
        Constraints.bind((ConstrainedGeometry)connectBtn, (ConstrainedGeometry)iconTexture);
        GuiTexture connectBtnTex = new GuiTexture((GuiParent)connectBtn, () -> MTTextures.get(connectBtn.isMouseOver() ? "buttons/join_highlight" : "buttons/join"));
        Constraints.bind((ConstrainedGeometry)connectBtnTex, (ConstrainedGeometry)connectBtn);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver()) {
            if (this.gui.selected != this.serverData) {
                this.gui.selected = this.serverData;
                this.mc().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            } else if (System.currentTimeMillis() - this.lastClicked < 250L) {
                this.gui.join(this.serverData);
                this.mc().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
            this.lastClicked = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        byte[] bs;
        render.rect(this.xMin(), this.yMax(), this.xSize(), 1.0, MTStyle.Flat.listEntryBackground(true));
        render.rect(this.xMin(), this.yMax(), this.xSize(), 1.0, MTStyle.Flat.listEntryBackground(true));
        if (!this.serverData.pinged) {
            this.doPing();
        }
        if (!Arrays.equals(bs = this.serverData.getIconBytes(), this.lastIconBytes)) {
            if (this.uploadServerIcon(bs)) {
                this.lastIconBytes = bs;
            } else {
                this.serverData.setIconBytes(null);
            }
        }
    }

    public void update() {
        this.tick += 4;
        if (!this.serverData.pinged && this.tick > this.index) {
            this.doPing();
        }
    }

    private void doPing() {
        if (!this.serverData.pinged) {
            this.serverData.pinged = true;
            this.serverData.ping = -2L;
            this.serverData.motd = Component.empty();
            this.serverData.status = Component.empty();
            THREAD_POOL.submit(() -> {
                try {
                    this.gui.getPinger().pingServer((ServerData)this.serverData, () -> {});
                    this.gui.sortDirty = true;
                }
                catch (UnknownHostException var2) {
                    this.serverData.ping = -1L;
                    this.serverData.motd = Component.translatable((String)"multiplayer.status.cannot_resolve").withStyle(ChatFormatting.DARK_RED);
                }
                catch (Exception var3) {
                    this.serverData.ping = -1L;
                    this.serverData.motd = Component.translatable((String)"multiplayer.status.cannot_connect").withStyle(ChatFormatting.DARK_RED);
                }
            });
        }
    }

    private boolean uploadServerIcon(@Nullable byte[] bs) {
        if (bs == null) {
            this.icon.clear();
        } else {
            try {
                this.icon.upload(NativeImage.read((byte[])bs));
            }
            catch (Throwable var3) {
                LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.serverData.name, this.serverData.ip, var3});
                return false;
            }
        }
        return true;
    }

    private String getSignalIcon() {
        if (this.serverData.pinged && this.serverData.ping != -2L) {
            if (this.serverData.ping < 0L) {
                return "signal/signal_0";
            }
            if (this.serverData.ping < 150L) {
                return "signal/signal_5";
            }
            if (this.serverData.ping < 300L) {
                return "signal/signal_4";
            }
            if (this.serverData.ping < 600L) {
                return "signal/signal_3";
            }
            if (this.serverData.ping < 1000L) {
                return "signal/signal_2";
            }
            return "signal/signal_1";
        }
        int l = (int)(Util.getMillis() / 100L & 7L);
        if (l > 4) {
            l = 8 - l;
        }
        return "signal/scan_" + l;
    }

    private Component signalInfo() {
        if (this.serverData.pinged && this.serverData.ping != -2L) {
            return this.serverData.ping < 0L ? Component.translatable((String)"multiplayer.status.no_connection").withStyle(ChatFormatting.DARK_RED) : Component.translatable((String)"multiplayer.status.ping", (Object[])new Object[]{this.serverData.ping});
        }
        return Component.translatable((String)"multiplayer.status.pinging");
    }

    private List<Component> playersToolTip() {
        return this.serverData.ping < 0L ? Collections.emptyList() : this.serverData.playerList;
    }

    private Material getFlag() {
        Server.Location location = this.serverData.server.location;
        String code = location.countryCode.toUpperCase(Locale.ROOT);
        code = Countries.COUNTRIES.containsKey(code) ? code.toLowerCase(Locale.ROOT) : "unknown";
        return MTTextures.get("flags/" + code);
    }

    private double flagWidth(double height) {
        TextureAtlasSprite sprite = this.getFlag().sprite();
        return (double)sprite.contents().width() / (double)sprite.contents().height() * height;
    }
}

