/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.serverlist.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.creeperhost.minetogether.chat.gui.MTStyle;
import net.creeperhost.minetogether.serverlist.MineTogetherServerList;
import net.creeperhost.minetogether.serverlist.data.ListType;
import net.creeperhost.minetogether.serverlist.data.SortType;
import net.creeperhost.minetogether.serverlist.gui.ServerDataPublic;
import net.creeperhost.minetogether.serverlist.gui.ServerEntry;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiList;
import net.creeperhost.polylib.client.modulargui.elements.GuiSlider;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.elements.GuiTextField;
import net.creeperhost.polylib.client.modulargui.lib.Assembly;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.GuiProvider;
import net.creeperhost.polylib.client.modulargui.lib.TextState;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Axis;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerStatusPinger;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.Component;

public class ServerListGui
implements GuiProvider {
    private final ServerStatusPinger pinger = new ServerStatusPinger();
    private SortType sorting = SortType.RANDOM;
    private ServerType serverType = ServerType.NONE;
    private List<ServerDataPublic> servers = new ArrayList<ServerDataPublic>();
    private GuiList<ServerDataPublic> serverList;
    private GuiTextField searchField;
    private ModularGui gui;
    private int tick = 0;
    public ServerDataPublic selected;
    public volatile boolean sortDirty = false;

    public GuiElement<?> createRootElement(ModularGui gui) {
        return MTStyle.Flat.background(gui);
    }

    public void buildGui(ModularGui gui) {
        this.gui = gui;
        gui.renderScreenBackground(false);
        gui.initFullscreenGui();
        gui.setGuiTitle((Component)Component.translatable((String)"minetogether:gui.server_list.title"));
        GuiElement root = gui.getRoot();
        GuiText title = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)root, gui.getGuiTitle()).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)5.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.RIGHT)));
        GuiButton communityBtn = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(root, (Component)Component.translatable((String)"minetogether:gui.server_list.type.community")).setTooltip(new Component[]{Component.translatable((String)"minetogether:gui.server_list.type.community.info")})).setToggleMode(() -> this.serverType == ServerType.COMMUNITY).onPress(() -> this.setServerType(this.serverType == ServerType.COMMUNITY ? ServerType.NONE : ServerType.COMMUNITY)).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> (root.getValue(GeoParam.WIDTH) - 20.0) / 3.0 - 8.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)title.get(GeoParam.BOTTOM), (double)6.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        communityBtn.constrain(GeoParam.LEFT, (Constraint)Constraint.midPoint((GeoRef)root.get(GeoParam.LEFT), (GeoRef)root.get(GeoParam.RIGHT), () -> communityBtn.xSize() / -2.0));
        GuiButton publicBtn = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(root, (Component)Component.translatable((String)"minetogether:gui.server_list.type.public")).setTooltip(new Component[]{Component.translatable((String)"minetogether:gui.server_list.type.public.info")})).setToggleMode(() -> this.serverType == ServerType.PUBLIC).onPress(() -> this.setServerType(this.serverType == ServerType.PUBLIC ? ServerType.NONE : ServerType.PUBLIC)).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)communityBtn.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)10.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)communityBtn.get(GeoParam.LEFT), (double)-4.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiButton closedBtn = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(root, (Component)Component.translatable((String)"minetogether:gui.server_list.type.closed")).setTooltip(new Component[]{Component.translatable((String)"minetogether:gui.server_list.type.closed.info")})).setToggleMode(() -> this.serverType == ServerType.CLOSED).onPress(() -> this.setServerType(this.serverType == ServerType.CLOSED ? ServerType.NONE : ServerType.CLOSED)).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)communityBtn.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)communityBtn.get(GeoParam.RIGHT), (double)4.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-10.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiButton back = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(root, (Component)Component.translatable((String)"minetogether:gui.button.back_arrow")).onPress(() -> gui.mc().setScreen(gui.getParentScreen())).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)publicBtn.get(GeoParam.TOP), (double)-4.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)publicBtn.get(GeoParam.LEFT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)50.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        GuiElement listBg = (GuiElement)((GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(root).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)10.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-10.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)publicBtn.get(GeoParam.BOTTOM), (double)3.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.BOTTOM), (double)-18.0));
        GuiElement searchBg = (GuiElement)((GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(root).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)listBg.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)listBg.get(GeoParam.LEFT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)100.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        this.searchField = new GuiTextField((GuiParent)searchBg).setTextState(TextState.simpleState((String)"", s -> this.updateServerList())).setSuggestion((Component)Component.translatable((String)"minetogether:gui.server_list.search"));
        Constraints.bind((ConstrainedGeometry)this.searchField, (ConstrainedGeometry)searchBg, (double)0.0, (double)3.0, (double)0.0, (double)3.0);
        GuiButton refreash = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(root, (Component)Component.translatable((String)"minetogether:gui.button.refresh")).onPress(() -> this.setServerType(this.serverType)).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)listBg.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.midPoint((GeoRef)listBg.get(GeoParam.LEFT), (GeoRef)listBg.get(GeoParam.RIGHT), (double)-50.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)100.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiButton join = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.buttonPrimary(root, (Component)Component.translatable((String)"minetogether:gui.server_list.join")).setEnabled(() -> this.selected != null)).onPress(() -> this.join(this.selected)).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)listBg.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)listBg.get(GeoParam.RIGHT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)100.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiButton sort = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(root, () -> Component.translatable((String)"minetogether:gui.server_list.sort_by").append(" ").append(this.sorting.translate())).onPress(() -> this.cycleSorting(1), 0).onPress(() -> this.cycleSorting(-1), 1).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)publicBtn.get(GeoParam.TOP), (double)-4.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)closedBtn.get(GeoParam.RIGHT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)100.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        this.addTypeInfo(listBg);
        this.setupServerList(listBg);
        gui.onTick(this::tick);
        gui.onClose(() -> ((ServerStatusPinger)this.pinger).removeAll());
    }

    private void tick() {
        this.pinger.tick();
        for (GuiElement value : this.serverList.getElementMap().values()) {
            if (!(value instanceof ServerEntry)) continue;
            ServerEntry entry = (ServerEntry)value;
            entry.update();
        }
        if (this.sortDirty && this.tick++ % 20 == 0) {
            this.sortDirty = false;
            this.cycleSorting(0);
        }
    }

    private void addTypeInfo(GuiElement<?> background) {
        GuiText last = ((GuiText)((GuiText)((GuiText)((GuiText)new GuiText(background, (Component)Component.translatable((String)"minetogether:gui.server_list.type.select").withStyle(ChatFormatting.UNDERLINE)).setEnabled(() -> this.serverType == ServerType.NONE)).setWrap(true).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)5.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)-5.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.TOP), (double)5.0))).autoHeight();
        last = ((GuiText)((GuiText)((GuiText)((GuiText)new GuiText(background, (Component)Component.translatable((String)"minetogether:gui.server_list.type.public.info")).setEnabled(() -> this.serverType == ServerType.NONE)).setWrap(true).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)5.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)-5.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.BOTTOM), (double)10.0))).autoHeight();
        last = ((GuiText)((GuiText)((GuiText)((GuiText)new GuiText(background, (Component)Component.translatable((String)"minetogether:gui.server_list.type.community.info")).setEnabled(() -> this.serverType == ServerType.NONE)).setWrap(true).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)5.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)-5.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.BOTTOM), (double)10.0))).autoHeight();
        last = ((GuiText)((GuiText)((GuiText)((GuiText)new GuiText(background, (Component)Component.translatable((String)"minetogether:gui.server_list.type.closed.info")).setEnabled(() -> this.serverType == ServerType.NONE)).setWrap(true).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.LEFT), (double)5.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)-5.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.BOTTOM), (double)10.0))).autoHeight();
    }

    private void setupServerList(GuiElement<?> background) {
        this.serverList = (GuiList)new GuiList(background).setDisplayBuilder((parent, data) -> new ServerEntry((GuiParent<?>)parent, (ServerDataPublic)((Object)data), this, this.servers.indexOf(data))).setItemSpacing(1.0).setEnabled(() -> this.serverType != ServerType.NONE);
        Constraints.bind(this.serverList, background, (double)1.0, (double)1.0, (double)1.0, (double)1.0);
        Assembly<? extends GuiElement<?>, GuiSlider> scrollBar = MTStyle.Flat.scrollBar(background, Axis.Y);
        ((GuiElement)((GuiElement)((GuiElement)scrollBar.container.setEnabled(() -> this.serverList.hiddenSize() > 0.0).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)background.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)background.get(GeoParam.BOTTOM)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)2.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)6.0));
        ((GuiSlider)scrollBar.primary).setScrollableElement(this.serverList).setSliderState(this.serverList.scrollState());
    }

    private void setServerType(ServerType serverType) {
        this.serverType = serverType;
        this.selected = null;
        if (serverType != ServerType.NONE) {
            this.servers = MineTogetherServerList.updateServers(serverType.listType).stream().map(ServerDataPublic::new).collect(Collectors.toList());
            this.updateServerList();
        }
    }

    public void cycleSorting(int dir) {
        this.sorting = SortType.values()[Math.floorMod(this.sorting.ordinal() + dir, SortType.values().length)];
        if (this.sorting == SortType.RANDOM) {
            Collections.shuffle(this.servers);
        } else {
            try {
                this.servers.sort(this.sorting);
            }
            catch (Throwable ignored) {
                this.sortDirty = true;
            }
        }
        this.updateServerList();
    }

    private void updateServerList() {
        this.serverList.getList().clear();
        this.selected = null;
        String search = this.searchField.getValue().toLowerCase(Locale.ROOT);
        if (search.isEmpty()) {
            this.serverList.getList().addAll(this.servers);
        } else {
            for (ServerDataPublic server : this.servers) {
                String motd;
                String string = motd = server.motd == null ? "" : server.motd.getString().toLowerCase(Locale.ROOT);
                if (!server.name.toLowerCase(Locale.ROOT).contains(search) && !motd.contains(search)) continue;
                this.serverList.add((Object)server);
            }
        }
        this.serverList.markDirty();
    }

    public void join(ServerData serverData) {
        ConnectScreen.startConnecting((Screen)this.gui.getScreen(), (Minecraft)Minecraft.getInstance(), (ServerAddress)ServerAddress.parseString((String)serverData.ip), (ServerData)serverData, (boolean)false);
    }

    public ServerStatusPinger getPinger() {
        return this.pinger;
    }

    static enum ServerType {
        NONE(null),
        PUBLIC(ListType.PUBLIC),
        COMMUNITY(ListType.INVITE),
        CLOSED(ListType.APPLICATION);

        private final ListType listType;

        private ServerType(ListType listType) {
            this.listType = listType;
        }
    }
}

