/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.util;

import com.mojang.serialization.DataResult;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.message.Message;
import net.creeperhost.minetogether.lib.chat.message.MessageComponent;
import net.creeperhost.minetogether.lib.chat.message.ProfileMessageComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;

public class MessageFormatter {
    public static final HoverEvent.Action<Component> SHOW_URL_PREVIEW = new HoverEvent.Action("show_url_preview", true, ComponentSerialization.CODEC, DataResult::success);
    public static final String CLICK_NAME = "CE:CLICK_NAME";
    private static final Pattern URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}:\\/\\/)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_]{1,}\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);

    public static Component formatMessage(Message message) {
        ChatFormatting mc = MessageFormatter.getMessageColour(message);
        ChatFormatting ac = MessageFormatter.getArrowColour(message);
        ChatFormatting uc = MessageFormatter.getUserColour(message);
        String sender = ac + "<" + uc + message.senderName + ac + ">" + ChatFormatting.RESET;
        return Component.literal((String)sender).withStyle(e -> e.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, CLICK_NAME))).append(" ").append(MessageFormatter.formatMessage(message.getMessage(), mc));
    }

    private static Component formatMessage(MessageComponent comp, ChatFormatting messageColour) {
        MutableComponent component = Component.literal((String)"").withStyle(messageColour);
        for (MessageComponent c : comp.iterate()) {
            if (c instanceof ProfileMessageComponent) {
                ProfileMessageComponent profileComp = (ProfileMessageComponent)c;
                if (profileComp.profile == MineTogetherChat.getOurProfile()) {
                    component.append((Component)Component.literal((String)c.getMessage()).withStyle(ChatFormatting.RED));
                    continue;
                }
            }
            component.append(MessageFormatter.sugarLinkWithPreview(c.getMessage(), true, messageColour));
        }
        return component;
    }

    private static ChatFormatting getMessageColour(Message message) {
        if (message.sender != null) {
            if (message.sender.isBanned()) {
                return ChatFormatting.DARK_GRAY;
            }
            if (message.sender == MineTogetherChat.getOurProfile()) {
                return ChatFormatting.GRAY;
            }
        }
        return ChatFormatting.WHITE;
    }

    public static ChatFormatting getArrowColour(Message message) {
        if (message.sender != null) {
            if (message.sender.isPremium()) {
                return ChatFormatting.GREEN;
            }
            if (message.sender == MineTogetherChat.getOurProfile()) {
                return ChatFormatting.GRAY;
            }
        }
        return ChatFormatting.WHITE;
    }

    private static ChatFormatting getUserColour(Message message) {
        if (message.sender == null) {
            return ChatFormatting.AQUA;
        }
        boolean isOnSamePack = MineTogetherChat.getOurProfile().isOnSamePack(message.sender);
        if (message.sender.isFriend()) {
            return isOnSamePack ? ChatFormatting.GOLD : ChatFormatting.YELLOW;
        }
        if (message.sender == MineTogetherChat.getOurProfile()) {
            return ChatFormatting.GRAY;
        }
        if (isOnSamePack) {
            return ChatFormatting.DARK_PURPLE;
        }
        return ChatFormatting.WHITE;
    }

    private static Component sugarLinkWithPreview(String string, boolean allowMissingHeader, ChatFormatting messageColour) {
        MutableComponent ichat = null;
        Matcher matcher = URL_PATTERN.matcher(string);
        int lastEnd = 0;
        while (matcher.find()) {
            MutableComponent link;
            Object url;
            block13: {
                int start = matcher.start();
                int end = matcher.end();
                String part = string.substring(lastEnd, start);
                if (part.length() > 0) {
                    if (ichat == null) {
                        ichat = Component.literal((String)part).withStyle(messageColour);
                    } else {
                        ichat.append(part);
                    }
                }
                lastEnd = end;
                url = string.substring(start, end);
                link = Component.literal((String)url);
                try {
                    if (new URI((String)url).getScheme() != null) break block13;
                    if (!allowMissingHeader) {
                        if (ichat == null) {
                            ichat = Component.literal((String)url);
                            continue;
                        }
                        ichat.append((String)url);
                        continue;
                    }
                    url = "http://" + (String)url;
                }
                catch (URISyntaxException e) {
                    if (ichat == null) {
                        ichat = Component.literal((String)url);
                        continue;
                    }
                    ichat.append((String)url);
                    continue;
                }
            }
            ClickEvent click = new ClickEvent(ClickEvent.Action.OPEN_URL, (String)url);
            HoverEvent hoverEvent = new HoverEvent(SHOW_URL_PREVIEW, (Object)Component.literal((String)url));
            link.setStyle(link.getStyle().withClickEvent(click).withHoverEvent(hoverEvent).withUnderlined(Boolean.valueOf(true)).withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.BLUE)));
            if (ichat == null) {
                ichat = Component.literal((String)"");
            }
            ichat.append((Component)link);
        }
        String end = string.substring(lastEnd);
        if (ichat == null) {
            ichat = Component.literal((String)end).withStyle(messageColour);
        } else if (end.length() > 0) {
            ichat.append((Component)Component.literal((String)string.substring(lastEnd)).withStyle(messageColour));
        }
        return ichat;
    }
}

