/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileResult;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.Nullable;

public class ProfileUpdater {
    private static LoadingCache<UUID, CompletableFuture<@Nullable GameProfile>> profileCache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<UUID, CompletableFuture<GameProfile>>(){

        public CompletableFuture<GameProfile> load(UUID key) {
            return ProfileUpdater.loadProfile(key);
        }
    });

    public static void updateProfile(UUID uuid, Consumer<GameProfile> callback) {
        ((CompletableFuture)profileCache.getUnchecked((Object)uuid)).thenAcceptAsync(e -> {
            if (e != null) {
                callback.accept((GameProfile)e);
            }
        }, (Executor)Minecraft.getInstance());
    }

    private static CompletableFuture<@Nullable GameProfile> loadProfile(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            ProfileResult result = Minecraft.getInstance().getMinecraftSessionService().fetchProfile(uuid, true);
            if (result == null) {
                return null;
            }
            return result.profile();
        }, Util.backgroundExecutor());
    }
}

