/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.measurements.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.measurements.client.ClientClass;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.TickEvent;
import org.joml.Matrix4f;

public class ClientHandler {
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.CLIENT) {
            ClientClass.onPlayerTick(event.player);
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            Matrix4f projectionMatrix = event.getProjectionMatrix();
            PoseStack poseStack = event.getPoseStack();
            RenderBuffers renderBuffers = minecraft.renderBuffers();
            Camera camera = minecraft.gameRenderer.getMainCamera();
            ClientClass.onRenderWorldLast((Player)player, projectionMatrix, poseStack, renderBuffers, camera);
        }
    }
}

