/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.measurements.config;

import com.mrbysco.measurements.Constants;
import com.mrbysco.measurements.config.LineColor;
import com.mrbysco.measurements.config.TextColor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class MeasurementConfigNeoForge {
    public static final ModConfigSpec clientSpec;
    public static final Client CLIENT;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Constants.LOGGER.debug("Loaded Measurements' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Constants.LOGGER.debug("Measurements' config just got changed on the file system!");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Client::new);
        clientSpec = (ModConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ModConfigSpec.DoubleValue lineWidth;
        public final ModConfigSpec.IntValue lineWidthMax;
        public final ModConfigSpec.DoubleValue textSize;
        public final ModConfigSpec.EnumValue<LineColor> lineColor;
        public final ModConfigSpec.EnumValue<TextColor> textColor;

        Client(ModConfigSpec.Builder builder) {
            builder.comment("Client settings").push("client");
            this.lineColor = builder.comment("Set line color. [Default: YELLOW]").defineEnum("lineColor", (Enum)LineColor.YELLOW);
            this.textColor = builder.comment("Set text color. [Default: YELLOW]").defineEnum("textColor", (Enum)TextColor.YELLOW);
            this.textSize = builder.comment("Set text size [Default: 0.02]").defineInRange("textSize", 0.02, 0.01, 0.1);
            this.lineWidth = builder.comment("Set line width (thickness). [Default: 2]").defineInRange("lineWidth", 2.0, 1.0, 16.0);
            this.lineWidthMax = builder.comment("Set line width when further away (thickness). [Default: 2]").defineInRange("lineWidthMax", 2, 1, 16);
            builder.pop();
        }
    }
}

