/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.immeng;

import appeng.api.ids.AECreativeTabIds;
import appeng.api.networking.IInWorldGridNodeHost;
import blusunrize.immersiveengineering.api.wires.WireApi;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.BlockItemIE;
import blusunrize.immersiveengineering.common.items.WireCoilItem;
import dev.technici4n.immeng.MEConnectorBlock;
import dev.technici4n.immeng.MEConnectorBlockEntity;
import dev.technici4n.immeng.MELocalHandler;
import dev.technici4n.immeng.MEWireType;
import dev.technici4n.immeng.data.ImmEngBlockLoot;
import dev.technici4n.immeng.data.ImmEngBlockTags;
import dev.technici4n.immeng.data.ImmEngRecipes;
import dev.technici4n.immeng.data.ImmEngStatesProvider;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

@Mod(value="immeng")
public class ImmEng {
    public static final String ID = "immeng";
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"immeng");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"immeng");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"immeng");
    public static final DeferredBlock<MEConnectorBlock<MEConnectorBlockEntity>> ME_CONNECTOR = BLOCKS.register("connector_me", () -> new MEConnectorBlock(() -> (BlockEntityType)ME_CONNECTOR_BE.get()));
    public static final DeferredBlock<MEConnectorBlock<MEConnectorBlockEntity>> ME_RELAY = BLOCKS.register("connector_me_relay", () -> new MEConnectorBlock(() -> (BlockEntityType)ME_RELAY_BE.get()));
    public static final DeferredItem<BlockItem> ME_CONNECTOR_ITEM = ITEMS.register("connector_me", () -> new BlockItemIE((Block)ME_CONNECTOR.get()));
    public static final DeferredItem<BlockItem> ME_RELAY_ITEM = ITEMS.register("connector_me_relay", () -> new BlockItemIE((Block)ME_RELAY.get()));
    public static final DeferredItem<WireCoilItem> ME_WIRE_COIL = ITEMS.register("wirecoil_me", () -> new WireCoilItem((WireType)MEWireType.NORMAL));
    public static final DeferredItem<WireCoilItem> ME_WIRE_DENSE_COIL = ITEMS.register("wirecoil_me_dense", () -> new WireCoilItem((WireType)MEWireType.DENSE));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<MEConnectorBlockEntity>> ME_CONNECTOR_BE = BLOCK_ENTITY_TYPES.register("connector_me", () -> BlockEntityType.Builder.of(MEConnectorBlockEntity::new, (Block[])new Block[]{(Block)ME_CONNECTOR.get()}).build(null));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<MEConnectorBlockEntity>> ME_RELAY_BE = BLOCK_ENTITY_TYPES.register("connector_me_relay", () -> BlockEntityType.Builder.of(MEConnectorBlockEntity::new, (Block[])new Block[]{(Block)ME_RELAY.get()}).build(null));
    public static final BlockCapability<IInWorldGridNodeHost, @Nullable Direction> IN_WORLD_GRID_NODE_HOST = BlockCapability.createSided((ResourceLocation)new ResourceLocation("ae2", "inworld_gridnode_host"), IInWorldGridNodeHost.class);

    public static ResourceLocation id(String path) {
        return new ResourceLocation(ID, path);
    }

    public ImmEng(IEventBus modEventBus) {
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITY_TYPES.register(modEventBus);
        WireApi.registerWireType((WireType)MEWireType.NORMAL);
        WireApi.registerWireType((WireType)MEWireType.DENSE);
        MELocalHandler.register((ResourceLocation)MELocalHandler.ID, MELocalHandler::new);
        modEventBus.addListener(ImmEng::initDatagen);
        modEventBus.addListener(event -> event.registerBlockEntity(IN_WORLD_GRID_NODE_HOST, (BlockEntityType)ME_CONNECTOR_BE.get(), (be, side) -> be));
        modEventBus.addListener(event -> {
            if (event.getTabKey() == AECreativeTabIds.MAIN) {
                event.accept(ME_WIRE_COIL);
                event.accept(ME_WIRE_DENSE_COIL);
                event.accept(ME_CONNECTOR_ITEM);
                event.accept(ME_RELAY_ITEM);
            }
        });
    }

    private static void initDatagen(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        gen.addProvider(event.includeClient(), (DataProvider)new ImmEngStatesProvider(gen.getPackOutput(), event.getExistingFileHelper()));
        gen.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(gen.getPackOutput(), Set.of(), List.of(new LootTableProvider.SubProviderEntry(ImmEngBlockLoot::new, LootContextParamSets.BLOCK))));
        gen.addProvider(event.includeServer(), (DataProvider)new ImmEngRecipes(gen.getPackOutput()));
        gen.addProvider(event.includeServer(), (DataProvider)new ImmEngBlockTags(gen.getPackOutput(), event.getLookupProvider(), event.getExistingFileHelper()));
    }
}

