/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.lmd.mixin;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Mob.class})
public abstract class MobMixin
extends LivingEntity {
    @Unique
    private boolean letmedespawn$pickedItems = false;
    @Shadow
    private boolean persistenceRequired;

    protected MobMixin(EntityType<? extends LivingEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
    }

    @Inject(at={@At(value="TAIL")}, method={"setItemSlotAndDropWhenKilled(Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/item/ItemStack;)V"})
    private void setItemSlotAndDropWhenKilled(EquipmentSlot p_21469_, ItemStack p_21470_, CallbackInfo info) {
        EquipmentSlot equipmentSlot = MobMixin.getEquipmentSlotForItem((ItemStack)p_21470_);
        ItemStack itemStack = this.getItemBySlot(equipmentSlot);
        itemStack.getOrCreateTag().putBoolean("Picked", true);
        this.letmedespawn$pickedItems = true;
        this.persistenceRequired = this.hasCustomName();
    }

    @Redirect(method={"checkDespawn"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Mob;discard()V"))
    private void yeetusCheckus(Mob instance) {
        if (this.letmedespawn$pickedItems) {
            this.letmedespawn$dropEquipmentOnDespawn();
        }
        this.discard();
    }

    @Unique
    protected void letmedespawn$dropEquipmentOnDespawn() {
        EquipmentSlot[] var4;
        for (EquipmentSlot equipmentSlot : var4 = EquipmentSlot.values()) {
            ItemStack itemStack = this.getItemBySlot(equipmentSlot);
            if (itemStack.getTag() == null || itemStack.isEmpty() || EnchantmentHelper.hasVanishingCurse((ItemStack)itemStack) || !itemStack.getTag().getBoolean("Picked")) continue;
            itemStack.removeTagKey("Picked");
            this.spawnAtLocation(itemStack);
            this.setItemSlot(equipmentSlot, ItemStack.EMPTY);
        }
    }

    @Unique
    protected void letmedespawn$removeTagOnDeath() {
        EquipmentSlot[] var4;
        for (EquipmentSlot equipmentSlot : var4 = EquipmentSlot.values()) {
            ItemStack itemStack = this.getItemBySlot(equipmentSlot);
            if (itemStack.getTag() == null || itemStack.isEmpty() || EnchantmentHelper.hasVanishingCurse((ItemStack)itemStack) || !itemStack.getTag().getBoolean("Picked")) continue;
            itemStack.removeTagKey("Picked");
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"dropFromLootTable"})
    protected void dropFromLootTable(DamageSource p_21389_, boolean p_21390_, CallbackInfo ci) {
        if (this.letmedespawn$pickedItems) {
            this.letmedespawn$removeTagOnDeath();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"dropCustomDeathLoot"})
    protected void dropCustomDeathLoot(DamageSource p_21385_, int p_21386_, boolean p_21387_, CallbackInfo ci) {
        if (this.letmedespawn$pickedItems) {
            this.letmedespawn$removeTagOnDeath();
        }
    }
}

