/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities;

import java.util.Objects;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.commoncapabilities.GeneralConfig;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesItemStackTag;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.modcompat.vanilla.VanillaModCompat;
import org.cyclops.commoncapabilities.proxy.ClientProxy;
import org.cyclops.commoncapabilities.proxy.CommonProxy;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.init.ModBaseVersionable;
import org.cyclops.cyclopscore.modcompat.IModCompat;
import org.cyclops.cyclopscore.modcompat.ModCompatLoader;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;

@Mod(value="commoncapabilities")
public class CommonCapabilities
extends ModBaseVersionable<CommonCapabilities> {
    public static CommonCapabilities _instance;

    public CommonCapabilities(IEventBus modEventBus) {
        super("commoncapabilities", instance -> {
            _instance = instance;
        }, modEventBus);
        modEventBus.register(IngredientComponent.class);
        modEventBus.addListener(EventPriority.LOW, this::onRegister);
        modEventBus.addListener(EventPriority.LOW, this::onRegistriesLoad);
        modEventBus.addListener(EventPriority.LOW, this::afterCapabilitiesLoaded);
    }

    protected void setup(FMLCommonSetupEvent event) {
        super.setup(event);
        Objects.requireNonNull(IngredientComponent.ITEMSTACK, "Item ingredient component is not initialized");
        Objects.requireNonNull(IngredientComponent.FLUIDSTACK, "Fluid ingredient component is not initialized");
        Objects.requireNonNull(IngredientComponent.ENERGY, "Energy ingredient component is not initialized");
        IngredientComponent.REGISTRY.forEach(ingredientComponent -> this.getModEventBus().addListener(ingredientComponent::gatherCapabilities));
    }

    protected void loadModCompats(ModCompatLoader modCompatLoader) {
        super.loadModCompats(modCompatLoader);
        modCompatLoader.addModCompat((IModCompat)new VanillaModCompat());
    }

    protected IClientProxy constructClientProxy() {
        return new ClientProxy();
    }

    protected ICommonProxy constructCommonProxy() {
        return new CommonProxy();
    }

    protected boolean hasDefaultCreativeModeTab() {
        return false;
    }

    protected void onConfigsRegister(ConfigHandler configHandler) {
        super.onConfigsRegister(configHandler);
        configHandler.addConfigurable((ExtendedConfig)new GeneralConfig());
    }

    public void onRegister(NewRegistryEvent event) {
        IPrototypedIngredientAlternatives.SERIALIZERS.put(PrototypedIngredientAlternativesList.SERIALIZER.getId(), (Object)PrototypedIngredientAlternativesList.SERIALIZER);
        IPrototypedIngredientAlternatives.SERIALIZERS.put(PrototypedIngredientAlternativesItemStackTag.SERIALIZER.getId(), (Object)PrototypedIngredientAlternativesItemStackTag.SERIALIZER);
    }

    public void onRegistriesLoad(RegisterEvent event) {
        event.register(IngredientComponent.REGISTRY.key(), IngredientComponents.ITEMSTACK.getName(), () -> IngredientComponents.ITEMSTACK);
        event.register(IngredientComponent.REGISTRY.key(), IngredientComponents.FLUIDSTACK.getName(), () -> IngredientComponents.FLUIDSTACK);
        event.register(IngredientComponent.REGISTRY.key(), IngredientComponents.ENERGY.getName(), () -> IngredientComponents.ENERGY);
    }

    public void afterCapabilitiesLoaded(InterModEnqueueEvent event) {
        IngredientComponents.registerStorageWrapperHandlers();
    }

    public static void clog(String message) {
        CommonCapabilities.clog(Level.INFO, message);
    }

    public static void clog(Level level, String message) {
        _instance.getLoggerHelper().log(level, message);
    }
}

