/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.recipehandler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;

public interface IRecipeDefinition
extends Comparable<IRecipeDefinition> {
    public Set<IngredientComponent<?, ?>> getInputComponents();

    public <T, M> List<IPrototypedIngredientAlternatives<T, M>> getInputs(IngredientComponent<T, M> var1);

    public <T, M> boolean isInputReusable(IngredientComponent<T, M> var1, int var2);

    public IMixedIngredients getOutput();

    public static CompoundTag serialize(IRecipeDefinition recipe) {
        CompoundTag tag = new CompoundTag();
        CompoundTag inputTag = new CompoundTag();
        CompoundTag inputReusableTag = new CompoundTag();
        for (IngredientComponent<?, ?> component : recipe.getInputComponents()) {
            ListTag instances = new ListTag();
            ArrayList reusableBytes = Lists.newArrayList();
            int index = 0;
            for (IPrototypedIngredientAlternatives<?, ?> ingredient : recipe.getInputs(component)) {
                CompoundTag subTag = new CompoundTag();
                IPrototypedIngredientAlternatives.ISerializer<?> serializer = ingredient.getSerializer();
                subTag.put("val", serializer.serialize(component, ingredient));
                subTag.putByte("type", serializer.getId());
                instances.add((Object)subTag);
                reusableBytes.add((byte)(recipe.isInputReusable(component, index) ? 1 : 0));
                ++index;
            }
            String componentName = IngredientComponent.REGISTRY.getKey(component).toString();
            inputTag.put(componentName, (Tag)instances);
            inputReusableTag.put(componentName, (Tag)new ByteArrayTag((List)reusableBytes));
        }
        tag.put("input", (Tag)inputTag);
        tag.put("inputReusable", (Tag)inputReusableTag);
        tag.put("output", (Tag)IMixedIngredients.serialize(recipe.getOutput()));
        return tag;
    }

    public static RecipeDefinition deserialize(CompoundTag tag) throws IllegalArgumentException {
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        IdentityHashMap inputsReusable = Maps.newIdentityHashMap();
        if (!tag.contains("input")) {
            throw new IllegalArgumentException("A recipe tag did not contain a valid input tag");
        }
        if (!tag.contains("output")) {
            throw new IllegalArgumentException("A recipe tag did not contain a valid output tag");
        }
        CompoundTag inputTag = tag.getCompound("input");
        for (String componentName : inputTag.getAllKeys()) {
            IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.get(new ResourceLocation(componentName));
            if (component == null) {
                throw new IllegalArgumentException("Could not find the ingredient component type " + componentName);
            }
            Tag subTag = inputTag.get(componentName);
            if (!(subTag instanceof ListTag)) {
                throw new IllegalArgumentException("The ingredient component type " + componentName + " did not contain a valid list of instances");
            }
            ListTag instancesTag = (ListTag)subTag;
            ArrayList instances = Lists.newArrayList();
            for (Tag instanceTag : instancesTag) {
                IPrototypedIngredientAlternatives.ISerializer alternativeSerializer;
                if (instanceTag instanceof CompoundTag) {
                    CompoundTag instanceTagCompound = (CompoundTag)instanceTag;
                    byte type = instanceTagCompound.getByte("type");
                    alternativeSerializer = (IPrototypedIngredientAlternatives.ISerializer)IPrototypedIngredientAlternatives.SERIALIZERS.get(type);
                    if (alternativeSerializer == null) {
                        throw new IllegalArgumentException("Could not find a prototyped ingredient alternative serializer for id " + type);
                    }
                } else {
                    throw new IllegalArgumentException("The ingredient component type " + componentName + " did not contain a valid reference to instances");
                }
                Tag deserializeTag = ((CompoundTag)instanceTag).get("val");
                Object alternatives = alternativeSerializer.deserialize(component, deserializeTag);
                instances.add(alternatives);
            }
            inputs.put(component, instances);
        }
        if (tag.contains("inputReusable")) {
            CompoundTag inputReusableTag = tag.getCompound("inputReusable");
            for (String componentName : inputReusableTag.getAllKeys()) {
                IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.get(new ResourceLocation(componentName));
                if (component == null) {
                    throw new IllegalArgumentException("Could not find the ingredient component type " + componentName);
                }
                Tag subTag = inputReusableTag.get(componentName);
                if (!(subTag instanceof ByteArrayTag)) {
                    throw new IllegalArgumentException("The ingredient component type " + componentName + " did not contain a valid list of instance reusable bytes");
                }
                ByteArrayTag instancesReusable = (ByteArrayTag)subTag;
                ArrayList inputReusable = Lists.newArrayList();
                for (byte b : instancesReusable.getAsByteArray()) {
                    inputReusable.add(b == 1);
                }
                inputsReusable.put(component, inputReusable);
            }
        }
        MixedIngredients output = IMixedIngredients.deserialize(tag.getCompound("output"));
        return new RecipeDefinition(inputs, inputsReusable, output);
    }
}

