/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.ingredient;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;

public interface IPrototypedIngredient<T, M>
extends Comparable<IPrototypedIngredient<?, ?>> {
    public IngredientComponent<T, M> getComponent();

    public T getPrototype();

    public M getCondition();

    public static <T, M> CompoundTag serialize(IPrototypedIngredient<T, M> prototypedIngredient) {
        CompoundTag tag = new CompoundTag();
        IngredientComponent<T, M> component = prototypedIngredient.getComponent();
        tag.putString("ingredientComponent", component.getName().toString());
        IIngredientSerializer<T, M> serializer = component.getSerializer();
        tag.put("prototype", serializer.serializeInstance(prototypedIngredient.getPrototype()));
        tag.put("condition", serializer.serializeCondition(prototypedIngredient.getCondition()));
        return tag;
    }

    public static PrototypedIngredient deserialize(CompoundTag tag) throws IllegalArgumentException {
        if (!tag.contains("ingredientComponent", 8)) {
            throw new IllegalArgumentException("Could not find a ingredientComponent entry in the given tag");
        }
        if (!tag.contains("prototype")) {
            throw new IllegalArgumentException("Could not find a prototype entry in the given tag");
        }
        if (!tag.contains("condition")) {
            throw new IllegalArgumentException("Could not find a condition entry in the given tag");
        }
        String componentName = tag.getString("ingredientComponent");
        IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.get(new ResourceLocation(componentName));
        if (component == null) {
            throw new IllegalArgumentException("Could not find the ingredient component type " + componentName);
        }
        IIngredientSerializer serializer = component.getSerializer();
        Object prototype = serializer.deserializeInstance(tag.get("prototype"));
        Object condition = serializer.deserializeCondition(tag.get("condition"));
        return new PrototypedIngredient(component, prototype, condition);
    }
}

