/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.ingredient;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.modlauncher.TransformingClassLoader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponentCategoryType;
import org.cyclops.commoncapabilities.api.ingredient.IngredientInstanceWrapper;
import org.cyclops.commoncapabilities.api.ingredient.capability.AttachCapabilitiesEventIngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.capability.ICapabilityGetter;
import org.cyclops.commoncapabilities.api.ingredient.capability.IngredientComponentCapability;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageHandler;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageWrapperHandler;

public final class IngredientComponent<T, M>
implements Comparable<IngredientComponent<?, ?>> {
    public static Registry<IngredientComponent<?, ?>> REGISTRY;
    public static IngredientComponent<ItemStack, Integer> ITEMSTACK;
    public static IngredientComponent<FluidStack, Integer> FLUIDSTACK;
    public static IngredientComponent<Long, Boolean> ENERGY;
    private static BlockCapability<IIngredientComponentStorageHandler, Direction> CAPABILITY_BLOCK_INGREDIENT_COMPONENT_STORAGE_HANDLER;
    private static EntityCapability<IIngredientComponentStorageHandler, Direction> CAPABILITY_ENTITY_INGREDIENT_COMPONENT_STORAGE_HANDLER;
    private static ItemCapability<IIngredientComponentStorageHandler, Void> CAPABILITY_ITEM_INGREDIENT_COMPONENT_STORAGE_HANDLER;
    private static Map<Class<?>, BaseCapability<IIngredientComponentStorageHandler, ?>> CAPABILITY_INGREDIENT_COMPONENT_STORAGE_HANDLERS;
    private static Map<BaseCapability<?, ?>, IngredientComponent<?, ?>> STORAGE_WRAPPER_CAPABILITIES_COMPONENTS;
    private final IIngredientMatcher<T, M> matcher;
    private final IIngredientSerializer<T, M> serializer;
    private final List<IngredientComponentCategoryType<T, M, ?>> categoryTypes;
    private final List<BaseCapability<?, ?>> storageWrapperCapabilities;
    private final Map<BaseCapability<?, ?>, IIngredientComponentStorageWrapperHandler<T, M, ?, ?>> storageWrapperHandler;
    private final IngredientComponentCategoryType<T, M, ?> primaryQuantifier;
    private final ResourceLocation name;
    private String translationKey;

    @SubscribeEvent
    public static void onRegistriesCreate(NewRegistryEvent event) {
        REGISTRY = event.create(new RegistryBuilder(ResourceKey.createRegistryKey((ResourceLocation)new ResourceLocation("commoncapabilities", "ingredientcomponents"))));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRegistriesFilled(RegisterEvent event) {
        if (event.getRegistry() == REGISTRY) {
            ITEMSTACK = (IngredientComponent)REGISTRY.get(new ResourceLocation("minecraft:itemstack"));
            FLUIDSTACK = (IngredientComponent)REGISTRY.get(new ResourceLocation("minecraft:fluidstack"));
            ENERGY = (IngredientComponent)REGISTRY.get(new ResourceLocation("minecraft:energy"));
        }
    }

    public IngredientComponent(ResourceLocation name, IIngredientMatcher<T, M> matcher, IIngredientSerializer<T, M> serializer, List<IngredientComponentCategoryType<T, M, ?>> categoryTypes) {
        this.name = name;
        this.matcher = matcher;
        this.serializer = serializer;
        this.categoryTypes = Lists.newArrayList(categoryTypes);
        this.storageWrapperCapabilities = Lists.newArrayList();
        this.storageWrapperHandler = Maps.newIdentityHashMap();
        M matchCondition = this.matcher.getAnyMatchCondition();
        IngredientComponentCategoryType<T, M, ?> primaryQuantifier = null;
        for (IngredientComponentCategoryType<T, M, ?> categoryType : this.categoryTypes) {
            matchCondition = this.matcher.withCondition(matchCondition, categoryType.getMatchCondition());
            if (!categoryType.isPrimaryQuantifier()) continue;
            if (primaryQuantifier != null) {
                throw new IllegalArgumentException("Found more than one primary quantifier in category types.");
            }
            primaryQuantifier = categoryType;
        }
        this.primaryQuantifier = primaryQuantifier;
        if (!Objects.equals(matchCondition, this.getMatcher().getExactMatchCondition())) {
            throw new IllegalArgumentException("The given category types when combined do not conform to the exact match conditions of the matcher.");
        }
    }

    public IngredientComponent(String name, IIngredientMatcher<T, M> matcher, IIngredientSerializer<T, M> serializer, List<IngredientComponentCategoryType<T, M, ?>> categoryTypes) {
        this(new ResourceLocation(name), matcher, serializer, categoryTypes);
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public String toString() {
        return "[IngredientComponent " + this.name + " " + this.hashCode() + "]";
    }

    public void gatherCapabilities(RegisterCapabilitiesEvent registerCapabilitiesEvent) {
        AttachCapabilitiesEventIngredientComponent event = new AttachCapabilitiesEventIngredientComponent(this);
        ModLoader.get().postEventWrapContainerInModOrder(event);
    }

    public <TC> Optional<TC> getCapability(IngredientComponentCapability<TC, Void> capability) {
        return Optional.ofNullable(capability.getCapability(this, null));
    }

    public IngredientComponent<T, M> setTranslationKey(String translationKey) {
        this.translationKey = translationKey;
        return this;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public IIngredientMatcher<T, M> getMatcher() {
        return this.matcher;
    }

    public IIngredientSerializer<T, M> getSerializer() {
        return this.serializer;
    }

    public List<IngredientComponentCategoryType<T, M, ?>> getCategoryTypes() {
        return this.categoryTypes;
    }

    public IngredientInstanceWrapper<T, M> wrap(T instance) {
        return new IngredientInstanceWrapper(this, instance);
    }

    @Nullable
    public IngredientComponentCategoryType<T, M, ?> getPrimaryQuantifier() {
        return this.primaryQuantifier;
    }

    public <S> void setStorageWrapperHandler(BaseCapability<?, ?> capability, IIngredientComponentStorageWrapperHandler<T, M, ? super S, ?> storageWrapperHandler) {
        Objects.requireNonNull(capability, "Registered a storage wrapper handler before capabilities are registered.");
        if (this.storageWrapperHandler.put(capability, storageWrapperHandler) == null) {
            this.storageWrapperCapabilities.add(capability);
            IngredientComponent previousValue = STORAGE_WRAPPER_CAPABILITIES_COMPONENTS.put(capability, this);
            if (previousValue != null) {
                throw new IllegalStateException(String.format("Tried registering a storage capability (%s) for %s that was already registered to %s", capability.name(), this, previousValue));
            }
        }
    }

    @Nullable
    public <S, C> IIngredientComponentStorageWrapperHandler<T, M, S, C> getStorageWrapperHandler(BaseCapability<S, ?> capability) {
        return this.storageWrapperHandler.get(capability);
    }

    public Collection<BaseCapability<?, ?>> getStorageWrapperHandlerCapabilities() {
        return this.storageWrapperCapabilities;
    }

    @Nullable
    public static IngredientComponent<?, ?> getIngredientComponentForStorageCapability(BaseCapability<?, ?> capability) {
        return STORAGE_WRAPPER_CAPABILITIES_COMPONENTS.get(capability);
    }

    @Nullable
    public <O, C> IIngredientComponentStorage<T, M> getStorage(Class<O> capabilityType, ICapabilityGetter<C> capabilityGetter, C context) {
        IIngredientComponentStorage storage;
        BaseCapability<IIngredientComponentStorageHandler, ?> capabilityIngredientComponentStorageHandler = CAPABILITY_INGREDIENT_COMPONENT_STORAGE_HANDLERS.get(capabilityType);
        if (capabilityIngredientComponentStorageHandler == null) {
            throw new IllegalStateException("No capability is know for type " + capabilityType.getName());
        }
        IIngredientComponentStorageHandler storageHandler = capabilityGetter.getCapability(capabilityIngredientComponentStorageHandler, context);
        if (storageHandler != null && (storage = storageHandler.getStorage(this)) != null) {
            return storage;
        }
        for (BaseCapability<?, ?> capability : this.getStorageWrapperHandlerCapabilities()) {
            IIngredientComponentStorageWrapperHandler<T, M, ?, ?> wrapperHandler;
            IIngredientComponentStorage<T, M> storage2;
            if (!capabilityGetter.canHandleCapabilityType(capability) || (storage2 = (wrapperHandler = this.getStorageWrapperHandler(capability)).getComponentStorage(capabilityGetter, context)) == null) continue;
            return storage2;
        }
        return null;
    }

    @Nullable
    public <O, C> IIngredientComponentStorage<T, M> getBlockStorage(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, C context) {
        return this.getStorage(Block.class, ICapabilityGetter.forBlock((ILevelExtension)level, pos, state, blockEntity), context);
    }

    @Nullable
    public <O, C> IIngredientComponentStorage<T, M> getEntityStorage(Entity entity, C context) {
        return this.getStorage(Entity.class, ICapabilityGetter.forEntity(entity), context);
    }

    @Nullable
    public <O, C> IIngredientComponentStorage<T, M> getItemStorage(ItemStack itemStack, C context) {
        return this.getStorage(Item.class, ICapabilityGetter.forItem(itemStack), context);
    }

    @Override
    public int compareTo(IngredientComponent<?, ?> that) {
        return this.getName().compareTo(that.getName());
    }

    static {
        ITEMSTACK = null;
        FLUIDSTACK = null;
        ENERGY = null;
        CAPABILITY_BLOCK_INGREDIENT_COMPONENT_STORAGE_HANDLER = IngredientComponent.class.getClassLoader() instanceof TransformingClassLoader ? BlockCapability.createSided((ResourceLocation)new ResourceLocation("commoncapabilities", "ingredient_component_storage_handler"), IIngredientComponentStorageHandler.class) : null;
        CAPABILITY_ENTITY_INGREDIENT_COMPONENT_STORAGE_HANDLER = IngredientComponent.class.getClassLoader() instanceof TransformingClassLoader ? EntityCapability.createSided((ResourceLocation)new ResourceLocation("commoncapabilities", "ingredient_component_storage_handler"), IIngredientComponentStorageHandler.class) : null;
        CAPABILITY_ITEM_INGREDIENT_COMPONENT_STORAGE_HANDLER = IngredientComponent.class.getClassLoader() instanceof TransformingClassLoader ? ItemCapability.createVoid((ResourceLocation)new ResourceLocation("commoncapabilities", "ingredient_component_storage_handler"), IIngredientComponentStorageHandler.class) : null;
        CAPABILITY_INGREDIENT_COMPONENT_STORAGE_HANDLERS = Maps.newIdentityHashMap();
        CAPABILITY_INGREDIENT_COMPONENT_STORAGE_HANDLERS.put(Block.class, (BaseCapability<IIngredientComponentStorageHandler, ?>)CAPABILITY_BLOCK_INGREDIENT_COMPONENT_STORAGE_HANDLER);
        CAPABILITY_INGREDIENT_COMPONENT_STORAGE_HANDLERS.put(Entity.class, (BaseCapability<IIngredientComponentStorageHandler, ?>)CAPABILITY_ENTITY_INGREDIENT_COMPONENT_STORAGE_HANDLER);
        CAPABILITY_INGREDIENT_COMPONENT_STORAGE_HANDLERS.put(Item.class, (BaseCapability<IIngredientComponentStorageHandler, ?>)CAPABILITY_ITEM_INGREDIENT_COMPONENT_STORAGE_HANDLER);
        STORAGE_WRAPPER_CAPABILITIES_COMPONENTS = Maps.newIdentityHashMap();
    }
}

