/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.capability.itemhandler;

import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public abstract class ItemItemHandler
implements IItemHandlerModifiable {
    private final ItemStack itemStack;

    public ItemItemHandler(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    protected abstract NonNullList<ItemStack> getItemList();

    protected abstract void setItemList(NonNullList<ItemStack> var1);

    public void setStackInSlot(int slot, ItemStack stack) {
        NonNullList<ItemStack> itemStacks = this.getItemList();
        itemStacks.set(slot, (Object)stack);
        this.setItemList(itemStacks);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.getItemList().get(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        NonNullList<ItemStack> itemStacks = this.getItemList();
        ItemStack existingStack = (ItemStack)itemStacks.get(slot);
        if (!existingStack.isEmpty()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existingStack)) {
                return stack;
            }
            int maxStackSize = Math.min(stack.getMaxStackSize(), this.getSlotLimit(slot)) - existingStack.getCount();
            if (stack.getCount() <= maxStackSize) {
                if (!simulate) {
                    ItemStack copy = stack.copy();
                    copy.grow(existingStack.getCount());
                    this.setStackInSlot(slot, copy);
                }
                return ItemStack.EMPTY;
            }
            stack = stack.copy();
            if (!simulate) {
                ItemStack copy = stack.split(maxStackSize);
                copy.grow(existingStack.getCount());
                this.setStackInSlot(slot, copy);
                return stack;
            }
            stack.shrink(maxStackSize);
            return stack;
        }
        int maxStackSize = Math.min(stack.getMaxStackSize(), this.getSlotLimit(slot));
        if (maxStackSize < stack.getCount()) {
            stack = stack.copy();
            if (!simulate) {
                this.setStackInSlot(slot, stack.split(maxStackSize));
                return stack;
            }
            stack.shrink(maxStackSize);
            return stack;
        }
        if (!simulate) {
            this.setStackInSlot(slot, stack);
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack existingStack = this.getStackInSlot(slot);
        if (existingStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack extracted = existingStack.split(amount);
        if (!simulate) {
            this.setStackInSlot(slot, existingStack);
        }
        return extracted;
    }
}

