/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.ingredient;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.api.capability.fluidhandler.FluidMatch;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.ingredient.IngredientHelpers;
import org.cyclops.cyclopscore.helper.Helpers;

public class IngredientMatcherFluidStack
implements IIngredientMatcher<FluidStack, Integer> {
    @Override
    public boolean isInstance(Object object) {
        return object instanceof FluidStack;
    }

    @Override
    public Integer getAnyMatchCondition() {
        return 0;
    }

    @Override
    public Integer getExactMatchCondition() {
        return 7;
    }

    @Override
    public Integer getExactMatchNoQuantityCondition() {
        return 3;
    }

    @Override
    public Integer withCondition(Integer matchCondition, Integer with) {
        return matchCondition | with;
    }

    @Override
    public Integer withoutCondition(Integer matchCondition, Integer without) {
        return matchCondition & ~without.intValue();
    }

    @Override
    public boolean hasCondition(Integer matchCondition, Integer searchCondition) {
        return (matchCondition & searchCondition) > 0;
    }

    @Override
    public boolean matches(FluidStack a, FluidStack b, Integer matchCondition) {
        return FluidMatch.areFluidStacksEqual(a, b, matchCondition);
    }

    @Override
    public FluidStack getEmptyInstance() {
        return FluidStack.EMPTY;
    }

    @Override
    public int hash(FluidStack instance) {
        if (instance.isEmpty()) {
            return 0;
        }
        int code = 1;
        code = 31 * code + instance.getFluid().hashCode();
        code = 31 * code + instance.getAmount();
        if (instance.getTag() != null) {
            code = 31 * code + instance.getTag().hashCode();
        }
        return code;
    }

    @Override
    public FluidStack copy(FluidStack instance) {
        if (instance.isEmpty()) {
            return this.getEmptyInstance();
        }
        return instance.copy();
    }

    @Override
    public long getQuantity(FluidStack instance) {
        return instance.getAmount();
    }

    @Override
    public FluidStack withQuantity(FluidStack instance, long quantity) {
        if (quantity == 0L) {
            return this.getEmptyInstance();
        }
        if (instance.isEmpty()) {
            return new FluidStack((Fluid)Fluids.WATER, Helpers.castSafe((long)quantity));
        }
        if ((long)instance.getAmount() == quantity) {
            return instance;
        }
        FluidStack copy = instance.copy();
        copy.setAmount(Helpers.castSafe((long)quantity));
        return copy;
    }

    @Override
    public long getMaximumQuantity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int conditionCompare(Integer a, Integer b) {
        return Integer.compare(a, b);
    }

    @Override
    public String localize(FluidStack instance) {
        return instance.getDisplayName().getString();
    }

    @Override
    public MutableComponent getDisplayName(FluidStack instance) {
        return (MutableComponent)instance.getDisplayName();
    }

    @Override
    public String toString(FluidStack instance) {
        return String.format("%s %s %s", BuiltInRegistries.FLUID.getKey((Object)instance.getFluid()), instance.getAmount(), instance.getTag());
    }

    @Override
    public int compare(FluidStack o1, FluidStack o2) {
        if (o1.isEmpty()) {
            if (o2.isEmpty()) {
                return 0;
            }
            return -1;
        }
        if (o2.isEmpty()) {
            return 1;
        }
        if (o1.getFluid() == o2.getFluid()) {
            if (o1.getAmount() == o2.getAmount()) {
                return IngredientHelpers.compareTags((Tag)o1.getTag(), (Tag)o2.getTag());
            }
            return o1.getAmount() - o2.getAmount();
        }
        return BuiltInRegistries.FLUID.getKey((Object)o1.getFluid()).compareTo(BuiltInRegistries.FLUID.getKey((Object)o2.getFluid()));
    }
}

