/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler;

import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.ItemStack;
import org.cyclops.commoncapabilities.capability.itemhandler.ItemItemHandler;
import org.jetbrains.annotations.NotNull;

public class VanillaItemBundleItemHandler
extends ItemItemHandler {
    public VanillaItemBundleItemHandler(ItemStack itemStack) {
        super(itemStack);
    }

    @Override
    protected NonNullList<ItemStack> getItemList() {
        NonNullList itemStacks;
        CompoundTag entityTag = this.getItemStack().getTag();
        if (entityTag != null && entityTag.contains("Items", 9)) {
            ListTag listTag = entityTag.getList("Items", 10);
            itemStacks = NonNullList.withSize((int)(listTag.size() + 1), (Object)ItemStack.EMPTY);
            int slot = 0;
            for (Tag itemTag : listTag) {
                itemStacks.set(slot++, (Object)ItemStack.of((CompoundTag)((CompoundTag)itemTag)));
            }
        } else {
            itemStacks = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        }
        return itemStacks;
    }

    @Override
    protected void setItemList(NonNullList<ItemStack> itemStacks) {
        CompoundTag rootTag = this.getItemStack().getOrCreateTag();
        ListTag listTag = new ListTag();
        for (ItemStack itemStack : itemStacks) {
            listTag.add((Object)itemStack.save(new CompoundTag()));
        }
        rootTag.put("Items", (Tag)listTag);
    }

    public int getSlots() {
        return this.getItemList().size();
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return BundleItem.getContentWeight((ItemStack)this.getItemStack()) + BundleItem.getWeight((ItemStack)stack) <= 64;
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        if (this.isItemValid(slot, stack)) {
            super.setStackInSlot(slot, stack);
        }
    }

    @Override
    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }
}

