/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla.capability.recipehandler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.NBTIngredient;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.helper.CraftingHelpers;

public class VanillaRecipeTypeRecipeHandler<C extends Container, T extends Recipe<C>>
implements IRecipeHandler {
    private static final Set<IngredientComponent<?, ?>> COMPONENTS_INPUT = Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK});
    private static final Set<IngredientComponent<?, ?>> COMPONENTS_OUTPUT = Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK});
    public static final AbstractContainerMenu DUMMY_CONTAINTER = new AbstractContainerMenu(MenuType.CRAFTING, 0){

        public ItemStack quickMoveStack(Player p_38941_, int p_38942_) {
            return ItemStack.EMPTY;
        }

        public boolean stillValid(Player playerIn) {
            return true;
        }
    };
    private final Supplier<Level> worldSupplier;
    private final RecipeType<T> recipeType;
    private final Predicate<Integer> inputSizePredicate;
    private static Map<Pair<RecipeType<?>, ResourceLocation>, Collection<IRecipeDefinition>> CACHED_RECIPES = Maps.newHashMap();

    public VanillaRecipeTypeRecipeHandler(Supplier<Level> worldSupplier, RecipeType<T> recipeType, Predicate<Integer> inputSizePredicate) {
        this.worldSupplier = worldSupplier;
        this.recipeType = recipeType;
        this.inputSizePredicate = inputSizePredicate;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeInputComponents() {
        return COMPONENTS_INPUT;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeOutputComponents() {
        return COMPONENTS_OUTPUT;
    }

    public boolean isValidSizeInput(IngredientComponent component, int size) {
        return component == IngredientComponent.ITEMSTACK && this.inputSizePredicate.test(size);
    }

    public static List<IPrototypedIngredient<ItemStack, Integer>> getPrototypesFromIngredient(Ingredient ingredient) {
        if (ingredient instanceof NBTIngredient) {
            return Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, ingredient.getItems()[0], 5)});
        }
        return Arrays.stream(ingredient.getItems()).map(itemStack -> new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, (ItemStack)itemStack, 1)).collect(Collectors.toList());
    }

    @Nullable
    public static <C extends Container, T extends Recipe<C>> IRecipeDefinition recipeToRecipeDefinition(T recipe, Level level) {
        if (recipe.getResultItem(level.registryAccess()).isEmpty()) {
            return null;
        }
        int inputSize = recipe.getIngredients().size();
        ArrayList inputIngredients = Lists.newArrayListWithCapacity((int)inputSize);
        if (inputSize == 0) {
            return null;
        }
        for (int i = 0; i < recipe.getIngredients().size(); ++i) {
            Ingredient ingredient = (Ingredient)recipe.getIngredients().get(i);
            List<IPrototypedIngredient<ItemStack, Integer>> prototypes = VanillaRecipeTypeRecipeHandler.getPrototypesFromIngredient(ingredient);
            if (prototypes.isEmpty()) {
                prototypes.add(new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, ItemStack.EMPTY, 1));
            }
            inputIngredients.add(i, prototypes);
        }
        return RecipeDefinition.ofIngredients(IngredientComponent.ITEMSTACK, inputIngredients, MixedIngredients.ofInstance(IngredientComponent.ITEMSTACK, recipe.getResultItem(level.registryAccess())));
    }

    @Override
    public Collection<IRecipeDefinition> getRecipes() {
        Pair cacheKey = Pair.of(this.recipeType, (Object)this.worldSupplier.get().dimension().location());
        Collection cached = CACHED_RECIPES.get(cacheKey);
        if (cached == null) {
            cached = this.worldSupplier.get().getRecipeManager().getRecipes().stream().filter(holder -> holder.value().getType() == this.recipeType).map(recipe -> VanillaRecipeTypeRecipeHandler.recipeToRecipeDefinition(recipe.value(), this.worldSupplier.get())).filter(Objects::nonNull).collect(Collectors.toList());
            CACHED_RECIPES.put(cacheKey, cached);
        }
        return cached;
    }

    @Override
    @Nullable
    public IMixedIngredients simulate(IMixedIngredients input) {
        List<ItemStack> recipeIngredients = input.getInstances(IngredientComponent.ITEMSTACK);
        if (input.getComponents().size() != 1 || recipeIngredients.size() < 1) {
            return null;
        }
        TransientCraftingContainer inventoryCrafting = new TransientCraftingContainer(DUMMY_CONTAINTER, 3, 3);
        for (int i = 0; i < recipeIngredients.size(); ++i) {
            inventoryCrafting.setItem(i, recipeIngredients.get(i));
        }
        Recipe recipe = CraftingHelpers.findRecipeCached(this.recipeType, (Container)inventoryCrafting, (Level)this.worldSupplier.get(), (boolean)true).map(RecipeHolder::value).orElse(null);
        if (recipe == null) {
            if (recipeIngredients.size() <= 4) {
                TransientCraftingContainer inventoryCraftingSmall = new TransientCraftingContainer(DUMMY_CONTAINTER, 2, 2);
                for (int i = 0; i < recipeIngredients.size(); ++i) {
                    inventoryCraftingSmall.setItem(i, recipeIngredients.get(i));
                }
                recipe = CraftingHelpers.findRecipeCached(this.recipeType, (Container)inventoryCraftingSmall, (Level)this.worldSupplier.get(), (boolean)true).map(RecipeHolder::value).orElse(null);
            }
            if (recipe == null) {
                return null;
            }
        }
        return MixedIngredients.ofInstance(IngredientComponent.ITEMSTACK, recipe.getResultItem(this.worldSupplier.get().registryAccess()));
    }
}

