/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes;

import dev.shadowsoffire.apothic_attributes.ALConfig;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.apothic_attributes.client.AttributesLibClient;
import dev.shadowsoffire.apothic_attributes.compat.CuriosCompat;
import dev.shadowsoffire.apothic_attributes.impl.AttributeEvents;
import dev.shadowsoffire.apothic_attributes.packet.CritParticleMessage;
import dev.shadowsoffire.apothic_attributes.util.MiscDatagen;
import dev.shadowsoffire.placebo.network.PayloadHelper;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import dev.shadowsoffire.placebo.registry.DeferredHelper;
import java.io.File;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="apothic_attributes")
public class ApothicAttributes {
    public static final String MODID = "apothic_attributes";
    public static final Logger LOGGER = LogManager.getLogger((String)"apothic_attributes");
    public static final DeferredHelper R = DeferredHelper.create((String)"apothic_attributes");
    private static final File configDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "apothic_attributes");
    private static float localAtkStrength = 1.0f;

    public ApothicAttributes(IEventBus bus) {
        bus.register((Object)this);
        NeoForge.EVENT_BUS.register((Object)new AttributeEvents());
        NeoForge.EVENT_BUS.addListener(ApothicAttributes::trackCooldown);
        if (FMLEnvironment.dist.isClient()) {
            NeoForge.EVENT_BUS.register((Object)new AttributesLibClient());
            bus.register(AttributesLibClient.ModBusSub.class);
        }
        PayloadHelper.registerPayload((PayloadProvider)new CritParticleMessage.Provider());
        ALObjects.bootstrap(bus);
        ALConfig.load();
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        e.enqueueWork(() -> {
            MobEffects.BLINDNESS.addAttributeModifier(Attributes.FOLLOW_RANGE, "f8c3de3d-1fea-4d7c-a8b0-22f63c4c3454", -0.75, AttributeModifier.Operation.MULTIPLY_TOTAL);
            BuiltInRegistries.ATTRIBUTE.addAlias(ApothicAttributes.loc("creative_flight"), new ResourceLocation("neoforge", "creative_flight"));
        });
    }

    @SubscribeEvent
    public void applyAttribs(EntityAttributeModificationEvent e) {
        e.getTypes().forEach(type -> ApothicAttributes.addAll((EntityType<? extends LivingEntity>)type, (arg_0, arg_1) -> ((EntityAttributeModificationEvent)e).add(arg_0, arg_1), ALObjects.Attributes.DRAW_SPEED, ALObjects.Attributes.CRIT_CHANCE, ALObjects.Attributes.CRIT_DAMAGE, ALObjects.Attributes.COLD_DAMAGE, ALObjects.Attributes.FIRE_DAMAGE, ALObjects.Attributes.LIFE_STEAL, ALObjects.Attributes.CURRENT_HP_DAMAGE, ALObjects.Attributes.OVERHEAL, ALObjects.Attributes.GHOST_HEALTH, ALObjects.Attributes.MINING_SPEED, ALObjects.Attributes.ARROW_DAMAGE, ALObjects.Attributes.ARROW_VELOCITY, ALObjects.Attributes.EXPERIENCE_GAINED, ALObjects.Attributes.HEALING_RECEIVED, ALObjects.Attributes.ARMOR_PIERCE, ALObjects.Attributes.ARMOR_SHRED, ALObjects.Attributes.PROT_PIERCE, ALObjects.Attributes.PROT_SHRED, ALObjects.Attributes.DODGE_CHANCE, ALObjects.Attributes.ELYTRA_FLIGHT));
        e.add(EntityType.PLAYER, (Attribute)NeoForgeMod.STEP_HEIGHT.value(), 0.6);
    }

    @SafeVarargs
    private static void addAll(EntityType<? extends LivingEntity> type, BiConsumer<EntityType<? extends LivingEntity>, Attribute> add, Supplier<? extends Attribute> ... attribs) {
        for (Supplier<? extends Attribute> a : attribs) {
            add.accept(type, a.get());
        }
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        AttributeSupplier playerAttribs = DefaultAttributes.getSupplier((EntityType)EntityType.PLAYER);
        for (Attribute attr : BuiltInRegistries.ATTRIBUTE) {
            if (!playerAttribs.hasAttribute(attr)) continue;
            attr.setSyncable(true);
        }
        if (ModList.get().isLoaded("curios")) {
            e.enqueueWork(CuriosCompat::init);
        }
    }

    @SubscribeEvent
    public void data(GatherDataEvent e) {
        MiscDatagen gen = new MiscDatagen(e.getGenerator().getPackOutput().getOutputFolder(PackOutput.Target.DATA_PACK).resolve(MODID));
        e.getGenerator().addProvider(true, (DataProvider)gen);
    }

    public static File getConfigFile(String path) {
        return new File(configDir, path + ".cfg");
    }

    public static float getLocalAtkStrength(Entity entity) {
        if (entity instanceof Player) {
            return localAtkStrength;
        }
        return 1.0f;
    }

    public static TooltipFlag getTooltipFlag() {
        if (FMLEnvironment.dist.isClient()) {
            return ClientAccess.getTooltipFlag();
        }
        return TooltipFlag.NORMAL;
    }

    public static ResourceLocation loc(String path) {
        return new ResourceLocation(MODID, path);
    }

    private static void trackCooldown(AttackEntityEvent e) {
        Player p = e.getEntity();
        localAtkStrength = p.getAttackStrengthScale(0.5f);
    }

    private static class ClientAccess {
        private ClientAccess() {
        }

        static TooltipFlag getTooltipFlag() {
            return Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL;
        }
    }
}

