/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.api;

import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.apothic_attributes.impl.BooleanAttribute;
import dev.shadowsoffire.apothic_attributes.impl.PercentBasedAttribute;
import dev.shadowsoffire.apothic_attributes.mob_effect.BleedingEffect;
import dev.shadowsoffire.apothic_attributes.mob_effect.DetonationEffect;
import dev.shadowsoffire.apothic_attributes.mob_effect.FlyingEffect;
import dev.shadowsoffire.apothic_attributes.mob_effect.GrievousEffect;
import dev.shadowsoffire.apothic_attributes.mob_effect.KnowledgeEffect;
import dev.shadowsoffire.apothic_attributes.mob_effect.SunderingEffect;
import dev.shadowsoffire.apothic_attributes.mob_effect.VitalityEffect;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.item.alchemy.Potion;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.jetbrains.annotations.ApiStatus;

public class ALObjects {
    @ApiStatus.Internal
    public static void bootstrap(IEventBus bus) {
        Attributes.bootstrap();
        MobEffects.bootstrap();
        Particles.bootstrap();
        Sounds.bootstrap();
        DamageTypes.bootstrap();
        Potions.bootstrap();
        bus.register((Object)ApothicAttributes.R);
    }

    public static class Attributes {
        public static final Supplier<Attribute> ARMOR_PIERCE = ApothicAttributes.R.attribute("armor_pierce", () -> new RangedAttribute("apothic_attributes:armor_pierce", 0.0, 0.0, 1000.0).setSyncable(true));
        public static final Supplier<Attribute> ARMOR_SHRED = ApothicAttributes.R.attribute("armor_shred", () -> new PercentBasedAttribute("apothic_attributes:armor_shred", 0.0, 0.0, 2.0).setSyncable(true));
        public static final Supplier<Attribute> ARROW_DAMAGE = ApothicAttributes.R.attribute("arrow_damage", () -> new PercentBasedAttribute("apothic_attributes:arrow_damage", 1.0, 0.0, 10.0).setSyncable(true));
        public static final Supplier<Attribute> ARROW_VELOCITY = ApothicAttributes.R.attribute("arrow_velocity", () -> new PercentBasedAttribute("apothic_attributes:arrow_velocity", 1.0, 0.0, 10.0).setSyncable(true));
        public static final Supplier<Attribute> COLD_DAMAGE = ApothicAttributes.R.attribute("cold_damage", () -> new RangedAttribute("apothic_attributes:cold_damage", 0.0, 0.0, 1000.0).setSyncable(true));
        public static final Supplier<Attribute> CRIT_CHANCE = ApothicAttributes.R.attribute("crit_chance", () -> new PercentBasedAttribute("apothic_attributes:crit_chance", 0.05, 0.0, 10.0).setSyncable(true));
        public static final Supplier<Attribute> CRIT_DAMAGE = ApothicAttributes.R.attribute("crit_damage", () -> new PercentBasedAttribute("apothic_attributes:crit_damage", 1.5, 1.0, 100.0).setSyncable(true));
        public static final Supplier<Attribute> CURRENT_HP_DAMAGE = ApothicAttributes.R.attribute("current_hp_damage", () -> new PercentBasedAttribute("apothic_attributes:current_hp_damage", 0.0, 0.0, 1.0).setSyncable(true));
        public static final Supplier<Attribute> DODGE_CHANCE = ApothicAttributes.R.attribute("dodge_chance", () -> new PercentBasedAttribute("apothic_attributes:dodge_chance", 0.0, 0.0, 1.0).setSyncable(true));
        public static final Supplier<Attribute> DRAW_SPEED = ApothicAttributes.R.attribute("draw_speed", () -> new PercentBasedAttribute("apothic_attributes:draw_speed", 1.0, 0.0, 4.0).setSyncable(true));
        public static final Supplier<Attribute> EXPERIENCE_GAINED = ApothicAttributes.R.attribute("experience_gained", () -> new PercentBasedAttribute("apothic_attributes:experience_gained", 1.0, 0.0, 1000.0).setSyncable(true));
        public static final Supplier<Attribute> FIRE_DAMAGE = ApothicAttributes.R.attribute("fire_damage", () -> new RangedAttribute("apothic_attributes:fire_damage", 0.0, 0.0, 1000.0).setSyncable(true));
        public static final Supplier<Attribute> GHOST_HEALTH = ApothicAttributes.R.attribute("ghost_health", () -> new RangedAttribute("apothic_attributes:ghost_health", 0.0, 0.0, 1000.0).setSyncable(true));
        public static final Supplier<Attribute> HEALING_RECEIVED = ApothicAttributes.R.attribute("healing_received", () -> new PercentBasedAttribute("apothic_attributes:healing_received", 1.0, 0.0, 1000.0).setSyncable(true));
        public static final Supplier<Attribute> LIFE_STEAL = ApothicAttributes.R.attribute("life_steal", () -> new PercentBasedAttribute("apothic_attributes:life_steal", 0.0, 0.0, 10.0).setSyncable(true));
        public static final Supplier<Attribute> MINING_SPEED = ApothicAttributes.R.attribute("mining_speed", () -> new PercentBasedAttribute("apothic_attributes:mining_speed", 1.0, 0.0, 10.0).setSyncable(true));
        public static final Supplier<Attribute> OVERHEAL = ApothicAttributes.R.attribute("overheal", () -> new PercentBasedAttribute("apothic_attributes:overheal", 0.0, 0.0, 10.0).setSyncable(true));
        public static final Supplier<Attribute> PROT_PIERCE = ApothicAttributes.R.attribute("prot_pierce", () -> new RangedAttribute("apothic_attributes:prot_pierce", 0.0, 0.0, 34.0).setSyncable(true));
        public static final Supplier<Attribute> PROT_SHRED = ApothicAttributes.R.attribute("prot_shred", () -> new PercentBasedAttribute("apothic_attributes:prot_shred", 0.0, 0.0, 1.0).setSyncable(true));
        public static final Supplier<Attribute> ELYTRA_FLIGHT = ApothicAttributes.R.attribute("elytra_flight", () -> new BooleanAttribute("apothic_attributes:elytra_flight", false).setSyncable(true));
        @Deprecated(forRemoval=true, since="1.20.4")
        public static final Supplier<Attribute> CREATIVE_FLIGHT = () -> ((Holder)NeoForgeMod.CREATIVE_FLIGHT).value();

        @ApiStatus.Internal
        public static void bootstrap() {
        }
    }

    public static class MobEffects
    extends net.minecraft.world.effect.MobEffects {
        public static final Supplier<BleedingEffect> BLEEDING = ApothicAttributes.R.effect("bleeding", BleedingEffect::new);
        public static final Supplier<DetonationEffect> DETONATION = ApothicAttributes.R.effect("detonation", DetonationEffect::new);
        public static final Supplier<GrievousEffect> GRIEVOUS = ApothicAttributes.R.effect("grievous", GrievousEffect::new);
        public static final Supplier<KnowledgeEffect> KNOWLEDGE = ApothicAttributes.R.effect("knowledge", KnowledgeEffect::new);
        public static final Supplier<SunderingEffect> SUNDERING = ApothicAttributes.R.effect("sundering", SunderingEffect::new);
        public static final Supplier<VitalityEffect> VITALITY = ApothicAttributes.R.effect("vitality", VitalityEffect::new);
        public static final Supplier<FlyingEffect> FLYING = ApothicAttributes.R.effect("flying", FlyingEffect::new);

        @ApiStatus.Internal
        public static void bootstrap() {
        }
    }

    public static class Particles {
        public static final Supplier<SimpleParticleType> APOTH_CRIT = ApothicAttributes.R.particle("apoth_crit", () -> new SimpleParticleType(false));

        @ApiStatus.Internal
        public static void bootstrap() {
        }
    }

    public static class Sounds {
        public static final Holder<SoundEvent> DODGE = ApothicAttributes.R.sound("dodge");

        @ApiStatus.Internal
        public static void bootstrap() {
        }
    }

    public static class DamageTypes {
        public static final ResourceKey<DamageType> BLEEDING = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ApothicAttributes.loc("bleeding"));
        public static final ResourceKey<DamageType> DETONATION = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ApothicAttributes.loc("detonation"));
        public static final ResourceKey<DamageType> CURRENT_HP_DAMAGE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ApothicAttributes.loc("current_hp_damage"));
        public static final ResourceKey<DamageType> FIRE_DAMAGE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ApothicAttributes.loc("fire_damage"));
        public static final ResourceKey<DamageType> COLD_DAMAGE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ApothicAttributes.loc("cold_damage"));

        @ApiStatus.Internal
        public static void bootstrap() {
        }
    }

    public static final class Potions {
        public static final Supplier<Potion> RESISTANCE = ApothicAttributes.R.singlePotion("resistance", () -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 3600));
        public static final Supplier<Potion> LONG_RESISTANCE = ApothicAttributes.R.singlePotion("long_resistance", () -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 9600));
        public static final Supplier<Potion> STRONG_RESISTANCE = ApothicAttributes.R.singlePotion("strong_resistance", () -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1800, 1));
        public static final Supplier<Potion> ABSORPTION = ApothicAttributes.R.singlePotion("absorption", () -> new MobEffectInstance(MobEffects.ABSORPTION, 1200, 1));
        public static final Supplier<Potion> LONG_ABSORPTION = ApothicAttributes.R.singlePotion("long_absorption", () -> new MobEffectInstance(MobEffects.ABSORPTION, 3600, 1));
        public static final Supplier<Potion> STRONG_ABSORPTION = ApothicAttributes.R.singlePotion("strong_absorption", () -> new MobEffectInstance(MobEffects.ABSORPTION, 600, 3));
        public static final Supplier<Potion> HASTE = ApothicAttributes.R.singlePotion("haste", () -> new MobEffectInstance(MobEffects.DIG_SPEED, 3600));
        public static final Supplier<Potion> LONG_HASTE = ApothicAttributes.R.singlePotion("long_haste", () -> new MobEffectInstance(MobEffects.DIG_SPEED, 9600));
        public static final Supplier<Potion> STRONG_HASTE = ApothicAttributes.R.singlePotion("strong_haste", () -> new MobEffectInstance(MobEffects.DIG_SPEED, 1800, 1));
        public static final Supplier<Potion> FATIGUE = ApothicAttributes.R.singlePotion("fatigue", () -> new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 3600));
        public static final Supplier<Potion> LONG_FATIGUE = ApothicAttributes.R.singlePotion("long_fatigue", () -> new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 9600));
        public static final Supplier<Potion> STRONG_FATIGUE = ApothicAttributes.R.singlePotion("strong_fatigue", () -> new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 1800, 1));
        public static final Supplier<Potion> WITHER = ApothicAttributes.R.singlePotion("wither", () -> new MobEffectInstance(MobEffects.WITHER, 3600));
        public static final Supplier<Potion> LONG_WITHER = ApothicAttributes.R.singlePotion("long_wither", () -> new MobEffectInstance(MobEffects.WITHER, 9600));
        public static final Supplier<Potion> STRONG_WITHER = ApothicAttributes.R.singlePotion("strong_wither", () -> new MobEffectInstance(MobEffects.WITHER, 1800, 1));
        public static final Supplier<Potion> SUNDERING = ApothicAttributes.R.singlePotion("sundering", () -> new MobEffectInstance((MobEffect)MobEffects.SUNDERING.get(), 3600));
        public static final Supplier<Potion> LONG_SUNDERING = ApothicAttributes.R.singlePotion("long_sundering", () -> new MobEffectInstance((MobEffect)MobEffects.SUNDERING.get(), 9600));
        public static final Supplier<Potion> STRONG_SUNDERING = ApothicAttributes.R.singlePotion("strong_sundering", () -> new MobEffectInstance((MobEffect)MobEffects.SUNDERING.get(), 1800, 1));
        public static final Supplier<Potion> KNOWLEDGE = ApothicAttributes.R.singlePotion("knowledge", () -> new MobEffectInstance((MobEffect)MobEffects.KNOWLEDGE.get(), 2400));
        public static final Supplier<Potion> LONG_KNOWLEDGE = ApothicAttributes.R.singlePotion("long_knowledge", () -> new MobEffectInstance((MobEffect)MobEffects.KNOWLEDGE.get(), 4800));
        public static final Supplier<Potion> STRONG_KNOWLEDGE = ApothicAttributes.R.singlePotion("strong_knowledge", () -> new MobEffectInstance((MobEffect)MobEffects.KNOWLEDGE.get(), 1200, 3));
        public static final Supplier<Potion> VITALITY = ApothicAttributes.R.singlePotion("vitality", () -> new MobEffectInstance((MobEffect)MobEffects.VITALITY.get(), 4800));
        public static final Supplier<Potion> LONG_VITALITY = ApothicAttributes.R.singlePotion("long_vitality", () -> new MobEffectInstance((MobEffect)MobEffects.VITALITY.get(), 14400));
        public static final Supplier<Potion> STRONG_VITALITY = ApothicAttributes.R.singlePotion("strong_vitality", () -> new MobEffectInstance((MobEffect)MobEffects.VITALITY.get(), 3600, 1));
        public static final Supplier<Potion> GRIEVOUS = ApothicAttributes.R.singlePotion("grievous", () -> new MobEffectInstance((MobEffect)MobEffects.GRIEVOUS.get(), 4800));
        public static final Supplier<Potion> LONG_GRIEVOUS = ApothicAttributes.R.singlePotion("long_grievous", () -> new MobEffectInstance((MobEffect)MobEffects.GRIEVOUS.get(), 14400));
        public static final Supplier<Potion> STRONG_GRIEVOUS = ApothicAttributes.R.singlePotion("strong_grievous", () -> new MobEffectInstance((MobEffect)MobEffects.GRIEVOUS.get(), 3600, 1));
        public static final Supplier<Potion> LEVITATION = ApothicAttributes.R.singlePotion("levitation", () -> new MobEffectInstance(MobEffects.LEVITATION, 2400));
        public static final Supplier<Potion> FLYING = ApothicAttributes.R.singlePotion("flying", () -> new MobEffectInstance((MobEffect)MobEffects.FLYING.get(), 9600));
        public static final Supplier<Potion> LONG_FLYING = ApothicAttributes.R.singlePotion("long_flying", () -> new MobEffectInstance((MobEffect)MobEffects.FLYING.get(), 18000));
        public static final Supplier<Potion> EXTRA_LONG_FLYING = ApothicAttributes.R.singlePotion("extra_long_flying", () -> new MobEffectInstance((MobEffect)MobEffects.FLYING.get(), 36000));

        @ApiStatus.Internal
        public static void bootstrap() {
        }
    }
}

