/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.api;

import dev.shadowsoffire.apothic_attributes.api.AttributeHelper;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.jetbrains.annotations.Nullable;

public interface IFormattableAttribute {
    default public MutableComponent toValueComponent(@Nullable AttributeModifier.Operation op, double value, TooltipFlag flag) {
        if (this == Attributes.KNOCKBACK_RESISTANCE || this == NeoForgeMod.SWIM_SPEED.value()) {
            return Component.translatable((String)"apothic_attributes.value.percent", (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(value * 100.0)});
        }
        if (this == Attributes.MOVEMENT_SPEED && IFormattableAttribute.isNullOrAddition(op)) {
            return Component.translatable((String)"apothic_attributes.value.percent", (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(value * 1000.0)});
        }
        String key = IFormattableAttribute.isNullOrAddition(op) ? "apothic_attributes.value.flat" : "apothic_attributes.value.percent";
        return Component.translatable((String)key, (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(IFormattableAttribute.isNullOrAddition(op) ? value : value * 100.0)});
    }

    default public MutableComponent toComponent(AttributeModifier modif, TooltipFlag flag) {
        Attribute attr = this.ths();
        double value = modif.getAmount();
        MutableComponent comp = value > 0.0 ? Component.translatable((String)"apothic_attributes.modifier.plus", (Object[])new Object[]{this.toValueComponent(modif.getOperation(), value, flag), Component.translatable((String)attr.getDescriptionId())}).withStyle(ChatFormatting.BLUE) : Component.translatable((String)"apothic_attributes.modifier.take", (Object[])new Object[]{this.toValueComponent(modif.getOperation(), value *= -1.0, flag), Component.translatable((String)attr.getDescriptionId())}).withStyle(ChatFormatting.RED);
        return comp.append(this.getDebugInfo(modif, flag));
    }

    default public Component getDebugInfo(AttributeModifier modif, TooltipFlag flag) {
        Component debugInfo = CommonComponents.EMPTY;
        if (flag.isAdvanced()) {
            double advValue = (double)(modif.getOperation() == AttributeModifier.Operation.MULTIPLY_TOTAL ? 1 : 0) + modif.getAmount();
            String valueStr = ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(advValue);
            String txt = switch (modif.getOperation()) {
                default -> throw new IncompatibleClassChangeError();
                case AttributeModifier.Operation.ADDITION -> {
                    if (advValue > 0.0) {
                        yield String.format("[+%s]", valueStr);
                    }
                    yield String.format("[%s]", valueStr);
                }
                case AttributeModifier.Operation.MULTIPLY_BASE -> {
                    if (advValue > 0.0) {
                        yield String.format("[+%sx]", valueStr);
                    }
                    yield String.format("[%sx]", valueStr);
                }
                case AttributeModifier.Operation.MULTIPLY_TOTAL -> String.format("[x%s]", valueStr);
            };
            debugInfo = Component.literal((String)" ").append((Component)Component.literal((String)txt).withStyle(ChatFormatting.GRAY));
        }
        return debugInfo;
    }

    @Nullable
    default public UUID getBaseUUID() {
        if (this == Attributes.ATTACK_DAMAGE) {
            return AttributeHelper.BASE_ATTACK_DAMAGE;
        }
        if (this == Attributes.ATTACK_SPEED) {
            return AttributeHelper.BASE_ATTACK_SPEED;
        }
        if (this == NeoForgeMod.ENTITY_REACH.value()) {
            return AttributeHelper.BASE_ENTITY_REACH;
        }
        return null;
    }

    default public MutableComponent toBaseComponent(double value, double entityBase, boolean merged, TooltipFlag flag) {
        Attribute attr = this.ths();
        Component debugInfo = CommonComponents.EMPTY;
        if (flag.isAdvanced() && !merged) {
            debugInfo = Component.literal((String)" ").append((Component)Component.translatable((String)"apothic_attributes.adv.base", (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(entityBase), ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(value - entityBase)}).withStyle(ChatFormatting.GRAY));
        }
        MutableComponent comp = Component.translatable((String)"attribute.modifier.equals.0", (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(value), Component.translatable((String)attr.getDescriptionId())});
        return comp.append(debugInfo);
    }

    default public double getBonusBaseValue(ItemStack stack) {
        if (this == Attributes.ATTACK_DAMAGE) {
            return EnchantmentHelper.getDamageBonus((ItemStack)stack, (MobType)MobType.UNDEFINED);
        }
        return 0.0;
    }

    default public void addBonusTooltips(ItemStack stack, Consumer<Component> tooltip, TooltipFlag flag) {
        if (this == Attributes.ATTACK_DAMAGE) {
            float sharpness = EnchantmentHelper.getDamageBonus((ItemStack)stack, (MobType)MobType.UNDEFINED);
            Component debugInfo = CommonComponents.EMPTY;
            if (flag.isAdvanced()) {
                debugInfo = Component.literal((String)" ").append((Component)Component.translatable((String)"apothic_attributes.adv.sharpness_bonus", (Object[])new Object[]{Float.valueOf(sharpness)}).withStyle(ChatFormatting.GRAY));
            }
            MutableComponent comp = AttributeHelper.list().append((Component)Component.translatable((String)"attribute.modifier.plus.0", (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(sharpness), Component.translatable((String)this.ths().getDescriptionId())}).withStyle(ChatFormatting.BLUE));
            tooltip.accept((Component)comp.append(debugInfo));
        }
    }

    default public Attribute ths() {
        return (Attribute)this;
    }

    public static MutableComponent toComponent(Attribute attr, AttributeModifier modif, TooltipFlag flag) {
        return ((IFormattableAttribute)attr).toComponent(modif, flag);
    }

    public static MutableComponent toValueComponent(Attribute attr, AttributeModifier.Operation op, double value, TooltipFlag flag) {
        return ((IFormattableAttribute)attr).toValueComponent(op, value, flag);
    }

    public static MutableComponent toBaseComponent(Attribute attr, double value, double entityBase, boolean merged, TooltipFlag flag) {
        return ((IFormattableAttribute)attr).toBaseComponent(value, entityBase, merged, flag);
    }

    public static boolean isNullOrAddition(@Nullable AttributeModifier.Operation op) {
        return op == null || op == AttributeModifier.Operation.ADDITION;
    }
}

