/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apothic_attributes.ALConfig;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.apothic_attributes.api.IFormattableAttribute;
import dev.shadowsoffire.apothic_attributes.client.AttributeModifierComponent;
import dev.shadowsoffire.apothic_attributes.client.ModifierSource;
import dev.shadowsoffire.apothic_attributes.client.ModifierSourceType;
import dev.shadowsoffire.apothic_attributes.impl.BooleanAttribute;
import dev.shadowsoffire.placebo.PlaceboClient;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class AttributesGui
implements Renderable,
GuiEventListener {
    public static final ResourceLocation TEXTURES = ApothicAttributes.loc("textures/gui/attributes_gui.png");
    public static final WidgetSprites SWORD_BUTTON_SPRITES = new WidgetSprites(ApothicAttributes.loc("sword"), ApothicAttributes.loc("sword_highlighted"));
    public static final int ENTRY_HEIGHT = 22;
    public static final int MAX_ENTRIES = 6;
    public static final int WIDTH = 131;
    public static boolean wasOpen = false;
    protected static float scrollOffset = 0.0f;
    protected static boolean hideUnchanged = false;
    protected static boolean swappedFromCurios = false;
    protected final InventoryScreen parent;
    protected final Player player;
    protected final Font font;
    protected final ImageButton toggleBtn;
    protected final ImageButton recipeBookButton;
    protected final HideUnchangedButton hideUnchangedBtn;
    protected int leftPos;
    protected int topPos;
    protected boolean scrolling;
    protected int startIndex;
    protected List<AttributeInstance> data;
    @Nullable
    protected AttributeInstance selected;
    protected boolean open;
    protected long lastRenderTick;
    private static DecimalFormat f = ItemStack.ATTRIBUTE_MODIFIER_FORMAT;

    public AttributesGui(InventoryScreen parent) {
        ImageButton imgBtn;
        GuiEventListener btn2;
        this.font = Minecraft.getInstance().font;
        this.data = new ArrayList<AttributeInstance>();
        this.selected = null;
        this.open = false;
        this.lastRenderTick = -1L;
        this.parent = parent;
        this.player = Minecraft.getInstance().player;
        this.refreshData();
        this.leftPos = parent.getGuiLeft() - 131;
        this.topPos = parent.getGuiTop();
        this.toggleBtn = new ImageButton(parent.getGuiLeft() + 63, parent.getGuiTop() + 10, 10, 10, SWORD_BUTTON_SPRITES, btn -> this.toggleVisibility(), (Component)Component.translatable((String)"apothic_attributes.gui.show_attributes")){

            public void setFocused(boolean pFocused) {
            }
        };
        this.recipeBookButton = this.parent.children().size() > 1 ? ((btn2 = (GuiEventListener)this.parent.children().get(0)) instanceof ImageButton ? (imgBtn = (ImageButton)btn2) : null) : null;
        this.hideUnchangedBtn = new HideUnchangedButton(0, 0);
    }

    public void refreshData() {
        this.data.clear();
        BuiltInRegistries.ATTRIBUTE.stream().map(arg_0 -> ((Player)this.player).getAttribute(arg_0)).filter(Objects::nonNull).filter(ai -> !ALConfig.hiddenAttributes.contains(BuiltInRegistries.ATTRIBUTE.getKey((Object)ai.getAttribute()))).filter(ai -> !hideUnchanged || ai.getBaseValue() != ai.getValue()).forEach(this.data::add);
        this.data.sort(this::compareAttrs);
        this.startIndex = (int)((double)(scrollOffset * (float)this.getOffScreenRows()) + 0.5);
    }

    public void toggleVisibility() {
        boolean bl = this.open = !this.open;
        if (this.open && this.parent.getRecipeBookComponent().isVisible()) {
            this.parent.getRecipeBookComponent().toggleVisibility();
        }
        this.hideUnchangedBtn.visible = this.open;
        int newLeftPos = this.open && this.parent.width >= 379 ? 177 + (this.parent.width - this.parent.imageWidth - 200) / 2 : (this.parent.width - this.parent.imageWidth) / 2;
        this.parent.leftPos = newLeftPos;
        this.leftPos = this.parent.getGuiLeft() - 131;
        this.topPos = this.parent.getGuiTop();
        if (this.recipeBookButton != null) {
            this.recipeBookButton.setPosition(this.parent.getGuiLeft() + 104, this.parent.height / 2 - 22);
        }
        this.hideUnchangedBtn.setPosition(this.leftPos + 7, this.topPos + 151);
    }

    protected int compareAttrs(AttributeInstance a1, AttributeInstance a2) {
        String name = I18n.get((String)a1.getAttribute().getDescriptionId(), (Object[])new Object[0]);
        String name2 = I18n.get((String)a2.getAttribute().getDescriptionId(), (Object[])new Object[0]);
        return name.compareTo(name2);
    }

    public boolean isMouseOver(double pMouseX, double pMouseY) {
        if (!this.open) {
            return false;
        }
        return this.isHovering(0, 0, 131, 166, pMouseX, pMouseY);
    }

    public void render(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        this.toggleBtn.setX(this.parent.getGuiLeft() + 63);
        this.toggleBtn.setY(this.parent.getGuiTop() + 10);
        if (this.parent.getRecipeBookComponent().isVisible()) {
            this.open = false;
        }
        wasOpen = this.open;
        if (!this.open) {
            return;
        }
        if (this.lastRenderTick != PlaceboClient.ticks) {
            this.lastRenderTick = PlaceboClient.ticks;
            this.refreshData();
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURES);
        int left = this.leftPos;
        int top = this.topPos;
        gfx.blit(TEXTURES, left, top, 0, 0, 131, 166);
        int scrollbarPos = (int)(117.0f * scrollOffset);
        gfx.blit(TEXTURES, left + 111, top + 16 + scrollbarPos, 244, this.isScrollBarActive() ? 0 : 15, 12, 15);
        for (int idx = this.startIndex; idx < this.startIndex + 6 && idx < this.data.size(); ++idx) {
            this.renderEntry(gfx, this.data.get(idx), this.leftPos + 8, this.topPos + 16 + 22 * (idx - this.startIndex), mouseX, mouseY);
        }
        this.renderTooltip(gfx, mouseX, mouseY);
        gfx.drawString(this.font, (Component)Component.translatable((String)"apothic_attributes.gui.attributes"), this.leftPos + 8, this.topPos + 5, 0x404040, false);
        gfx.drawString(this.font, (Component)Component.literal((String)"Hide Unchanged"), this.leftPos + 20, this.topPos + 152, 0x404040, false);
    }

    protected void renderTooltip(GuiGraphics gfx, int mouseX, int mouseY) {
        AttributeInstance inst = this.getHoveredSlot(mouseX, mouseY);
        if (inst != null) {
            Attribute attr = inst.getAttribute();
            IFormattableAttribute fAttr = (IFormattableAttribute)attr;
            ArrayList<Object> list = new ArrayList<Object>();
            MutableComponent name = Component.translatable((String)attr.getDescriptionId()).withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD).withUnderlined(Boolean.valueOf(true)));
            if (ApothicAttributes.getTooltipFlag().isAdvanced()) {
                Style style = Style.EMPTY.withColor(ChatFormatting.GRAY).withUnderlined(Boolean.valueOf(false));
                name.append((Component)Component.literal((String)(" [" + BuiltInRegistries.ATTRIBUTE.getKey((Object)attr) + "]")).withStyle(style));
            }
            list.add(name);
            String key = attr.getDescriptionId() + ".desc";
            if (I18n.exists((String)key)) {
                txt = Component.translatable((String)key).withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC});
                list.add(txt);
            } else if (ApothicAttributes.getTooltipFlag().isAdvanced()) {
                txt = Component.literal((String)key).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
                list.add(txt);
            }
            list.add(CommonComponents.EMPTY);
            ChatFormatting color = ChatFormatting.GRAY;
            if (attr instanceof RangedAttribute) {
                RangedAttribute ra = (RangedAttribute)attr;
                if (inst.getValue() > inst.getBaseValue()) {
                    color = ChatFormatting.YELLOW;
                } else if (inst.getValue() < inst.getBaseValue()) {
                    color = ChatFormatting.RED;
                }
            }
            MutableComponent valueComp = fAttr.toValueComponent(null, inst.getValue(), ApothicAttributes.getTooltipFlag());
            list.add(Component.translatable((String)"apothic_attributes.gui.current", (Object[])new Object[]{valueComp.withStyle(color)}).withStyle(ChatFormatting.GRAY));
            MutableComponent baseVal = fAttr.toValueComponent(null, inst.getBaseValue(), ApothicAttributes.getTooltipFlag());
            baseVal = Component.translatable((String)"apothic_attributes.gui.base", (Object[])new Object[]{baseVal});
            if (attr instanceof RangedAttribute) {
                RangedAttribute ra = (RangedAttribute)attr;
                Object min = fAttr.toValueComponent(null, ra.getMinValue(), ApothicAttributes.getTooltipFlag());
                min = Component.translatable((String)"apothic_attributes.gui.min", (Object[])new Object[]{min});
                MutableComponent max = fAttr.toValueComponent(null, ra.getMaxValue(), ApothicAttributes.getTooltipFlag());
                max = Component.translatable((String)"apothic_attributes.gui.max", (Object[])new Object[]{max});
                list.add(Component.translatable((String)"%s \u2507 %s \u2507 %s", (Object[])new Object[]{baseVal, min, max}).withStyle(ChatFormatting.GRAY));
            } else {
                list.add(baseVal.withStyle(ChatFormatting.GRAY));
            }
            ArrayList<ClientTooltipComponent> finalTooltip = new ArrayList<ClientTooltipComponent>(list.size());
            for (Object txt : list) {
                this.addComp((Component)txt, finalTooltip);
            }
            if (inst.getModifiers().stream().anyMatch(modif -> modif.getAmount() != 0.0)) {
                this.addComp(CommonComponents.EMPTY, finalTooltip);
                this.addComp((Component)Component.translatable((String)"apothic_attributes.gui.modifiers").withStyle(ChatFormatting.GOLD), finalTooltip);
                HashMap modifiersToSources = new HashMap();
                for (ModifierSourceType modifierSourceType : ModifierSourceType.getTypes()) {
                    modifierSourceType.extract((LivingEntity)this.player, (modif, source) -> modifiersToSources.put(modif.getId(), (ModifierSource<?>)source));
                }
                Component[] opValues = new Component[3];
                for (AttributeModifier.Operation operation : AttributeModifier.Operation.values()) {
                    double threshold;
                    ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>(inst.getModifiers(operation));
                    double opValue = modifiers.stream().mapToDouble(AttributeModifier::getAmount).reduce(operation == AttributeModifier.Operation.MULTIPLY_TOTAL ? 1.0 : 0.0, (res, elem) -> op == AttributeModifier.Operation.MULTIPLY_TOTAL ? res * (1.0 + elem) : res + elem);
                    modifiers.sort(ModifierSourceType.compareBySource(modifiersToSources));
                    for (AttributeModifier modif2 : modifiers) {
                        if (modif2.getAmount() == 0.0) continue;
                        MutableComponent comp = fAttr.toComponent(modif2, ApothicAttributes.getTooltipFlag());
                        ModifierSource src = (ModifierSource)modifiersToSources.get(modif2.getId());
                        finalTooltip.add(new AttributeModifierComponent(src, (FormattedText)comp, this.font, this.leftPos - 16));
                    }
                    color = ChatFormatting.GRAY;
                    double d = threshold = operation == AttributeModifier.Operation.MULTIPLY_TOTAL ? 1.0005 : 5.0E-4;
                    if (opValue > threshold) {
                        color = ChatFormatting.YELLOW;
                    } else if (opValue < -threshold) {
                        color = ChatFormatting.RED;
                    }
                    MutableComponent valueComp2 = fAttr.toValueComponent(operation, opValue, ApothicAttributes.getTooltipFlag()).withStyle(color);
                    MutableComponent comp = Component.translatable((String)("apothic_attributes.gui." + operation.name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{valueComp2}).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
                    opValues[operation.ordinal()] = comp;
                }
                if (ApothicAttributes.getTooltipFlag().isAdvanced()) {
                    this.addComp(CommonComponents.EMPTY, finalTooltip);
                    for (Component component : opValues) {
                        this.addComp(component, finalTooltip);
                    }
                }
            }
            gfx.renderTooltipInternal(this.font, finalTooltip, this.leftPos - 16 - finalTooltip.stream().map(c -> c.getWidth(this.font)).max(Integer::compare).get(), mouseY, DefaultTooltipPositioner.INSTANCE);
        }
    }

    private void addComp(Component comp, List<ClientTooltipComponent> finalTooltip) {
        if (comp == CommonComponents.EMPTY) {
            finalTooltip.add(ClientTooltipComponent.create((FormattedCharSequence)comp.getVisualOrderText()));
        } else {
            for (FormattedText fTxt : this.font.getSplitter().splitLines((FormattedText)comp, this.leftPos - 16, comp.getStyle())) {
                finalTooltip.add(ClientTooltipComponent.create((FormattedCharSequence)Language.getInstance().getVisualOrder(fTxt)));
            }
        }
    }

    private void renderEntry(GuiGraphics gfx, AttributeInstance inst, int x, int y, int mouseX, int mouseY) {
        boolean hover = this.getHoveredSlot(mouseX, mouseY) == inst;
        gfx.blit(TEXTURES, x, y, 142, hover ? 22 : 0, 100, 22);
        MutableComponent txt = Component.translatable((String)inst.getAttribute().getDescriptionId());
        int splitWidth = 60;
        List lines = this.font.split((FormattedText)txt, splitWidth);
        while (lines.size() > 2) {
            lines = this.font.split((FormattedText)txt, splitWidth += 10);
        }
        PoseStack stack = gfx.pose();
        stack.pushPose();
        float scale = 1.0f;
        int maxWidth = lines.stream().map(arg_0 -> ((Font)this.font).width(arg_0)).max(Integer::compareTo).get();
        if (maxWidth > 66) {
            scale = 66.0f / (float)maxWidth;
            stack.scale(scale, scale, 1.0f);
        }
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
            float width = (float)this.font.width(line) * scale;
            float lineX = ((float)(x + 1) + (68.0f - width) / 2.0f) / scale;
            float lineY = (float)(y + (lines.size() == 1 ? 7 : 2) + i * 10) / scale;
            gfx.drawString(this.font, line, lineX, lineY, 0x404040, false);
        }
        stack.popPose();
        stack.pushPose();
        IFormattableAttribute attr = (IFormattableAttribute)inst.getAttribute();
        MutableComponent value = attr.toValueComponent(null, inst.getValue(), (TooltipFlag)TooltipFlag.Default.NORMAL);
        scale = 1.0f;
        if (this.font.width((FormattedText)value) > 27) {
            scale = 27.0f / (float)this.font.width((FormattedText)value);
            stack.scale(scale, scale, 1.0f);
        }
        int color = 0xFFFFFF;
        if (attr instanceof RangedAttribute) {
            RangedAttribute ra = (RangedAttribute)attr;
            if (inst.getValue() > inst.getBaseValue()) {
                color = 0x55DD55;
            } else if (inst.getValue() < inst.getBaseValue()) {
                color = 0xFF6060;
            }
        } else if (attr instanceof BooleanAttribute) {
            BooleanAttribute ba = (BooleanAttribute)attr;
            if (inst.getValue() > 0.0) {
                color = 0x55DD55;
            }
        }
        gfx.drawString(this.font, (Component)value, (int)(((float)(x + 72) + (27.0f - (float)this.font.width((FormattedText)value) * scale) / 2.0f) / scale), (int)((float)(y + 7) / scale), color, true);
        stack.popPose();
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (!this.open || !this.isScrollBarActive()) {
            return false;
        }
        this.scrolling = false;
        int left = this.leftPos + 111;
        int top = this.topPos + 15;
        if (pMouseX >= (double)left && pMouseX < (double)(left + 12) && pMouseY >= (double)top && pMouseY < (double)(top + 155)) {
            this.scrolling = true;
            int i = this.topPos + 15;
            int j = i + 138;
            scrollOffset = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            scrollOffset = Mth.clamp((float)scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(scrollOffset * (float)this.getOffScreenRows()) + 0.5);
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (!this.open) {
            return false;
        }
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.topPos + 15;
            int j = i + 138;
            scrollOffset = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            scrollOffset = Mth.clamp((float)scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(scrollOffset * (float)this.getOffScreenRows()) + 0.5);
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (!this.open) {
            return false;
        }
        if (this.isScrollBarActive()) {
            int i = this.getOffScreenRows();
            scrollOffset = (float)((double)scrollOffset - pScrollY / (double)i);
            scrollOffset = Mth.clamp((float)scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(scrollOffset * (float)i) + 0.5);
            return true;
        }
        return false;
    }

    private boolean isScrollBarActive() {
        return this.data.size() > 6;
    }

    protected int getOffScreenRows() {
        return Math.max(0, this.data.size() - 6);
    }

    @Nullable
    public AttributeInstance getHoveredSlot(int mouseX, int mouseY) {
        for (int i = 0; i < 6; ++i) {
            if (this.startIndex + i >= this.data.size() || !this.isHovering(8, 14 + 22 * i, 100, 22, mouseX, mouseY)) continue;
            return this.data.get(this.startIndex + i);
        }
        return null;
    }

    protected boolean isHovering(int pX, int pY, int pWidth, int pHeight, double pMouseX, double pMouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        return (pMouseX -= (double)i) >= (double)(pX - 1) && pMouseX < (double)(pX + pWidth + 1) && (pMouseY -= (double)j) >= (double)(pY - 1) && pMouseY < (double)(pY + pHeight + 1);
    }

    public static String format(int n) {
        int log = (int)StrictMath.log10(n);
        if (log <= 4) {
            return String.valueOf(n);
        }
        if (log == 5) {
            return f.format((double)n / 1000.0) + "K";
        }
        if (log <= 8) {
            return f.format((double)n / 1000000.0) + "M";
        }
        return f.format((double)n / 1.0E9) + "B";
    }

    public void setFocused(boolean pFocused) {
    }

    public boolean isFocused() {
        return false;
    }

    public class HideUnchangedButton
    extends AbstractButton {
        public HideUnchangedButton(int pX, int pY) {
            super(pX, pY, 10, 10, (Component)Component.literal((String)"Hide Unchanged Attributes"));
            this.visible = false;
        }

        public void onPress() {
            hideUnchanged = !hideUnchanged;
        }

        public void renderWidget(GuiGraphics gfx, int pMouseX, int pMouseY, float pPartialTick) {
            int vOffset;
            int u = 131;
            int v = 20;
            int n = vOffset = hideUnchanged ? 0 : 10;
            if (this.isHovered) {
                vOffset += 20;
            }
            RenderSystem.enableDepthTest();
            PoseStack pose = gfx.pose();
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 100.0f);
            gfx.blit(TEXTURES, this.getX(), this.getY(), (float)u, (float)(v + vOffset), 10, 10, 256, 256);
            pose.popPose();
        }

        protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
            this.defaultButtonNarrationText(pNarrationElementOutput);
        }
    }
}

