/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.impl;

import dev.shadowsoffire.apothic_attributes.ALConfig;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.apothic_attributes.api.AttributeHelper;
import dev.shadowsoffire.apothic_attributes.api.IFormattableAttribute;
import dev.shadowsoffire.apothic_attributes.packet.CritParticleMessage;
import dev.shadowsoffire.apothic_attributes.util.AttributesUtil;
import dev.shadowsoffire.placebo.network.PacketDistro;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingAttackEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingHurtEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class AttributeEvents {
    private static boolean noRecurse = false;
    private static Random dodgeRand = new Random();

    @SubscribeEvent
    public void fixChangedAttributes(PlayerEvent.PlayerLoggedInEvent e) {
        AttributeMap map = e.getEntity().getAttributes();
        map.getInstance((Attribute)NeoForgeMod.STEP_HEIGHT.value()).setBaseValue(0.6);
    }

    private boolean canBenefitFromDrawSpeed(ItemStack stack) {
        return stack.getItem() instanceof ProjectileWeaponItem || stack.getItem() instanceof TridentItem;
    }

    @SubscribeEvent
    public void drawSpeed(LivingEntityUseItemEvent.Tick e) {
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof Player) {
            int mod;
            Player player = (Player)livingEntity;
            double t = player.getAttribute(ALObjects.Attributes.DRAW_SPEED.get()).getValue() - 1.0;
            if (t == 0.0 || !this.canBenefitFromDrawSpeed(e.getItem())) {
                return;
            }
            int offset = -1;
            if (t < 0.0) {
                offset = 1;
                t = -t;
            }
            while (t > 1.0) {
                e.setDuration(e.getDuration() + offset);
                t -= 1.0;
            }
            if (t > 0.5) {
                if (e.getEntity().tickCount % 2 == 0) {
                    e.setDuration(e.getDuration() + offset);
                }
                t -= 0.5;
            }
            if (e.getEntity().tickCount % (mod = (int)Math.floor(1.0 / Math.min(1.0, t))) == 0) {
                e.setDuration(e.getDuration() + offset);
            }
            double d = t - 1.0;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void lifeStealOverheal(LivingHurtEvent e) {
        Entity entity = e.getSource().getDirectEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (AttributesUtil.isPhysicalDamage(e.getSource())) {
                float lifesteal = (float)attacker.getAttributeValue(ALObjects.Attributes.LIFE_STEAL.get());
                float dmg = Math.min(e.getAmount(), e.getEntity().getHealth());
                if ((double)lifesteal > 0.001) {
                    attacker.heal(dmg * lifesteal);
                }
                float overheal = (float)attacker.getAttributeValue(ALObjects.Attributes.OVERHEAL.get());
                float maxOverheal = attacker.getMaxHealth() * 0.5f;
                if (overheal > 0.0f && attacker.getAbsorptionAmount() < maxOverheal) {
                    attacker.setAbsorptionAmount(Math.min(maxOverheal, attacker.getAbsorptionAmount() + dmg * overheal));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void meleeDamageAttributes(LivingAttackEvent e) {
        if (e.getEntity().level().isClientSide || e.getEntity().isDeadOrDying()) {
            return;
        }
        if (noRecurse) {
            return;
        }
        noRecurse = true;
        Entity entity = e.getSource().getDirectEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (AttributesUtil.isPhysicalDamage(e.getSource())) {
                float hpDmg = (float)attacker.getAttributeValue(ALObjects.Attributes.CURRENT_HP_DAMAGE.get());
                float fireDmg = (float)attacker.getAttributeValue(ALObjects.Attributes.FIRE_DAMAGE.get());
                float coldDmg = (float)attacker.getAttributeValue(ALObjects.Attributes.COLD_DAMAGE.get());
                LivingEntity target = e.getEntity();
                int time = target.invulnerableTime;
                float atkStrength = ApothicAttributes.getLocalAtkStrength((Entity)attacker);
                target.invulnerableTime = 0;
                if ((double)hpDmg > 0.001 && atkStrength >= 0.85f) {
                    target.hurt(AttributeEvents.src(ALObjects.DamageTypes.CURRENT_HP_DAMAGE, attacker), atkStrength * hpDmg * target.getHealth());
                }
                target.invulnerableTime = 0;
                if ((double)fireDmg > 0.001 && atkStrength >= 0.55f) {
                    target.hurt(AttributeEvents.src(ALObjects.DamageTypes.FIRE_DAMAGE, attacker), atkStrength * fireDmg);
                    target.setRemainingFireTicks(target.getRemainingFireTicks() + (int)(10.0f * fireDmg));
                }
                target.invulnerableTime = 0;
                if ((double)coldDmg > 0.001 && atkStrength >= 0.55f) {
                    target.hurt(AttributeEvents.src(ALObjects.DamageTypes.COLD_DAMAGE, attacker), atkStrength * coldDmg);
                    target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, (int)(15.0f * coldDmg), Mth.floor((float)(coldDmg / 5.0f))));
                }
                target.invulnerableTime = time;
                if (target.isDeadOrDying()) {
                    target.getPersistentData().putBoolean("apoth.killed_by_aux_dmg", true);
                }
            }
        }
        noRecurse = false;
    }

    private static DamageSource src(ResourceKey<DamageType> type, LivingEntity entity) {
        return entity.level().damageSources().source(type, (Entity)entity);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void apothCriticalStrike(LivingHurtEvent e) {
        LivingEntity le;
        LivingEntity attacker;
        Entity entity = e.getSource().getEntity();
        LivingEntity livingEntity = attacker = entity instanceof LivingEntity ? (le = (LivingEntity)entity) : null;
        if (attacker == null) {
            return;
        }
        double critChance = attacker.getAttributeValue(ALObjects.Attributes.CRIT_CHANCE.get());
        RandomSource rand = e.getEntity().getRandom();
        float critMult = 1.0f;
        for (float critDmg = (float)attacker.getAttributeValue(ALObjects.Attributes.CRIT_DAMAGE.get()); (double)rand.nextFloat() <= critChance && critDmg > 1.0f; critDmg *= 0.85f) {
            critChance -= 1.0;
            critMult *= critDmg;
        }
        e.setAmount(e.getAmount() * critMult);
        if (critMult > 1.0f && !attacker.level().isClientSide) {
            PacketDistro.sendToTracking((CustomPacketPayload)new CritParticleMessage(e.getEntity().getId()), (ServerLevel)((ServerLevel)attacker.level()), (BlockPos)e.getEntity().blockPosition());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void vanillaCritDmg(CriticalHitEvent e) {
        float critDmg = (float)e.getEntity().getAttributeValue(ALObjects.Attributes.CRIT_DAMAGE.get());
        if (e.isVanillaCritical()) {
            e.setDamageModifier(Math.max(e.getDamageModifier(), critDmg));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void breakSpd(PlayerEvent.BreakSpeed e) {
        e.setNewSpeed(e.getNewSpeed() * (float)e.getEntity().getAttributeValue(ALObjects.Attributes.MINING_SPEED.get()));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void blockBreak(BlockEvent.BreakEvent e) {
        double xpMult = e.getPlayer().getAttributeValue(ALObjects.Attributes.EXPERIENCE_GAINED.get());
        e.setExpToDrop((int)((double)e.getExpToDrop() * xpMult));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void mobXp(LivingExperienceDropEvent e) {
        Player player = e.getAttackingPlayer();
        if (player == null) {
            return;
        }
        double xpMult = e.getAttackingPlayer().getAttributeValue(ALObjects.Attributes.EXPERIENCE_GAINED.get());
        e.setDroppedExperience((int)((double)e.getDroppedExperience() * xpMult));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void heal(LivingHealEvent e) {
        float factor = (float)e.getEntity().getAttributeValue(ALObjects.Attributes.HEALING_RECEIVED.get());
        e.setAmount(e.getAmount() * factor);
        if (e.getAmount() <= 0.0f) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void arrow(EntityJoinLevelEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)entity;
            if (arrow.level().isClientSide || arrow.getPersistentData().getBoolean("apothic_attributes.arrow.done")) {
                return;
            }
            Entity entity2 = arrow.getOwner();
            if (entity2 instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity2;
                arrow.setBaseDamage(arrow.getBaseDamage() * le.getAttributeValue(ALObjects.Attributes.ARROW_DAMAGE.get()));
                arrow.setDeltaMovement(arrow.getDeltaMovement().scale(le.getAttributeValue(ALObjects.Attributes.ARROW_VELOCITY.get())));
            }
            arrow.getPersistentData().putBoolean("apothic_attributes.arrow.done", true);
        }
    }

    private static double getAttackReachSqr(Entity attacker, LivingEntity pAttackTarget) {
        return attacker.getBbWidth() * 2.0f * attacker.getBbWidth() * 2.0f + pAttackTarget.getBbWidth();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void dodge(LivingAttackEvent e) {
        LivingEntity target = e.getEntity();
        if (target.level().isClientSide) {
            return;
        }
        Entity attacker = e.getSource().getDirectEntity();
        if (attacker instanceof LivingEntity) {
            double d;
            double dodgeChance = target.getAttributeValue(ALObjects.Attributes.DODGE_CHANCE.get());
            if (attacker instanceof Player) {
                Player p = (Player)attacker;
                d = p.getEntityReach() * p.getEntityReach();
            } else {
                d = AttributeEvents.getAttackReachSqr(attacker, target);
            }
            double atkRangeSqr = d;
            dodgeRand.setSeed(target.tickCount);
            if (attacker.distanceToSqr((Entity)target) <= atkRangeSqr && (double)dodgeRand.nextFloat() <= dodgeChance) {
                this.onDodge(target);
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void dodge(ProjectileImpactEvent e) {
        Entity target;
        HitResult hitResult = e.getRayTraceResult();
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entRes = (EntityHitResult)hitResult;
            v0 = entRes.getEntity();
        } else {
            v0 = target = null;
        }
        if (target instanceof LivingEntity) {
            LivingEntity lvTarget = (LivingEntity)target;
            double dodgeChance = lvTarget.getAttributeValue(ALObjects.Attributes.DODGE_CHANCE.get());
            dodgeRand.setSeed(target.tickCount);
            if ((double)dodgeRand.nextFloat() <= dodgeChance) {
                this.onDodge(lvTarget);
                e.setCanceled(true);
            }
        }
    }

    private void onDodge(LivingEntity target) {
        target.level().playSound(null, (Entity)target, (SoundEvent)ALObjects.Sounds.DODGE.value(), SoundSource.NEUTRAL, 1.0f, 0.7f + target.getRandom().nextFloat() * 0.3f);
        Level level = target.level();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            double height = target.getBbHeight();
            double width = target.getBbWidth();
            sl.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, target.getX() - width / 4.0, target.getY(), target.getZ() - width / 4.0, 6, -width / 4.0, height / 8.0, -width / 4.0, 0.0);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void fixMCF9370(ProjectileImpactEvent e) {
        if (e.isCanceled()) {
            AbstractArrow arrow;
            Entity entity;
            HitResult hitResult = e.getRayTraceResult();
            if (hitResult instanceof EntityHitResult) {
                EntityHitResult entRes = (EntityHitResult)hitResult;
                entity = entRes.getEntity();
            } else {
                entity = null;
            }
            Entity target = entity;
            Projectile proj = e.getProjectile();
            if (target != null && proj instanceof AbstractArrow && (arrow = (AbstractArrow)proj).getPierceLevel() > 0) {
                if (arrow.piercingIgnoreEntityIds == null) {
                    arrow.piercingIgnoreEntityIds = new IntOpenHashSet((int)arrow.getPierceLevel());
                }
                arrow.piercingIgnoreEntityIds.add(target.getId());
            }
        }
    }

    @SubscribeEvent
    public void affixModifiers(ItemAttributeModifierEvent e) {
        boolean hasBaseAR;
        boolean hasBaseAD = e.getModifiers().get((Object)Attributes.ATTACK_DAMAGE).stream().filter(m -> ((IFormattableAttribute)Attributes.ATTACK_DAMAGE).getBaseUUID().equals(m.getId())).findAny().isPresent();
        if (hasBaseAD && !(hasBaseAR = e.getModifiers().get((Object)((Attribute)NeoForgeMod.ENTITY_REACH.value())).stream().filter(m -> ((IFormattableAttribute)NeoForgeMod.ENTITY_REACH.value()).getBaseUUID().equals(m.getId())).findAny().isPresent())) {
            e.addModifier((Attribute)NeoForgeMod.ENTITY_REACH.value(), new AttributeModifier(AttributeHelper.BASE_ENTITY_REACH, "apothic_attributes:fake_base_range", 0.0, AttributeModifier.Operation.ADDITION));
        }
        if (e.getSlotType() == EquipmentSlot.CHEST && e.getItemStack().getItem() instanceof ElytraItem && !e.getModifiers().containsKey((Object)ALObjects.Attributes.ELYTRA_FLIGHT.get())) {
            e.addModifier(ALObjects.Attributes.ELYTRA_FLIGHT.get(), new AttributeModifier(AttributeHelper.ELYTRA_FLIGHT_UUID, "apothic_attributes:elytra_item_flight", 1.0, AttributeModifier.Operation.ADDITION));
        }
    }

    @SubscribeEvent
    public void reloads(AddReloadListenerEvent e) {
        e.addListener((PreparableReloadListener)ALConfig.makeReloader());
    }
}

