/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.impl;

import dev.shadowsoffire.apothic_attributes.api.IFormattableAttribute;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class BooleanAttribute
extends RangedAttribute
implements IFormattableAttribute {
    public BooleanAttribute(String pDescriptionId, boolean defaultValue) {
        super(pDescriptionId, defaultValue ? 1.0 : 0.0, 0.0, Double.MAX_VALUE);
    }

    @Override
    public MutableComponent toValueComponent(@Nullable AttributeModifier.Operation op, double value, TooltipFlag flag) {
        if (op == null) {
            return Component.translatable((String)("apothic_attributes.value.boolean." + (value > 0.0 ? "enabled" : "disabled")));
        }
        if (op == AttributeModifier.Operation.ADDITION && (int)value == 1) {
            return Component.translatable((String)"apothic_attributes.value.boolean.enable");
        }
        if (op == AttributeModifier.Operation.MULTIPLY_TOTAL && (int)value == -1) {
            return Component.translatable((String)"apothic_attributes.value.boolean.force_disable");
        }
        return Component.translatable((String)"apothic_attributes.value.boolean.invalid");
    }

    @Override
    public MutableComponent toComponent(AttributeModifier modif, TooltipFlag flag) {
        Attribute attr = this.ths();
        double value = modif.getAmount();
        MutableComponent comp = value > 0.0 ? Component.translatable((String)"apothic_attributes.modifier.bool", (Object[])new Object[]{this.toValueComponent(modif.getOperation(), value, flag), Component.translatable((String)attr.getDescriptionId())}).withStyle(ChatFormatting.BLUE) : Component.translatable((String)"apothic_attributes.modifier.bool", (Object[])new Object[]{this.toValueComponent(modif.getOperation(), value *= -1.0, flag), Component.translatable((String)attr.getDescriptionId())}).withStyle(ChatFormatting.RED);
        return comp.append(this.getDebugInfo(modif, flag));
    }

    public double sanitizeValue(double value) {
        return Math.max(value, 0.0);
    }
}

